/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceBuffer;
import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.Util;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;

public final class MultiTraceFile
extends TraceFile {
    private static final int RADIX = 36;
    private Vector fileBuffers = new Vector(36);
    private int newest = 0;
    private BigInteger bigTime = BigInteger.ZERO;

    public MultiTraceFile(String string, int n) throws Exception {
        int n2 = 0;
        char c = Integer.toString(n2, 36).toUpperCase().charAt(0);
        File file = new File(string.replace('#', c));
        this.fileBuffers.addElement(this.readFile(file));
        int n3 = this.getGenerations((byte[])this.fileBuffers.elementAt(0));
        n2 = 1;
        while (n2 < n3) {
            c = Integer.toString(n2, 36).toUpperCase().charAt(0);
            file = new File(string.replace('#', c));
            this.fileBuffers.addElement(this.readFile(file));
            ++n2;
        }
    }

    private int getGenerations(byte[] byArray) {
        this.header = this.createHeader(byArray);
        String string = Util.getProperty("GENERATIONS", "0");
        return Integer.parseInt(string);
    }

    protected Vector readData() {
        Vector vector = new Vector(36);
        Vector vector2 = null;
        int n = Integer.MAX_VALUE;
        TraceBuffer traceBuffer = null;
        int n2 = 0;
        while (n2 < this.fileBuffers.size()) {
            byte[] byArray = (byte[])this.fileBuffers.elementAt(n2);
            int n3 = byArray.length;
            this.header = this.createHeader(byArray);
            vector2 = this.readTraceBuffers(this.header, byArray);
            traceBuffer = (TraceBuffer)vector2.elementAt(0);
            BigInteger bigInteger = traceBuffer.getLatestTimeStamp();
            if (bigInteger.compareTo(this.bigTime) > 0) {
                this.bigTime = bigInteger;
                this.newest = 0;
            } else {
                ++this.newest;
            }
            vector.add(0, vector2);
            ++n2;
        }
        return vector;
    }

    protected void processData(Vector vector) {
        int n = this.findNewestFile(vector);
        int n2 = 0;
        while (n2 < vector.size()) {
            Object[] objectArray = ((Vector)vector.elementAt(n)).toArray();
            int n3 = this.findNewest(objectArray);
            this.readEntriesFromBuffers(objectArray, n3);
            n = (n + 1) % vector.size();
            ++n2;
        }
    }

    protected void computeSummary(Vector vector) throws IOException {
        int n = 0;
        while (n < vector.size()) {
            super.computeSummary((Vector)vector.elementAt(n));
            ++n;
        }
    }

    protected final int findNewest(Object[] objectArray) {
        return 0;
    }

    protected final int findNewestFile(Vector vector) {
        return this.newest;
    }
}

