/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.MessageFile;
import com.ibm.jvm.format.TraceEntry;
import com.ibm.jvm.format.TraceEntryList;
import com.ibm.jvm.format.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collections;

public final class OutputFile
extends File {
    BufferedWriter out;
    MessageFile messageFile;
    static final String header = "                Trace Formatted Data ";
    static String headings = "ThreadID         TP id  Type         TraceEntry ";

    public OutputFile(String string) {
        super(string);
        try {
            String string2 = System.getProperty("ibm.dg.trc.format", ".");
            System.out.println("Looking for TraceFormat.dat in " + string2);
            this.out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this)));
            this.messageFile = new MessageFile(Util.getProperty("MESSAGE_FILE_NAME", string2 + File.separator + "TraceFormat.dat"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("OutputFile: " + fileNotFoundException);
            System.exit(2);
        }
        catch (IOException iOException) {
            System.out.println("OutputFile: " + iOException);
            System.exit(3);
        }
    }

    protected void format(TraceEntryList traceEntryList) {
        try {
            System.out.println("*** starting formatting of entries");
            this.out.write(header, 0, header.length());
            this.out.newLine();
            this.out.newLine();
            if (Integer.valueOf(Util.getProperty("POINTER_SIZE")) == 4) {
                headings = "ThreadID TP id  Type         TraceEntry ";
            }
            this.out.write(Util.getTimerDescription() + headings, 0, headings.length() + Util.getTimerDescription().length());
            this.out.newLine();
            System.out.println("*** about to sort ");
            Collections.sort(traceEntryList);
            System.out.println("*** sorted");
            String string = ((TraceEntry)traceEntryList.getLast()).getTimeStamp().toString(16);
            TraceEntry.maxTimeLength = string.length();
            while (!traceEntryList.isEmpty()) {
                TraceEntry traceEntry = (TraceEntry)traceEntryList.removeFirst();
                if (traceEntry == null || !Util.doFormat(traceEntry)) continue;
                String string2 = traceEntry.format();
                this.out.write(string2, 0, string2.length());
                this.out.newLine();
            }
            this.out.flush();
            System.out.println("*** formatted ");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.out.println("OutputFile.format(): " + exception);
        }
    }

    protected BufferedWriter getWriter() {
        return this.out;
    }
}

