/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.Util;
import com.ibm.jvm.format.VariableSection;
import java.io.BufferedWriter;
import java.io.IOException;

class ProcVariableSection
extends VariableSection {
    static final int ARCH = 32;
    static final int IS_BIG = 36;
    static final int WORD_SIZE = 40;
    static final int ON_LINE = 44;
    static final int SUB_TYPE = 64;
    static final int TRACE_COUNTER = 68;
    static final String[] Archs = new String[]{"Unknown", "x86", "S390", "Power", "IA64"};
    static final String[] SubTypes = new String[]{"i486", "i586", "Pentium II", "Pentium III", "Merced", "McKinley", "PowerRS", "PowerPC", "GigaProcessor", "ESA"};
    static final String[] trCounter = new String[]{"Sequence Counter", "Special", "RDTSC Timer", "AIX Timer", "MFSPR Timer", "MFTB Timer", "STCK Timer"};
    private int arch;
    private boolean big;
    private int procs;
    private int subType;
    private int word;
    private int counter;

    public ProcVariableSection(int n, byte[] byArray, int n2, boolean bl) {
        super(n, byArray, n2, bl);
    }

    protected final void process() {
        if (this.versionInfo != 1L) {
            System.out.println("Can't parse Processor info due to incompatible Version = " + this.versionInfo);
            return;
        }
        this.arch = (int)Util.constructUnsignedInt(this.data, 32);
        this.big = (int)Util.constructUnsignedInt(this.data, 36) != 0;
        this.word = (int)Util.constructUnsignedInt(this.data, 40);
        this.procs = (int)Util.constructUnsignedInt(this.data, 44);
        this.subType = (int)Util.constructUnsignedInt(this.data, 64);
        this.counter = (int)Util.constructUnsignedInt(this.data, 68);
        Util.setTimerType(this.counter);
    }

    protected final void summary(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(VariableSection.names[this.type]);
        bufferedWriter.newLine();
        bufferedWriter.write("        Arch family " + Archs[this.arch]);
        bufferedWriter.newLine();
        bufferedWriter.write("        Processor Sub-type " + SubTypes[this.subType]);
        bufferedWriter.newLine();
        bufferedWriter.write("        Num Processors " + this.procs);
        bufferedWriter.newLine();
        bufferedWriter.write("        Big Endian " + this.big);
        bufferedWriter.newLine();
        bufferedWriter.write("        Word size " + this.word);
        bufferedWriter.newLine();
        bufferedWriter.write("        Using Trace Counter " + trCounter[this.counter]);
        bufferedWriter.newLine();
        bufferedWriter.newLine();
    }
}

