/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.format.Util;
import java.math.BigInteger;

public final class TraceBufferHeader {
    private byte[] data = null;
    private BigInteger timeStamp;
    private BigInteger wrapTime;
    private BigInteger writePlatform = BigInteger.ZERO;
    private BigInteger writeSystem = BigInteger.ZERO;
    private String threadName;
    private long threadID;
    private long offset;
    protected static int TIMESTAMP_OFFSET = 0;
    protected static int WRAPTIME_OFFSET = 8;
    protected static int WRITE_PLATFORM_OFFSET;
    protected static int WRITE_SYSTEM_OFFSET;
    protected static int THREADID_OFFSET;
    protected static int THREADNAME_OFFSET;
    protected static int NEXTENTRY_OFFSET;
    protected static int HEADER_LENGTH;

    protected TraceBufferHeader(byte[] byArray) {
        this.data = byArray;
        this.timeStamp = Util.constructUnsignedLong(byArray, TIMESTAMP_OFFSET);
        this.wrapTime = Util.constructUnsignedLong(byArray, WRAPTIME_OFFSET);
        if ((double)TraceFormat.verMod >= 1.1) {
            this.writePlatform = Util.constructUnsignedLong(byArray, WRITE_PLATFORM_OFFSET);
            this.writeSystem = Util.constructUnsignedLong(byArray, WRITE_SYSTEM_OFFSET);
        }
        this.threadID = (double)TraceFormat.verMod >= 1.1 ? Util.constructUnsignedLong(byArray, THREADID_OFFSET).longValue() : Util.constructUnsignedInt(byArray, THREADID_OFFSET);
        this.threadName = Util.constructString(byArray, THREADNAME_OFFSET);
        this.offset = Util.constructUnsignedInt(byArray, NEXTENTRY_OFFSET);
        Util.Debug.println("*********************************************************");
        Util.Debug.println("TraceBufferHeader: timeStamp: 0x" + this.timeStamp.toString(16));
        Util.Debug.println("TraceBufferHeader: threadID: 0x" + Long.toString(this.threadID, 16));
        Util.Debug.println("TraceBufferHeader: offset: " + this.offset);
        Util.Debug.println("*********************************************************");
    }

    protected BigInteger getLastTimeStamp() {
        return this.timeStamp;
    }

    protected BigInteger getWrapTime() {
        return this.wrapTime;
    }

    protected BigInteger getWritePlatform() {
        return this.writePlatform;
    }

    protected BigInteger getWriteSystem() {
        return this.writeSystem;
    }

    protected String getThreadName() {
        return this.threadName;
    }

    protected BigInteger getUpperWordOfTimeStamp() {
        return this.timeStamp.shiftRight(32);
    }

    protected long getThreadID() {
        return this.threadID;
    }

    protected long getNextEntryOffset() {
        return this.offset;
    }

    public final String toString() {
        return "TraceBufferHeader threadName = " + this.threadName + " ID = " + this.threadID;
    }

    static {
        THREADID_OFFSET = 16;
        THREADNAME_OFFSET = 20;
        NEXTENTRY_OFFSET = 44;
        HEADER_LENGTH = 48;
    }
}

