/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.SpannedTraceEntry;
import com.ibm.jvm.format.TraceBuffer;
import com.ibm.jvm.format.TraceBufferHeader;
import com.ibm.jvm.format.TraceEntry;
import com.ibm.jvm.format.Util;
import java.math.BigInteger;

public final class TraceEntryFactory {
    protected static BigInteger upperWord = BigInteger.ZERO;
    protected static BigInteger lowerWord = BigInteger.ZERO;
    protected static BigInteger wrapTime = BigInteger.ZERO;
    protected static int initialOffset = 0;
    protected static boolean passedOnce = false;
    protected static final BigInteger MASK = new BigInteger("11111111111111111111111111111111", 2);

    protected TraceEntryFactory() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected TraceEntry readEntry(byte[] byArray, int n, long l) {
        int n2;
        int n3;
        TraceEntry traceEntry = null;
        int n4 = Util.constructUnsignedByte(byArray, n);
        if (n4 == 4) {
            int n5 = n - 4;
            n3 = byArray[n5];
            n2 = Util.constructTraceID(byArray, n5 + 1);
            if (0 < n2 && n2 < 256) {
                n4 = n2 << 8 | n3;
                n -= 4;
            }
        }
        if (TraceBuffer.traceType == 0 && passedOnce && n4 > n - initialOffset) {
            Util.Debug.println("***** garbage entry would have been length " + n4);
            return traceEntry;
        }
        if (n4 > n - TraceBufferHeader.HEADER_LENGTH) {
            byte[] byArray2 = new byte[n4];
            n3 = n - TraceBufferHeader.HEADER_LENGTH;
            n2 = n4 - n3;
            n = byArray.length - n2;
            System.arraycopy(byArray, TraceBufferHeader.HEADER_LENGTH, byArray2, n2, n3);
            if (TraceBuffer.traceType != 0) return new SpannedTraceEntry(n, l, n4, byArray2, n3);
            System.arraycopy(byArray, n, byArray2, 0, n2);
            passedOnce = true;
            traceEntry = new TraceEntry(n, l, n4);
            traceEntry.init(byArray2, 0, upperWord);
        } else {
            traceEntry = new TraceEntry(n -= n4, l, n4);
            traceEntry.init(byArray, n, upperWord);
        }
        if (traceEntry.getTraceID() != 0) return traceEntry;
        if (n4 != 8) return traceEntry;
        upperWord = traceEntry.getTimeStamp().and(MASK);
        return this.readEntry(byArray, n, l);
    }

    protected static void setUpperWord(BigInteger bigInteger) {
        upperWord = bigInteger;
    }

    protected static void setWrapTime(BigInteger bigInteger) {
        wrapTime = bigInteger;
    }

    protected static BigInteger getWrapTime() {
        return wrapTime;
    }

    protected static void setPassedOnce(boolean bl) {
        passedOnce = bl;
    }

    protected static void setInitialOffset(int n) {
        initialOffset = n;
    }
}

