/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.Message;
import com.ibm.jvm.format.OutputFile;
import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.Util;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.util.Vector;

public final class TraceFormat {
    protected TraceFile traceFile = null;
    protected OutputFile outputFile = null;
    protected boolean indent = false;
    protected boolean summary = false;
    protected boolean gui = false;
    protected static long versionInfo;
    protected static long modificationInfo;
    protected static float verMod;
    protected static BigInteger startSystem;
    protected static BigInteger startPlatform;
    protected static byte ENTRY_TYPE;
    protected static byte EXIT_TYPE;
    protected static byte EVENT_TYPE;
    protected static byte EXCEPTION_TYPE;
    protected static byte MEM_TYPE;
    protected static byte DEBUG_TYPE;
    protected static byte PERF_TYPE;
    protected static byte MAX_TYPES;
    protected static byte ENTRY_EXCPT_TYPE;
    protected static byte EXIT_EXCPT_TYPE;
    protected static byte MEM_EXCPT_TYPE;
    protected static byte DEBUG_EXCPT_TYPE;
    protected static byte PERF_EXCPT_TYPE;
    protected static String[] types;
    protected static String[] Chars;
    protected static final String usageMessage = "Usage: java format.TraceFormat input_filespec [output_filespec] \n\t[-summary] [ -entries:comp[(class,...),...]] [-thread:threadid,...] \n\t[-indent] [-symbolic]";

    public static void main(String[] stringArray) {
        TraceFormat traceFormat = new TraceFormat();
        traceFormat.readAndFormat(stringArray);
    }

    private void readAndFormat(String[] stringArray) {
        try {
            this.gui = this.parseArgs(stringArray);
            if (!this.gui) {
                boolean bl = Boolean.valueOf(Util.getProperty("SUMMARY"));
                this.traceFile.parse();
                Message.setPointerSize();
                if (bl) {
                    this.traceFile.doSummary(new BufferedWriter(new OutputStreamWriter(System.out)));
                } else {
                    this.traceFile.doSummary(this.outputFile.getWriter());
                    this.outputFile.format(this.traceFile.getEntryList());
                }
            }
        }
        catch (UsageException usageException) {
            System.out.println("TraceFormat Usage: java format.TraceFormat input_filespec [output_filespec] \n\t[-summary] [ -entries:comp[(class,...),...]] [-thread:threadid,...] \n\t[-indent] [-symbolic]");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private boolean parseArgs(String[] stringArray) throws UsageException, Exception {
        boolean bl = false;
        if (stringArray.length > 0) {
            this.traceFile = TraceFile.getFile(stringArray[0]);
            if (stringArray.length > 1) {
                int n;
                if (stringArray[1].startsWith("-")) {
                    this.outputFile = new OutputFile(stringArray[0] + ".fmt");
                    n = 1;
                } else {
                    this.outputFile = new OutputFile(stringArray[1]);
                    n = 2;
                }
                while (n < stringArray.length) {
                    if (stringArray[n].equals("-summary")) {
                        Util.setProperty("SUMMARY", "true");
                    } else if (stringArray[n].startsWith("-entries:")) {
                        this.parseComponentParameter(stringArray[n]);
                    } else if (stringArray[n].startsWith("-thread:")) {
                        this.parseThread(stringArray[n]);
                    } else if (stringArray[n].equals("-indent")) {
                        Util.setProperty("INDENT", "true");
                    } else if (stringArray[n].equals("-symbolic")) {
                        Util.setProperty("SYMBOLIC", "true");
                    } else if (stringArray[n].equals("-debug")) {
                        Util.Debug.setDebug();
                    } else {
                        throw new UsageException();
                    }
                    ++n;
                }
            } else {
                this.outputFile = new OutputFile(stringArray[0] + ".fmt");
            }
        } else {
            throw new UsageException();
        }
        return bl;
    }

    private void parseComponentParameter(String string) throws UsageException {
        String string2 = string.substring("-entries:".length());
        this.parseComponents(string2);
    }

    private void parseComponents(String string) throws UsageException {
        int n = string.indexOf("(");
        int n2 = string.indexOf(",");
        if (n2 != -1) {
            if (n2 < n) {
                this.parseComponent(string.substring(0, n2));
                this.parseComponents(string.substring(n2 + 1, string.length()));
            } else {
                int n3 = string.indexOf(")");
                this.parseComponent(string.substring(0, n3 + 1));
                int n4 = string.indexOf(",", n3);
                if (n4 != -1) {
                    this.parseComponents(string.substring(n4 + 1, string.length()));
                }
            }
        } else {
            this.parseComponent(string);
        }
    }

    private void parseComponent(String string) throws UsageException {
        int n = string.indexOf("(");
        int n2 = string.indexOf(")");
        if (n2 < n) {
            throw new UsageException();
        }
        if (n2 == n) {
            Util.putComponent(string);
        } else {
            int n3;
            Vector vector = new Vector(10);
            String string2 = string.substring(n + 1, string.length() - 1);
            while ((n3 = string2.indexOf(",")) != -1) {
                vector.addElement(string2.substring(0, n3));
                string2 = string2.substring(n3 + 1, string2.length());
            }
            vector.addElement(string2.substring(0, string2.length()));
            Util.putComponent(string.substring(0, n), vector);
        }
    }

    private void parseThread(String string) throws UsageException {
        try {
            int n;
            String string2 = string.substring("-thread:".length());
            while ((n = string2.indexOf(",")) != -1) {
                Util.putThreadID(Long.decode(string2.substring(0, n)));
                string2 = string2.substring(n + 1, string2.length());
            }
            Util.putThreadID(Long.decode(string2.substring(0, string2.length())));
        }
        catch (NumberFormatException numberFormatException) {
            throw new UsageException("Bad thread ID");
        }
    }

    static {
        ENTRY_TYPE = 0;
        EXIT_TYPE = 1;
        EVENT_TYPE = (byte)2;
        EXCEPTION_TYPE = (byte)3;
        MEM_TYPE = (byte)4;
        DEBUG_TYPE = (byte)5;
        PERF_TYPE = (byte)6;
        MAX_TYPES = (byte)7;
        ENTRY_EXCPT_TYPE = (byte)3;
        EXIT_EXCPT_TYPE = (byte)5;
        MEM_EXCPT_TYPE = (byte)7;
        DEBUG_EXCPT_TYPE = (byte)9;
        PERF_EXCPT_TYPE = (byte)11;
        types = new String[]{"Entry     ", "Exit      ", "Event     ", "Exception ", "Mem       ", "Debug     ", "Perf      ", "Unused    ", "Unused    ", "Unused    ", "Unused    ", "Unused    "};
        Chars = new String[]{">", "<", "-", "*", " ", " ", " ", " ", " ", " ", " ", " "};
    }

    class UsageException
    extends Exception {
        UsageException(String string) {
            super(string);
        }

        UsageException() {
        }
    }
}

