/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi;

import com.ibm.rmi.MarshalInputStream;
import com.ibm.rmi.MarshalOutputStream;
import sun.io.CharacterEncoding;

public final class CodeSetComponentInfo {
    public static final int ASCII = 65537;
    public static final int ISO646 = 65568;
    public static final int UNICODE = 65792;
    public static final int MS1252 = 268567780;
    public static final int PCSJIS = 268567471;
    public static final int LATIN15 = 65551;
    public static final int UTF8 = 0x5010001;
    public static final int UTF16 = 65801;
    public CodeSetComponent forCharData = new CodeSetComponent(65537, null);
    public CodeSetComponent forWCharData = new CodeSetComponent(0, null);

    public CodeSetComponentInfo() {
    }

    public CodeSetComponentInfo(String string) {
        this();
        if (string != null) {
            this.forCharData = new CodeSetComponent(CodeSetComponentInfo.mapRegistryId(string), null);
            this.forWCharData = new CodeSetComponent(65792, null);
            int n = this.forCharData.nativeCodeSet;
            if (n == 65537 || n == 268567780 || n == 65551 || n == 0x5010001) {
                this.forCharData.conversionCodeSets = new int[]{65568};
            }
        }
    }

    public void read(MarshalInputStream marshalInputStream) {
        this.forCharData.read(marshalInputStream);
        this.forWCharData.read(marshalInputStream);
    }

    public void write(MarshalOutputStream marshalOutputStream) {
        this.forCharData.write(marshalOutputStream);
        this.forWCharData.write(marshalOutputStream);
    }

    public boolean validate(CodeSetContext codeSetContext) {
        return this.forCharData.validateWith(codeSetContext.char_data, 0x5010001) && this.forWCharData.validateWith(codeSetContext.wchar_data, 65801);
    }

    public CodeSetContext negotiate(CodeSetComponentInfo codeSetComponentInfo) {
        if (codeSetComponentInfo == null) {
            return new CodeSetContext(65537, 0);
        }
        int n = this.forCharData.negotiateWith(codeSetComponentInfo.forCharData, 0x5010001);
        int n2 = this.forWCharData.negotiateWith(codeSetComponentInfo.forWCharData, 65801);
        return new CodeSetContext(n, n2);
    }

    public static int mapRegistryId(String string) {
        String string2 = CharacterEncoding.aliasName(string);
        if (string2 == null) {
            string2 = string;
        }
        int n = 0x5010001;
        if (string2.equals("ISO8859_1")) {
            n = 65537;
        } else if (string2.equals("ISO8859_15_FDIS")) {
            n = 65551;
        } else if (string2.equals("Cp1252")) {
            n = 268567780;
        } else if (string2.equals("Cp943") || string2.equals("Cp943C")) {
            n = 268567471;
        }
        return n;
    }

    public static String mapRegistryId(int n) {
        String string;
        switch (n) {
            case 65537: {
                string = "ISO8859_1";
                break;
            }
            case 65551: {
                string = "ISO8859_15_FDIS";
                break;
            }
            case 268567780: {
                string = "Cp1252";
                break;
            }
            case 268567471: {
                string = "Cp943C";
                break;
            }
            case 0x5010001: {
                string = "UTF8";
                break;
            }
            default: {
                string = "ISO8859_1";
            }
        }
        return string;
    }

    public static final class CodeSetContext {
        public int char_data;
        public int wchar_data;

        public CodeSetContext() {
        }

        public CodeSetContext(int n, int n2) {
            this.char_data = n;
            this.wchar_data = n2;
        }

        public void read(MarshalInputStream marshalInputStream) {
            this.char_data = marshalInputStream.read_ulong();
            this.wchar_data = marshalInputStream.read_ulong();
        }

        public void write(MarshalOutputStream marshalOutputStream) {
            marshalOutputStream.write_ulong(this.char_data);
            marshalOutputStream.write_ulong(this.wchar_data);
        }
    }

    public static final class CodeSetComponent {
        public int nativeCodeSet;
        public int[] conversionCodeSets;

        public CodeSetComponent(int n, int[] nArray) {
            this.nativeCodeSet = n;
            this.conversionCodeSets = nArray == null ? new int[0] : nArray;
        }

        public void read(MarshalInputStream marshalInputStream) {
            this.nativeCodeSet = marshalInputStream.read_ulong();
            int n = marshalInputStream.read_long();
            this.conversionCodeSets = new int[n];
            marshalInputStream.read_ulong_array(this.conversionCodeSets, 0, n);
        }

        public void write(MarshalOutputStream marshalOutputStream) {
            marshalOutputStream.write_ulong(this.nativeCodeSet);
            marshalOutputStream.write_long(this.conversionCodeSets.length);
            marshalOutputStream.write_ulong_array(this.conversionCodeSets, 0, this.conversionCodeSets.length);
        }

        boolean validateWith(int n, int n2) {
            if (n == this.nativeCodeSet || n == n2) {
                return true;
            }
            int n3 = 0;
            while (n3 < this.conversionCodeSets.length) {
                if (n == this.conversionCodeSets[n3]) {
                    return true;
                }
                ++n3;
            }
            return false;
        }

        int negotiateWith(CodeSetComponent codeSetComponent, int n) {
            if (codeSetComponent.nativeCodeSet == this.nativeCodeSet) {
                return codeSetComponent.nativeCodeSet;
            }
            int n2 = 0;
            while (n2 < this.conversionCodeSets.length) {
                if (codeSetComponent.nativeCodeSet == this.conversionCodeSets[n2]) {
                    return codeSetComponent.nativeCodeSet;
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < codeSetComponent.conversionCodeSets.length) {
                if (this.nativeCodeSet == codeSetComponent.conversionCodeSets[n3]) {
                    return this.nativeCodeSet;
                }
                ++n3;
            }
            int n4 = 0;
            while (n4 < codeSetComponent.conversionCodeSets.length) {
                int n5 = 0;
                while (n5 < this.conversionCodeSets.length) {
                    if (codeSetComponent.conversionCodeSets[n4] == this.conversionCodeSets[n5]) {
                        return codeSetComponent.conversionCodeSets[n4];
                    }
                    ++n5;
                }
                ++n4;
            }
            return n;
        }
    }
}

