/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi;

import com.ibm.rmi.CodeSetComponentInfo;
import com.ibm.rmi.MarshalInputStream;
import com.ibm.rmi.MarshalOutputStream;
import com.ibm.rmi.ORB;
import com.ibm.rmi.Profile;
import com.ibm.rmi.util.HexOutputStream;
import com.ibm.rmi.util.JDKBridge;
import java.io.IOException;
import java.io.StringWriter;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;

public class IOR {
    public static final IOR NULL = new IOR();
    protected String typeId;
    protected int[] profileTags;
    protected byte[][] profileData;
    protected ORB factory;
    protected Profile iop;
    protected String codebase;
    protected boolean cachedCodebase = false;
    private static Profile.TaggedComponent localCodeBaseTC = null;
    public static final int InternetIOPTag = 0;

    private IOR() {
        this.factory = null;
        this.typeId = "";
        this.profileTags = new int[0];
    }

    public IOR(ORB oRB) {
        this.factory = oRB;
    }

    public IOR(ORB oRB, String string, String string2, int n, byte[] byArray) throws SystemException {
        this(oRB, string, string2, n, byArray, null);
    }

    public IOR(ORB oRB, String string, String string2, int n, byte[] byArray, Object object) throws SystemException {
        this(oRB);
        this.typeId = string;
        Profile.TaggedComponent taggedComponent = this.createCodeSetComponent();
        Profile.TaggedComponent taggedComponent2 = this.createCodebaseComponent(object);
        this.setProfile(string2, n, byArray, taggedComponent, taggedComponent2);
    }

    protected void setProfile(String string, int n, byte[] byArray, Profile.TaggedComponent taggedComponent, Profile.TaggedComponent taggedComponent2) {
        Profile.TaggedComponent[] taggedComponentArray = taggedComponent2 == null ? new Profile.TaggedComponent[]{taggedComponent} : new Profile.TaggedComponent[]{taggedComponent, taggedComponent2};
        Profile profile = new Profile(this.factory, string, n, byArray, taggedComponentArray);
        this.putProfile(profile);
    }

    protected Profile.TaggedComponent createCodeSetComponent() {
        MarshalOutputStream marshalOutputStream = this.factory.newOutputStream();
        CodeSetComponentInfo codeSetComponentInfo = this.factory.getCodeSetComponentInfo();
        marshalOutputStream.putEndian();
        codeSetComponentInfo.write(marshalOutputStream);
        byte[] byArray = marshalOutputStream.toByteArray();
        Profile.TaggedComponent taggedComponent = new Profile.TaggedComponent(1, byArray);
        return taggedComponent;
    }

    protected Profile.TaggedComponent createCodebaseComponent(Object object) {
        if (object != null) {
            this.codebase = Util.getCodebase(object.getClass());
            this.cachedCodebase = true;
            return this.createCodebaseComponent(this.codebase);
        }
        return null;
    }

    protected Profile.TaggedComponent createCodebaseComponent(String string) {
        Profile.TaggedComponent taggedComponent = null;
        try {
            MarshalOutputStream marshalOutputStream = this.factory.newOutputStream();
            marshalOutputStream.putEndian();
            marshalOutputStream.write_string(string);
            byte[] byArray = marshalOutputStream.toByteArray();
            if (byArray != null && byArray.length > 0) {
                taggedComponent = new Profile.TaggedComponent(25, byArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return taggedComponent;
    }

    public void read(InputStream inputStream) {
        String string;
        this.typeId = inputStream.read_string();
        int n = inputStream.read_long();
        this.profileTags = new int[n];
        this.profileData = new byte[n][];
        int n2 = 0;
        while (n2 < n) {
            this.profileTags[n2] = inputStream.read_long();
            this.profileData[n2] = new byte[inputStream.read_long()];
            inputStream.read_octet_array(this.profileData[n2], 0, this.profileData[n2].length);
            ++n2;
        }
        this.cachedCodebase = false;
        if (!this.is_nil() && (string = JDKBridge.getLocalCodebase()) != null && this.profileTags.length > 0 && this.getProfile().minor > 0 && this.getCodebase() == null) {
            if (localCodeBaseTC == null) {
                localCodeBaseTC = this.createCodebaseComponent(string);
            }
            Profile.TaggedComponent taggedComponent = null;
            Profile profile = this.getProfile();
            Profile.TaggedComponent[] taggedComponentArray = profile.getTaggedComponents();
            int n3 = 0;
            while (n3 < taggedComponentArray.length) {
                if (taggedComponentArray[n3].tag == 1) {
                    taggedComponent = taggedComponentArray[n3];
                }
                ++n3;
            }
            this.setProfile(profile.getHost(), profile.getPort(), profile.getObjectKey(), taggedComponent, localCodeBaseTC);
            this.codebase = string;
            this.cachedCodebase = true;
        }
    }

    public void write(MarshalOutputStream marshalOutputStream) {
        marshalOutputStream.write_string(this.typeId);
        marshalOutputStream.write_long(this.profileTags.length);
        int n = 0;
        while (n < this.profileTags.length) {
            marshalOutputStream.write_long(this.profileTags[n]);
            marshalOutputStream.write_long(this.profileData[n].length);
            marshalOutputStream.write_octet_array(this.profileData[n], 0, this.profileData[n].length);
            ++n;
        }
    }

    public String getCodebase() {
        if (!this.cachedCodebase && this.profileTags.length > 0) {
            Profile.TaggedComponent[] taggedComponentArray = this.getProfile().getTaggedComponents();
            int n = 0;
            while (n < taggedComponentArray.length) {
                if (taggedComponentArray[n].tag == 25) {
                    try {
                        MarshalInputStream marshalInputStream = taggedComponentArray[n].getComponentData(this.factory);
                        this.codebase = marshalInputStream.read_string();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n;
            }
            this.cachedCodebase = true;
        }
        return this.codebase;
    }

    public CodeSetComponentInfo getCodeSetComponentInfo() {
        return this.getProfile().getCodeSetComponentInfo();
    }

    public synchronized Profile getProfile() {
        if (this.iop != null) {
            return this.iop;
        }
        int n = 0;
        while (n < this.profileTags.length) {
            if (this.profileTags[n] == 0) {
                this.iop = new Profile(this.factory, this.profileData[n]);
                return this.iop;
            }
            ++n;
        }
        throw new INV_OBJREF(1, CompletionStatus.COMPLETED_NO);
    }

    public void putProfile(Profile profile) {
        int n = 0;
        if (this.profileTags != null) {
            n = this.profileTags.length;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.profileTags[n2] == 0) {
                this.profileData[n2] = profile.getEncapsulation();
                this.iop = profile;
                return;
            }
            ++n2;
        }
        int[] nArray = new int[n + 1];
        byte[][] byArrayArray = new byte[n + 1][];
        n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.profileTags[n2];
            byArrayArray[n2] = this.profileData[n2];
            ++n2;
        }
        nArray[n2] = 0;
        byArrayArray[n2] = profile.getEncapsulation();
        this.profileTags = nArray;
        this.profileData = byArrayArray;
        this.iop = profile;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String stringify() {
        return this.stringify(this.factory);
    }

    public String stringify(ORB oRB) {
        MarshalOutputStream marshalOutputStream = oRB.newOutputStream();
        marshalOutputStream.putEndian();
        this.write(marshalOutputStream);
        StringWriter stringWriter = new StringWriter();
        try {
            marshalOutputStream.writeTo(new HexOutputStream(stringWriter));
        }
        catch (IOException iOException) {
            throw new INTERNAL(10, CompletionStatus.COMPLETED_NO);
        }
        return "IOR:" + stringWriter;
    }

    public boolean is_nil() {
        return this.profileTags.length == 0;
    }

    public boolean isEquivalent(IOR iOR) {
        return this.getProfile().isEquivalent(iOR.getProfile());
    }
}

