/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi;

import com.ibm.rmi.CodeSetComponentInfo;
import com.ibm.rmi.MarshalInputStream;
import com.ibm.rmi.MarshalOutputStream;
import com.ibm.rmi.ORB;
import org.omg.CORBA.SystemException;

public class Profile {
    protected String host;
    protected int port;
    protected byte major;
    protected byte minor;
    protected byte[] objectKey;
    private byte[] data;
    protected TaggedComponent[] components;
    private ORB factory;
    private CodeSetComponentInfo cs = null;

    public Profile(ORB oRB, byte[] byArray) throws SystemException {
        this.factory = oRB;
        MarshalInputStream marshalInputStream = oRB.newInputStream(byArray, byArray.length);
        marshalInputStream.consumeEndian();
        this.major = marshalInputStream.read_octet();
        this.minor = marshalInputStream.read_octet();
        this.host = marshalInputStream.read_string();
        this.port = marshalInputStream.read_short() & 0xFFFF;
        this.objectKey = new byte[marshalInputStream.read_long()];
        marshalInputStream.read_octet_array(this.objectKey, 0, this.objectKey.length);
        this.data = byArray;
        if (this.minor > 0) {
            int n = marshalInputStream.read_long();
            this.components = new TaggedComponent[n];
            int n2 = 0;
            while (n2 < n) {
                this.components[n2] = new TaggedComponent();
                this.components[n2].read(marshalInputStream);
                ++n2;
            }
            int n3 = 0;
            while (n3 < n) {
                if (this.components[n3].tag == 1) {
                    MarshalInputStream marshalInputStream2 = this.components[n3].getComponentData(oRB);
                    CodeSetComponentInfo codeSetComponentInfo = oRB.getCodeSetComponentInfo();
                    codeSetComponentInfo.read(marshalInputStream2);
                }
                ++n3;
            }
        } else {
            this.components = new TaggedComponent[0];
        }
        this.setCodeSetInfo();
    }

    public Profile(ORB oRB, String string, int n, byte[] byArray, TaggedComponent[] taggedComponentArray) {
        this.factory = oRB;
        this.host = string;
        this.port = n;
        this.objectKey = byArray;
        this.major = 1;
        this.minor = 1;
        this.components = taggedComponentArray == null ? new TaggedComponent[0] : taggedComponentArray;
        this.setCodeSetInfo();
    }

    public void setCodeSetInfo() {
        int n = 0;
        while (n < this.components.length) {
            if (this.components[n].tag == 1) {
                MarshalInputStream marshalInputStream = this.components[n].getComponentData(this.factory);
                this.cs = this.factory.getCodeSetComponentInfo();
                this.cs.read(marshalInputStream);
            }
            ++n;
        }
    }

    byte[] getEncapsulation() throws SystemException {
        if (this.data != null) {
            return this.data;
        }
        MarshalOutputStream marshalOutputStream = this.factory.newOutputStream();
        marshalOutputStream.putEndian();
        marshalOutputStream.write_octet(this.major);
        marshalOutputStream.write_octet(this.minor);
        marshalOutputStream.write_string(this.host);
        marshalOutputStream.write_short((short)this.port);
        marshalOutputStream.write_long(this.objectKey.length);
        marshalOutputStream.write_octet_array(this.objectKey, 0, this.objectKey.length);
        if (this.minor > 0) {
            marshalOutputStream.write_long(this.components.length);
            int n = 0;
            while (n < this.components.length) {
                this.components[n].write(marshalOutputStream);
                ++n;
            }
        }
        this.data = marshalOutputStream.toByteArray();
        return this.data;
    }

    public TaggedComponent[] getTaggedComponents() {
        return this.components;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public byte[] getObjectKey() {
        return this.objectKey;
    }

    public ORB getFactory() {
        return this.factory;
    }

    public byte getMajor() {
        return this.major;
    }

    public byte getMinor() {
        return this.minor;
    }

    public CodeSetComponentInfo getCodeSetComponentInfo() {
        return this.cs;
    }

    boolean isEquivalent(Profile profile) {
        if (this.getPort() != profile.getPort() || !this.getHost().equalsIgnoreCase(profile.getHost()) || this.getObjectKey().length != profile.getObjectKey().length) {
            return false;
        }
        byte[] byArray = profile.getObjectKey();
        int n = 0;
        while (n < this.objectKey.length) {
            if (this.objectKey[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static class TaggedComponent {
        public static final int TAG_CODE_SETS = 1;
        public static final int TAG_JAVA_CODEBASE = 25;
        public int tag;
        public byte[] component_data;

        public TaggedComponent() {
            this.tag = -1;
            this.component_data = null;
        }

        public TaggedComponent(int n, byte[] byArray) {
            this.tag = n;
            this.component_data = byArray;
        }

        public void read(MarshalInputStream marshalInputStream) {
            this.tag = marshalInputStream.read_ulong();
            int n = marshalInputStream.read_long();
            this.component_data = new byte[n];
            marshalInputStream.read_octet_array(this.component_data, 0, n);
        }

        public void write(MarshalOutputStream marshalOutputStream) {
            marshalOutputStream.write_ulong(this.tag);
            marshalOutputStream.write_long(this.component_data.length);
            marshalOutputStream.write_octet_array(this.component_data, 0, this.component_data.length);
        }

        public MarshalInputStream getComponentData(ORB oRB) {
            MarshalInputStream marshalInputStream = oRB.newInputStream(this.component_data, this.component_data.length);
            marshalInputStream.consumeEndian();
            return marshalInputStream;
        }
    }
}

