/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi;

import com.ibm.rmi.ClientSubcontract;
import com.ibm.rmi.ServerSubcontract;

public class SubcontractRegistry {
    protected int size;
    protected ServerSubcontract[] serverRegistry;
    protected Class[] clientFactory;
    protected int defaultId;
    protected ServerSubcontract bootstrapServer = null;

    public SubcontractRegistry(int n) {
        this(n, 256);
    }

    public SubcontractRegistry(int n, int n2) {
        this.size = n2;
        this.defaultId = n;
        this.serverRegistry = new ServerSubcontract[n2];
        this.clientFactory = new Class[n2];
    }

    public synchronized boolean registerClient(Class clazz, int n) {
        if (n < this.size) {
            this.clientFactory[n] = clazz;
            return true;
        }
        return false;
    }

    public synchronized boolean registerServer(ServerSubcontract serverSubcontract, int n) {
        if (n < this.size) {
            this.serverRegistry[n] = serverSubcontract;
            serverSubcontract.setId(n);
            Class clazz = serverSubcontract.getClientSubcontractClass();
            if (clazz != null) {
                this.registerClient(clazz, n);
            }
            return true;
        }
        return false;
    }

    public void registerBootstrapServer(ServerSubcontract serverSubcontract) {
        this.bootstrapServer = serverSubcontract;
    }

    public ServerSubcontract getServerSubcontract(int n) {
        ServerSubcontract serverSubcontract = null;
        if (n < this.size) {
            serverSubcontract = this.serverRegistry[n];
        }
        if (serverSubcontract == null) {
            return this.serverRegistry[this.defaultId];
        }
        return serverSubcontract;
    }

    public ServerSubcontract getServerSubcontract(byte[] byArray) {
        int n;
        int n2;
        ServerSubcontract serverSubcontract = null;
        if (byArray.length == 4) {
            int n3 = this.getMagic(byArray);
            if (n3 == 1229867348 || n3 == 1414090313) {
                return this.bootstrapServer;
            }
        } else if (byArray.length >= 8 && (n2 = this.getMagic(byArray)) == -1347695874 && (n = this.getId(byArray)) < this.size) {
            serverSubcontract = this.serverRegistry[n];
        }
        if (serverSubcontract == null) {
            return this.serverRegistry[this.defaultId];
        }
        return serverSubcontract;
    }

    public ClientSubcontract getClientSubcontract(byte[] byArray) {
        Class clazz = null;
        int n = this.defaultId;
        try {
            int n2;
            if (byArray.length >= 8 && (n2 = this.getMagic(byArray)) == -1347695874 && (n = this.getId(byArray)) < this.size) {
                clazz = this.clientFactory[n];
            }
            if (clazz == null) {
                clazz = this.clientFactory[this.defaultId];
            }
            ClientSubcontract clientSubcontract = (ClientSubcontract)clazz.newInstance();
            clientSubcontract.setId(n);
            return clientSubcontract;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected int getMagic(byte[] byArray) {
        return SubcontractRegistry.bytesToInt(byArray, 0);
    }

    protected int getId(byte[] byArray) {
        int n = SubcontractRegistry.bytesToInt(byArray, 4);
        return n;
    }

    protected int getServerId(byte[] byArray) {
        return SubcontractRegistry.bytesToInt(byArray, 8);
    }

    private static int bytesToInt(byte[] byArray, int n) {
        int n2 = byArray[n++] << 24 & 0xFF000000;
        int n3 = byArray[n++] << 16 & 0xFF0000;
        int n4 = byArray[n++] << 8 & 0xFF00;
        int n5 = byArray[n++] << 0 & 0xFF;
        return n2 | n3 | n4 | n5;
    }
}

