/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba.util;

import com.ibm.rmi.corba.util.Element;
import com.ibm.rmi.util.Utility;

public final class TransientObjectManager {
    private int maxSize = 128;
    private Element[] elementArray = new Element[this.maxSize];
    private Element freeList;

    public TransientObjectManager() {
        this.elementArray[this.maxSize - 1] = new Element(this.maxSize - 1, null);
        int n = this.maxSize - 2;
        while (n >= 0) {
            this.elementArray[n] = new Element(n, this.elementArray[n + 1]);
            --n;
        }
        this.freeList = this.elementArray[0];
    }

    public synchronized byte[] storeServant(Object object, Object object2) {
        if (this.freeList == null) {
            this.doubleSize();
        }
        Element element = this.freeList;
        this.freeList = (Element)this.freeList.servant;
        return element.getKey(object, object2);
    }

    public synchronized Object lookupServant(byte[] byArray) {
        int n = Utility.bytesToInt(byArray, 0);
        int n2 = Utility.bytesToInt(byArray, 4);
        if (this.elementArray[n].counter == n2 && this.elementArray[n].valid) {
            return this.elementArray[n].servant;
        }
        return null;
    }

    public synchronized Object lookupServantData(byte[] byArray) {
        int n = Utility.bytesToInt(byArray, 0);
        int n2 = Utility.bytesToInt(byArray, 4);
        if (this.elementArray[n].counter == n2 && this.elementArray[n].valid) {
            return this.elementArray[n].servantData;
        }
        return null;
    }

    public synchronized void deleteServant(byte[] byArray) {
        int n = Utility.bytesToInt(byArray, 0);
        this.freeList = this.elementArray[n].delete(this.freeList);
    }

    public synchronized byte[] getKey(Object object) {
        int n = 0;
        while (n < this.maxSize) {
            if (this.elementArray[n].valid && this.elementArray[n].servant == object) {
                return this.elementArray[n].toBytes();
            }
            ++n;
        }
        return null;
    }

    private void doubleSize() {
        Element[] elementArray = this.elementArray;
        int n = this.maxSize;
        this.maxSize *= 2;
        this.elementArray = new Element[this.maxSize];
        int n2 = 0;
        while (n2 < n) {
            this.elementArray[n2] = elementArray[n2];
            ++n2;
        }
        this.elementArray[this.maxSize - 1] = new Element(this.maxSize - 1, null);
        int n3 = this.maxSize - 2;
        while (n3 >= n) {
            this.elementArray[n3] = new Element(n3, this.elementArray[n3 + 1]);
            --n3;
        }
        this.freeList = this.elementArray[n];
    }
}

