/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.org.omg.SendingContext.CodeBase;
import com.ibm.rmi.ClientSubcontract;
import com.ibm.rmi.CodeSetComponentInfo;
import com.ibm.rmi.IOR;
import com.ibm.rmi.MarshalInputStream;
import com.ibm.rmi.ORB;
import com.ibm.rmi.Profile;
import com.ibm.rmi.ServerSubcontract;
import com.ibm.rmi.SubcontractRegistry;
import com.ibm.rmi.corba.PrincipalImpl;
import com.ibm.rmi.corba.TypeCodeImpl;
import com.ibm.rmi.iiop.CDRConnection;
import com.ibm.rmi.iiop.CDROutputStream;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.IIOPInputStream;
import com.ibm.rmi.io.ValueHandlerImpl;
import com.ibm.rmi.util.CacheTable;
import com.ibm.rmi.util.PartnerVersion;
import com.ibm.rmi.util.RepositoryId;
import com.ibm.rmi.util.Utility;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.ValueHandler;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnySeqHolder;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BooleanSeqHolder;
import org.omg.CORBA.CharSeqHolder;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.DataInputStream;
import org.omg.CORBA.DoubleSeqHolder;
import org.omg.CORBA.FloatSeqHolder;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LongLongSeqHolder;
import org.omg.CORBA.LongSeqHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.Principal;
import org.omg.CORBA.ShortSeqHolder;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ULongLongSeqHolder;
import org.omg.CORBA.ULongSeqHolder;
import org.omg.CORBA.UShortSeqHolder;
import org.omg.CORBA.WCharSeqHolder;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import sun.io.ByteToCharConverter;
import sun.io.MalformedInputException;

public class CDRInputStream
extends InputStream
implements MarshalInputStream,
DataInputStream,
PartnerVersion {
    private static final String kReadMethod = "read";
    private static final int maxBlockLength = 0x7FFFFF00;
    protected boolean littleEndian;
    protected int index;
    protected int size;
    protected int offset;
    protected byte[] buf;
    protected ORB orb;
    protected int tcsChar = -1;
    protected int tcsWChar = -1;
    protected ByteToCharConverter tcsCharConverter = null;
    private Hashtable valueCache = null;
    private CacheTable repositoryIdCache = null;
    private CacheTable codebaseCache = null;
    private long blockLength = 0x7FFFFF00L;
    private Class expectedType = null;
    private int end_flag = 0;
    private int valueIndirection = 0;
    private int stringIndirection = 0;
    private boolean isChunked = false;
    private ValueHandler valueHandler = null;
    private Connection conn = null;
    private short partnerMajor;
    private short partnerMinor;
    private static String _id = "IDL:omg.org/CORBA/DataInputStream:1.0";
    private static String[] _ids = new String[]{_id};
    static /* synthetic */ Class class$org$omg$CORBA$portable$ObjectImpl;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$org$omg$CORBA$portable$Delegate;
    static /* synthetic */ Class class$org$omg$CORBA$portable$IDLEntity;
    static /* synthetic */ Class class$org$omg$CORBA$portable$InputStream;
    static /* synthetic */ Class class$org$omg$CORBA$portable$StreamableValue;
    static /* synthetic */ Class class$org$omg$CORBA$portable$CustomValue;
    static /* synthetic */ Class class$org$omg$CORBA$portable$ValueBase;

    public CDRInputStream() {
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n) {
        this(oRB, byArray, n, false);
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n, Connection connection) {
        this(oRB, byArray, n, false);
        this.conn = connection;
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n, boolean bl) {
        this.orb = (ORB)oRB;
        this.littleEndian = bl;
        this.size = n;
        this.buf = byArray;
        this.offset = 0;
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n, int n2, int n3) {
        this(oRB, byArray, n, false, n2, n3);
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n, boolean bl, int n2, int n3) {
        this(oRB, byArray, n, bl);
        this.tcsChar = n2;
        this.tcsWChar = n3;
    }

    public CDRInputStream(CDRInputStream cDRInputStream) {
        this.littleEndian = cDRInputStream.littleEndian;
        this.index = cDRInputStream.index;
        this.size = cDRInputStream.size;
        this.buf = cDRInputStream.buf;
        this.orb = cDRInputStream.orb;
        this.conn = cDRInputStream.conn;
        this.tcsChar = cDRInputStream.tcsChar;
        this.tcsWChar = cDRInputStream.tcsWChar;
        this.tcsCharConverter = cDRInputStream.tcsCharConverter;
        this.offset = 0;
    }

    public void setPartnerVersion(short s, short s2) {
        this.partnerMajor = s;
        this.partnerMinor = s2;
    }

    public short getPartnerMajor() {
        Connection connection;
        if (this.partnerMajor == 0 && (connection = this.getConnection()) != null && connection instanceof PartnerVersion) {
            this.partnerMajor = ((PartnerVersion)((java.lang.Object)connection)).getPartnerMajor();
        }
        return this.partnerMajor;
    }

    public short getPartnerMinor() {
        Connection connection;
        if (this.partnerMinor == 0 && (connection = this.getConnection()) != null && connection instanceof PartnerVersion) {
            this.partnerMinor = ((PartnerVersion)((java.lang.Object)connection)).getPartnerMinor();
        }
        return this.partnerMinor;
    }

    public ORB getORB() {
        return this.orb;
    }

    public boolean wasCreatedFrom(CDROutputStream cDROutputStream) {
        return cDROutputStream != null && cDROutputStream.getBuffer() == this.buf;
    }

    public CDRInputStream dup() {
        return new CDRInputStream(this);
    }

    private final void alignAndCheck(int n, int n2) {
        int n3;
        if (this.blockLength == (long)this.index) {
            this.blockLength = 0x7FFFFF00L;
            this.start_block();
        } else if (this.blockLength < (long)this.index) {
            throw new MARSHAL("Chunk overflow at offset " + this.index, 998, CompletionStatus.COMPLETED_NO);
        }
        if (n > 1 && (n3 = this.index & n - 1) != 0) {
            n3 = n - n3;
            this.index += n3;
        }
        if (this.index + n2 > this.size) {
            this.grow(n, n2);
        }
    }

    protected void grow(int n, int n2) {
        throw new MARSHAL(999, CompletionStatus.COMPLETED_NO);
    }

    public void setOffset(int n) {
        this.index = n;
    }

    private char[] convertFromAscii(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            cArray[n] = (char)(byArray[n] & 0xFF);
            ++n;
        }
        return cArray;
    }

    private char[] convertFromTcsChar(byte[] byArray) {
        int n = this.getTcsChar();
        if (n == 0 || n == 65537 || n == 65568) {
            return this.convertFromAscii(byArray);
        }
        if (n == 268567780 || n == 65551) {
            int n2 = 0;
            while (n2 < byArray.length) {
                if (byArray[n2] > 127) break;
                ++n2;
            }
            if (n2 >= byArray.length) {
                return this.convertFromAscii(byArray);
            }
        }
        ByteToCharConverter byteToCharConverter = this.getCharConverter();
        try {
            int n3 = byArray.length * byteToCharConverter.getMaxCharsPerByte();
            char[] cArray = new char[n3];
            int n4 = 0;
            byteToCharConverter.reset();
            n4 += byteToCharConverter.convert(byArray, 0, byArray.length, cArray, 0, n3);
            if ((n4 += byteToCharConverter.flush(cArray, byteToCharConverter.nextCharIndex(), n3)) < n3) {
                char[] cArray2 = new char[n4];
                System.arraycopy(cArray, 0, cArray2, 0, n4);
                return cArray2;
            }
            return cArray;
        }
        catch (MalformedInputException malformedInputException) {
            throw new MARSHAL(10, CompletionStatus.COMPLETED_NO);
        }
        catch (CharConversionException charConversionException) {
            throw new DATA_CONVERSION(6, CompletionStatus.COMPLETED_NO);
        }
    }

    private char[] convertFromTcsWChar(char[] cArray) {
        int n = this.getTcsWChar();
        if (n == 0) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_NO);
        }
        if (n == 65792) {
            return cArray;
        }
        return Utility.convertFromUTF16(cArray, this.littleEndian);
    }

    public final void consumeEndian() {
        this.littleEndian = this.read_boolean();
    }

    public final double read_longdouble() {
        throw new NO_IMPLEMENT(3, CompletionStatus.COMPLETED_MAYBE);
    }

    public final boolean read_boolean() {
        boolean bl = this.read_octet() != 0;
        return bl;
    }

    public final char read_char() {
        this.alignAndCheck(1, 1);
        byte[] byArray = new byte[]{this.buf[this.index++]};
        char[] cArray = this.convertFromTcsChar(byArray);
        return cArray[0];
    }

    public final char read_wchar() {
        int n;
        int n2;
        this.alignAndCheck(2, 2);
        if (this.littleEndian) {
            n2 = this.buf[this.index++] & 0xFF;
            n = this.buf[this.index++] & 0xFF;
        } else {
            n = this.buf[this.index++] & 0xFF;
            n2 = this.buf[this.index++] & 0xFF;
        }
        char[] cArray = new char[]{(char)((n << 8) + n2)};
        char[] cArray2 = this.convertFromTcsWChar(cArray);
        return cArray2[0];
    }

    public final byte read_octet() {
        if (this.index + 1 >= this.size) {
            this.alignAndCheck(1, 1);
        }
        return this.buf[this.index++];
    }

    public final short read_short() {
        int n;
        int n2;
        this.alignAndCheck(2, 2);
        if (this.littleEndian) {
            n2 = this.buf[this.index++] << 0 & 0xFF;
            n = this.buf[this.index++] << 8 & 0xFF00;
        } else {
            n = this.buf[this.index++] << 8 & 0xFF00;
            n2 = this.buf[this.index++] << 0 & 0xFF;
        }
        return (short)(n | n2);
    }

    public final short read_ushort() {
        return this.read_short();
    }

    public final int read_long() {
        int n;
        int n2;
        int n3;
        int n4;
        if ((this.index & 3) != 0 || this.index + 4 >= this.size) {
            this.alignAndCheck(4, 4);
        }
        if (this.littleEndian) {
            n4 = this.buf[this.index++] & 0xFF;
            n3 = this.buf[this.index++] & 0xFF;
            n2 = this.buf[this.index++] & 0xFF;
            n = this.buf[this.index++] & 0xFF;
        } else {
            n = this.buf[this.index++] & 0xFF;
            n2 = this.buf[this.index++] & 0xFF;
            n3 = this.buf[this.index++] & 0xFF;
            n4 = this.buf[this.index++] & 0xFF;
        }
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    public final int read_ulong() {
        return this.read_long();
    }

    public final long read_longlong() {
        long l;
        long l2;
        this.alignAndCheck(8, 8);
        if (this.littleEndian) {
            l2 = (long)this.read_long() & 0xFFFFFFFFL;
            l = (long)this.read_long() << 32;
        } else {
            l = (long)this.read_long() << 32;
            l2 = (long)this.read_long() & 0xFFFFFFFFL;
        }
        return l | l2;
    }

    public final long read_ulonglong() {
        return this.read_longlong();
    }

    public final float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public final double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    protected final String readStringOrIndirection(boolean bl) {
        int n = this.read_long();
        if (bl) {
            if (n == -1) {
                return null;
            }
            this.stringIndirection = this.get_offset() - 4;
        }
        if (n == 0) {
            return "";
        }
        byte[] byArray = new byte[--n];
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = this.size - this.index;
            if (n4 <= 0) {
                this.grow(1, 1);
                n4 = this.size - this.index;
            }
            int n5 = (n3 = n - n2) < n4 ? n3 : n4;
            int n6 = 0;
            while (n6 < n5) {
                byArray[n2 + n6] = this.buf[this.index + n6];
                ++n6;
            }
            this.index += n5;
            n2 += n5;
        }
        if (this.index + 1 >= this.size) {
            this.alignAndCheck(1, 1);
        }
        ++this.index;
        return new String(this.convertFromTcsChar(byArray));
    }

    public final String read_string() {
        return this.readStringOrIndirection(false);
    }

    public final String peek_string() {
        int n;
        int n2;
        int n3;
        int n4;
        this.alignAndCheck(4, 4);
        if (this.littleEndian) {
            n4 = this.buf[this.index] << 0 & 0xFF;
            n3 = this.buf[this.index + 1] << 8 & 0xFF00;
            n2 = this.buf[this.index + 2] << 16 & 0xFF0000;
            n = this.buf[this.index + 3] << 24 & 0xFF000000;
        } else {
            n = this.buf[this.index] << 24 & 0xFF000000;
            n2 = this.buf[this.index + 1] << 16 & 0xFF0000;
            n3 = this.buf[this.index + 2] << 8 & 0xFF00;
            n4 = this.buf[this.index + 3] << 0 & 0xFF;
        }
        int n5 = n | n2 | n3 | n4;
        if (n5 == 0) {
            return "";
        }
        int n6 = this.index + 4;
        this.alignAndCheck(1, 1);
        int n7 = this.size - n6;
        if (n5 > n7) {
            throw new INTERNAL(6, CompletionStatus.COMPLETED_MAYBE);
        }
        byte[] byArray = new byte[--n5];
        int n8 = 0;
        while (n8 < n5) {
            byArray[n8] = this.buf[n6 + n8];
            ++n8;
        }
        return new String(this.convertFromTcsChar(byArray));
    }

    public final String read_wstring() {
        int n = this.read_long();
        if (n == 0) {
            return "";
        }
        if (this.index + n * 2 >= this.size) {
            this.alignAndCheck(2, n * 2);
        }
        char[] cArray = new char[--n];
        if (this.littleEndian) {
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.buf[this.index++] & 0xFF;
                int n4 = this.buf[this.index++] & 0xFF;
                cArray[n2] = (char)((n4 << 8) + (n3 << 0));
                ++n2;
            }
        } else {
            int n5 = 0;
            while (n5 < n) {
                int n6 = this.buf[this.index++] & 0xFF;
                int n7 = this.buf[this.index++] & 0xFF;
                cArray[n5] = (char)((n6 << 8) + (n7 << 0));
                ++n5;
            }
        }
        this.index += 2;
        return new String(this.convertFromTcsWChar(cArray));
    }

    public final void read_octet_array(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new BAD_PARAM();
        }
        int n3 = n;
        while (n3 < n2 + n) {
            int n4;
            int n5 = this.size - this.index;
            if (n5 <= 0) {
                this.grow(1, 1);
                n5 = this.size - this.index;
            }
            int n6 = (n4 = n2 + n - n3) < n5 ? n4 : n5;
            System.arraycopy(this.buf, this.index, byArray, n3, n6);
            this.index += n6;
            n3 += n6;
        }
    }

    public Principal read_Principal() {
        int n = this.read_long();
        byte[] byArray = new byte[n];
        this.read_octet_array(byArray, 0, n);
        PrincipalImpl principalImpl = new PrincipalImpl();
        ((Principal)principalImpl).name(byArray);
        return principalImpl;
    }

    public TypeCode read_TypeCode() {
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(this.orb);
        typeCodeImpl.read_value(this);
        return typeCodeImpl;
    }

    public Any read_any() {
        Any any = this.orb.create_any();
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(this.orb);
        typeCodeImpl.read_value(this);
        any.read_value(this, typeCodeImpl);
        return any;
    }

    public Object read_Object() {
        return this.read_Object(null);
    }

    public Object read_Object(Class clazz) {
        java.lang.Object object;
        ServerSubcontract serverSubcontract;
        int n;
        if (clazz != null && !(class$org$omg$CORBA$portable$ObjectImpl == null ? (class$org$omg$CORBA$portable$ObjectImpl = CDRInputStream.class$("org.omg.CORBA.portable.ObjectImpl")) : class$org$omg$CORBA$portable$ObjectImpl).isAssignableFrom(clazz)) {
            return (Object)PortableRemoteObject.narrow(this.read_Object(), clazz);
        }
        IOR iOR = new IOR(this.orb);
        iOR.read(this);
        if (iOR.is_nil()) {
            return null;
        }
        Object object2 = null;
        Profile profile = iOR.getProfile();
        byte[] byArray = profile.getObjectKey();
        String string = profile.getHost();
        SubcontractRegistry subcontractRegistry = this.orb.getSubcontractRegistry();
        if (string.equals(this.orb.getORBServerHost()) && (n = Utility.bytesToInt(byArray, 8)) == this.orb.getTransientServerId() && (serverSubcontract = subcontractRegistry.getServerSubcontract(byArray)) != null && (object = serverSubcontract.getServant(byArray)) != null) {
            if (object instanceof Tie) {
                String string2 = iOR.getCodebase();
                object2 = (Object)((java.lang.Object)Utility.loadStub((Tie)object, clazz, string2, false));
                if (object2 != null) {
                    return object2;
                }
                throw new MARSHAL(4, CompletionStatus.COMPLETED_NO);
            }
            if (object instanceof Object) {
                return (Object)object;
            }
        }
        ClientSubcontract clientSubcontract = subcontractRegistry.getClientSubcontract(byArray);
        clientSubcontract.unmarshal(iOR);
        clientSubcontract.setOrb(this.orb);
        return CDRInputStream.loadStub(iOR, clazz, (Delegate)((java.lang.Object)clientSubcontract));
    }

    protected static ObjectImpl loadStub(IOR iOR, Class clazz, Delegate delegate) {
        block7: {
            java.lang.Object object;
            block8: {
                if (clazz != null) {
                    try {
                        return CDRInputStream.newStub(clazz, delegate);
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ThreadDeath) {
                            throw (ThreadDeath)throwable;
                        }
                        break block7;
                    }
                }
                try {
                    object = iOR.getTypeId();
                    if (((String)object).length() > 0) {
                        String string = iOR.getCodebase();
                        Class clazz2 = Utility.loadStubClass((String)object, string, null);
                        return CDRInputStream.newStub(clazz2, delegate);
                    }
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof ThreadDeath)) break block8;
                    throw (ThreadDeath)throwable;
                }
            }
            object = new ObjectImpl(){

                public String[] _ids() {
                    String[] stringArray = new String[]{"IDL:omg.org/CORBA/Object:1.0"};
                    return stringArray;
                }
            };
            ((ObjectImpl)object)._set_delegate(delegate);
            return object;
        }
        throw new MARSHAL(4, CompletionStatus.COMPLETED_NO);
    }

    protected static ObjectImpl newStub(Class clazz, Delegate delegate) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = CDRInputStream.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz)) {
            ObjectImpl objectImpl = (ObjectImpl)clazz.newInstance();
            objectImpl._set_delegate(delegate);
            return objectImpl;
        }
        try {
            ObjectImpl objectImpl = (ObjectImpl)clazz.newInstance();
            objectImpl._set_delegate(delegate);
            return objectImpl;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            Class[] classArray = new Class[]{class$org$omg$CORBA$portable$Delegate == null ? (class$org$omg$CORBA$portable$Delegate = CDRInputStream.class$("org.omg.CORBA.portable.Delegate")) : class$org$omg$CORBA$portable$Delegate};
            java.lang.Object[] objectArray = new java.lang.Object[]{delegate};
            Constructor constructor = clazz.getConstructor(classArray);
            return (ObjectImpl)constructor.newInstance(objectArray);
        }
    }

    public java.lang.Object read_abstract_interface() {
        return this.read_abstract_interface(null);
    }

    public java.lang.Object read_abstract_interface(Class clazz) {
        boolean bl = this.read_boolean();
        if (bl) {
            return this.read_Object(clazz);
        }
        return this.read_value();
    }

    public Serializable read_value() {
        int n = this.readValueTag();
        int n2 = this.get_offset();
        if (n == 0) {
            return null;
        }
        if (n == -1) {
            int n3 = this.read_long();
            Integer n4 = new Integer(n2 += n3);
            if (this.valueCache != null && this.valueCache.containsKey(n4)) {
                Serializable serializable = (Serializable)this.valueCache.get(n4);
                return serializable;
            }
            throw new IndirectionException(n2);
        }
        n2 -= 4;
        boolean bl = this.isChunked;
        this.isChunked = RepositoryId.isChunkedEncoding(n);
        java.lang.Object object = null;
        String string = null;
        if (RepositoryId.isCodeBasePresent(n)) {
            string = this.read_codebase_URL();
        }
        String string2 = null;
        switch (RepositoryId.getTypeInfo(n)) {
            case 0: {
                string2 = RepositoryId.createForAnyType(this.expectedType);
                break;
            }
            case 2: {
                string2 = this.read_repositoryId();
                break;
            }
            case 6: {
                string2 = this.read_repositoryIds();
            }
        }
        this.start_block();
        --this.end_flag;
        if (string2.equals("IDL:omg.org/CORBA/WStringValue:1.0")) {
            object = this.read_wstring();
        } else if (string2.equals(RepositoryId.kClassDescValueRepID)) {
            object = this.readClass();
        } else {
            RepositoryId repositoryId = RepositoryId.cache.getId(string2);
            Class clazz = null;
            if (repositoryId.isIDLType()) {
                object = this.readFactoryValue(n2, string2, clazz, string);
            } else {
                try {
                    clazz = repositoryId.getClassFromType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        clazz = repositoryId.getClassFromType(string);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        throw new NO_IMPLEMENT("Unable to locate value class " + repositoryId.getClassName(), 1, CompletionStatus.COMPLETED_NO);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new MARSHAL("Unable to locate value class for rep. id : " + repositoryId + " because of malformed URL " + string);
                    }
                }
                if (clazz != null && (class$org$omg$CORBA$portable$IDLEntity == null ? (class$org$omg$CORBA$portable$IDLEntity = CDRInputStream.class$("org.omg.CORBA.portable.IDLEntity")) : class$org$omg$CORBA$portable$IDLEntity).isAssignableFrom(clazz)) {
                    object = this.readIDLValue(n2, string2, clazz, string);
                } else {
                    try {
                        if (this.valueHandler == null) {
                            this.valueHandler = new ValueHandlerImpl(true);
                        }
                        object = this.valueHandler.readValue(this, n2, clazz, string2, this.getFVDCodeBase());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        throw new MARSHAL("Unable to read value from underlying bridge : " + exception.getMessage());
                    }
                    catch (Error error) {
                        throw new MARSHAL("Unable to read value from underlying bridge : " + error.getMessage());
                    }
                }
            }
        }
        this.end_block();
        this.readEndTag();
        if (this.valueCache == null) {
            this.valueCache = new Hashtable();
        }
        this.valueCache.put(new Integer(n2), object);
        this.isChunked = bl;
        this.start_block();
        return (Serializable)object;
    }

    public Serializable read_value(Class clazz) {
        String string = null;
        if (clazz != null) {
            string = RepositoryId.createForAnyType(clazz);
        }
        int n = this.readValueTag();
        int n2 = this.get_offset();
        if (n == 0) {
            return null;
        }
        if (n == -1) {
            int n3 = this.read_long();
            Integer n4 = new Integer(n2 += n3);
            if (this.valueCache != null && this.valueCache.containsKey(n4)) {
                Serializable serializable = (Serializable)this.valueCache.get(n4);
                return serializable;
            }
            throw new IndirectionException(n2);
        }
        n2 -= 4;
        boolean bl = this.isChunked;
        this.isChunked = RepositoryId.isChunkedEncoding(n);
        java.lang.Object object = null;
        String string2 = null;
        if (RepositoryId.isCodeBasePresent(n)) {
            string2 = this.read_codebase_URL();
        }
        String string3 = null;
        switch (RepositoryId.getTypeInfo(n)) {
            case 0: {
                if (clazz != null) {
                    string3 = string;
                    break;
                }
                throw new MARSHAL("Missing repId in RMI valuetype encoding");
            }
            case 2: {
                string3 = this.read_repositoryId();
                break;
            }
            case 6: {
                string3 = this.read_repositoryIds();
            }
        }
        this.start_block();
        --this.end_flag;
        if (string3.equals("IDL:omg.org/CORBA/WStringValue:1.0")) {
            object = this.read_wstring();
        } else if (string3.equals(RepositoryId.kClassDescValueRepID)) {
            object = this.readClass();
        } else {
            RepositoryId repositoryId = RepositoryId.cache.getId(string3);
            Class clazz2 = clazz;
            if (clazz2 == null && repositoryId.isIDLType()) {
                object = this.readFactoryValue(n2, string3, clazz2, string2);
            } else {
                block27: {
                    if (clazz2 == null || !string.equals(string3)) {
                        try {
                            clazz2 = repositoryId.getClassFromType(clazz2, string2);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            if (clazz2 == null) break block27;
                            throw new NO_IMPLEMENT("Unable to locate value class " + repositoryId.getClassName(), 1, CompletionStatus.COMPLETED_NO);
                        }
                    }
                }
                if (clazz2 != null && (class$org$omg$CORBA$portable$IDLEntity == null ? (class$org$omg$CORBA$portable$IDLEntity = CDRInputStream.class$("org.omg.CORBA.portable.IDLEntity")) : class$org$omg$CORBA$portable$IDLEntity).isAssignableFrom(clazz2)) {
                    object = this.readIDLValue(n2, string3, clazz2, string2);
                } else {
                    try {
                        if (this.valueHandler == null) {
                            this.valueHandler = new ValueHandlerImpl(true);
                        }
                        object = this.valueHandler.readValue(this, n2, clazz2, string3, this.getFVDCodeBase());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        throw new MARSHAL("Unable to read value from underlying bridge : " + exception.getMessage());
                    }
                    catch (Error error) {
                        throw new MARSHAL("Unable to read value from underlying bridge : " + error.getMessage());
                    }
                }
            }
        }
        this.end_block();
        this.readEndTag();
        if (this.valueCache == null) {
            this.valueCache = new Hashtable();
        }
        this.valueCache.put(new Integer(n2), object);
        this.isChunked = bl;
        this.start_block();
        return (Serializable)object;
    }

    public Serializable read_value(BoxedValueHelper boxedValueHelper) {
        int n = this.readValueTag();
        int n2 = this.get_offset();
        if (n == 0) {
            return null;
        }
        if (n == -1) {
            Integer n3 = new Integer(n2 += this.read_long());
            if (this.valueCache != null && this.valueCache.containsKey(n3)) {
                Serializable serializable = (Serializable)this.valueCache.get(n3);
                return serializable;
            }
            throw new IndirectionException(n2);
        }
        n2 -= 4;
        boolean bl = this.isChunked;
        this.isChunked = RepositoryId.isChunkedEncoding(n);
        Serializable serializable = null;
        String string = null;
        if (RepositoryId.isCodeBasePresent(n)) {
            string = this.read_codebase_URL();
        }
        String string2 = null;
        switch (RepositoryId.getTypeInfo(n)) {
            case 0: {
                throw new MARSHAL("No class description available (value_tag indicates no type information present)");
            }
            case 2: {
                string2 = this.read_repositoryId();
                break;
            }
            case 6: {
                string2 = this.read_repositoryIds();
            }
        }
        RepositoryId repositoryId = RepositoryId.cache.getId(string2);
        if (!string2.equals(boxedValueHelper.get_id())) {
            boxedValueHelper = Utility.getHelper(null, string, string2);
        }
        this.start_block();
        --this.end_flag;
        this.valueIndirection = n2;
        serializable = boxedValueHelper.read_value(this);
        this.end_block();
        this.readEndTag();
        if (this.valueCache == null) {
            this.valueCache = new Hashtable();
        }
        this.valueCache.put(new Integer(n2), serializable);
        this.isChunked = bl;
        this.start_block();
        return serializable;
    }

    public Serializable read_value(Serializable serializable) {
        if (this.valueCache == null) {
            this.valueCache = new Hashtable();
        }
        this.valueCache.put(new Integer(this.valueIndirection), serializable);
        if (serializable instanceof StreamableValue) {
            ((StreamableValue)serializable)._read(this);
        } else if (serializable instanceof CustomValue) {
            ((CustomValue)serializable).unmarshal(this);
        }
        return serializable;
    }

    public Serializable read_value(String string) {
        int n = this.readValueTag();
        int n2 = this.get_offset();
        if (n == 0) {
            return null;
        }
        if (n == -1) {
            Integer n3 = new Integer(n2 += this.read_long());
            if (this.valueCache != null && this.valueCache.containsKey(n3)) {
                Serializable serializable = (Serializable)this.valueCache.get(n3);
                return serializable;
            }
            throw new IndirectionException(n2);
        }
        n2 -= 4;
        boolean bl = this.isChunked;
        this.isChunked = RepositoryId.isChunkedEncoding(n);
        java.lang.Object object = null;
        String string2 = null;
        if (RepositoryId.isCodeBasePresent(n)) {
            string2 = this.read_codebase_URL();
        }
        String string3 = null;
        switch (RepositoryId.getTypeInfo(n)) {
            case 0: {
                string3 = string;
                break;
            }
            case 2: {
                string3 = this.read_repositoryId();
                break;
            }
            case 6: {
                string3 = this.read_repositoryIds();
            }
        }
        this.start_block();
        --this.end_flag;
        object = this.readFactoryValue(n2, string3, null, string2);
        this.end_block();
        this.readEndTag();
        if (this.valueCache == null) {
            this.valueCache = new Hashtable();
        }
        this.valueCache.put(new Integer(n2), object);
        this.isChunked = bl;
        this.start_block();
        return (Serializable)object;
    }

    private Class readClass() {
        return Utility.readClassValue(this);
    }

    private java.lang.Object readFactoryValue(int n, String string, Class clazz, String string2) {
        ValueFactory valueFactory = Utility.getFactory(clazz, string2, this.orb, string);
        this.valueIndirection = n;
        return valueFactory.read_value(this);
    }

    private java.lang.Object readBoxedIDLEntity(Class clazz, String string) {
        try {
            ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
            Class clazz2 = Utility.loadClassForClass(clazz.getName() + "Helper", string, classLoader, clazz, classLoader);
            Class[] classArray = new Class[]{class$org$omg$CORBA$portable$InputStream == null ? (class$org$omg$CORBA$portable$InputStream = CDRInputStream.class$("org.omg.CORBA.portable.InputStream")) : class$org$omg$CORBA$portable$InputStream};
            Method method = clazz2.getDeclaredMethod(kReadMethod, classArray);
            java.lang.Object[] objectArray = new java.lang.Object[]{this};
            return method.invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MARSHAL(classNotFoundException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new MARSHAL(noSuchMethodException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MARSHAL(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new MARSHAL(invocationTargetException.getMessage());
        }
    }

    private java.lang.Object readIDLValue(int n, String string, Class clazz, String string2) {
        if ((class$org$omg$CORBA$portable$StreamableValue == null ? (class$org$omg$CORBA$portable$StreamableValue = CDRInputStream.class$("org.omg.CORBA.portable.StreamableValue")) : class$org$omg$CORBA$portable$StreamableValue).isAssignableFrom(clazz) || (class$org$omg$CORBA$portable$CustomValue == null ? (class$org$omg$CORBA$portable$CustomValue = CDRInputStream.class$("org.omg.CORBA.portable.CustomValue")) : class$org$omg$CORBA$portable$CustomValue).isAssignableFrom(clazz)) {
            return this.readFactoryValue(n, string, clazz, string2);
        }
        if ((class$org$omg$CORBA$portable$ValueBase == null ? (class$org$omg$CORBA$portable$ValueBase = CDRInputStream.class$("org.omg.CORBA.portable.ValueBase")) : class$org$omg$CORBA$portable$ValueBase).isAssignableFrom(clazz)) {
            BoxedValueHelper boxedValueHelper = Utility.getHelper(clazz, string2, string);
            return boxedValueHelper.read_value(this);
        }
        return this.readBoxedIDLEntity(clazz, string2);
    }

    private void readEndTag() {
        if (this.isChunked) {
            int n = this.mark();
            int n2 = this.read_long();
            if (n2 != this.end_flag) {
                this.reset(n);
            }
        }
        ++this.end_flag;
    }

    private int get_offset() {
        return this.index;
    }

    private void start_block() {
        if (!this.isChunked) {
            return;
        }
        this.blockLength = 0x7FFFFF00L;
        this.blockLength = this.read_long();
        if (this.blockLength > 0L && this.blockLength < 0x7FFFFF00L) {
            this.blockLength += (long)this.index;
        } else {
            this.blockLength = 0x7FFFFF00L;
            this.index -= 4;
        }
    }

    private void end_block() {
        if (this.blockLength != 0x7FFFFF00L) {
            if (this.blockLength == (long)this.index) {
                this.blockLength = 0x7FFFFF00L;
            } else {
                throw new MARSHAL("Incorrect chunk length " + this.blockLength + " at offset " + this.index, 997, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    private int readValueTag() {
        return this.read_long();
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    private Connection getConnection() {
        if (this.conn != null) {
            return this.conn;
        }
        if (this instanceof IIOPInputStream) {
            this.conn = ((IIOPInputStream)this).getConnection();
        }
        return this.conn;
    }

    private CodeBase getFVDCodeBase() {
        Connection connection = this.getConnection();
        if (connection != null) {
            try {
                return ((CDRConnection)((java.lang.Object)connection)).getFVDCodeBase();
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }
        return null;
    }

    private int getTcsChar() {
        if (this.tcsChar != -1) {
            return this.tcsChar;
        }
        Connection connection = this.getConnection();
        this.tcsChar = connection != null ? connection.getCharCodeSet() : 65537;
        return this.tcsChar;
    }

    private int getTcsWChar() {
        if (this.tcsWChar != -1) {
            return this.tcsWChar;
        }
        Connection connection = this.getConnection();
        this.tcsWChar = connection != null ? connection.getWCharCodeSet() : 65792;
        if (this.tcsWChar == 0 && this.getPartnerMajor() < 12 && this.getPartnerMinor() < 1) {
            this.tcsWChar = 65792;
        }
        return this.tcsWChar;
    }

    private ByteToCharConverter getCharConverter() {
        String string;
        if (this.tcsCharConverter != null) {
            return this.tcsCharConverter;
        }
        int n = this.getTcsChar();
        String string2 = CodeSetComponentInfo.mapRegistryId(n);
        if (this.orb != null && n != 0x5010001 && n == CodeSetComponentInfo.mapRegistryId(string = this.orb.getORBCharEncoding())) {
            string2 = string;
        }
        try {
            this.tcsCharConverter = ByteToCharConverter.getConverter(string2);
            this.tcsCharConverter.setSubstitutionMode(false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DATA_CONVERSION(9, CompletionStatus.COMPLETED_NO);
        }
        return this.tcsCharConverter;
    }

    public final void read_boolean_array(boolean[] blArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            blArray[n3 + n] = this.read_boolean();
            ++n3;
        }
    }

    public final void read_char_array(char[] cArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3 + n] = this.read_char();
            ++n3;
        }
    }

    public final void read_wchar_array(char[] cArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3 + n] = this.read_wchar();
            ++n3;
        }
    }

    public final void read_short_array(short[] sArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            sArray[n3 + n] = this.read_short();
            ++n3;
        }
    }

    public final void read_ushort_array(short[] sArray, int n, int n2) {
        this.read_short_array(sArray, n, n2);
    }

    public final void read_long_array(int[] nArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3 + n] = this.read_long();
            ++n3;
        }
    }

    public final void read_ulong_array(int[] nArray, int n, int n2) {
        this.read_long_array(nArray, n, n2);
    }

    public final void read_longlong_array(long[] lArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            lArray[n3 + n] = this.read_longlong();
            ++n3;
        }
    }

    public final void read_ulonglong_array(long[] lArray, int n, int n2) {
        this.read_longlong_array(lArray, n, n2);
    }

    public final void read_float_array(float[] fArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            fArray[n3 + n] = this.read_float();
            ++n3;
        }
    }

    public final void read_double_array(double[] dArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            dArray[n3 + n] = this.read_double();
            ++n3;
        }
    }

    public final void read_any_array(Any[] anyArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            anyArray[n3 + n] = this.read_any();
            ++n3;
        }
    }

    public final void rewind() {
        this.offset += this.index;
        this.index = 0;
    }

    public final boolean isAtEnd() {
        return this.index == this.size;
    }

    public int available() throws IOException {
        return this.size - this.index;
    }

    public int mark() {
        return this.index;
    }

    public void reset(int n) {
        this.index = n;
    }

    public void setExpectedType(Class clazz) {
        this.expectedType = clazz;
    }

    private String read_repositoryIds() {
        int n = this.read_long();
        if (n == -1) {
            int n2 = this.get_offset() + this.read_long();
            if (this.repositoryIdCache != null && this.repositoryIdCache.containsOrderedVal(n2)) {
                return (String)this.repositoryIdCache.getKey(n2);
            }
            throw new MARSHAL("Unable to locate array of repository IDs from indirection " + n2);
        }
        int n3 = this.get_offset() - 4;
        String string = this.read_repositoryId();
        if (this.repositoryIdCache == null) {
            this.repositoryIdCache = new CacheTable(false);
        }
        this.repositoryIdCache.put(string, n3);
        int n4 = 1;
        while (n4 < n) {
            this.read_repositoryId();
            ++n4;
        }
        return string;
    }

    private final String read_repositoryId() {
        String string = this.readStringOrIndirection(true);
        if (string == null) {
            int n = this.get_offset() + this.read_long();
            if (this.repositoryIdCache != null && this.repositoryIdCache.containsOrderedVal(n)) {
                return (String)this.repositoryIdCache.getKey(n);
            }
            throw new MARSHAL("Repid indirection @ " + this.index, 0, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.repositoryIdCache == null) {
            this.repositoryIdCache = new CacheTable(false);
        }
        this.repositoryIdCache.put(string, this.stringIndirection);
        return string;
    }

    private final String read_codebase_URL() {
        String string = this.readStringOrIndirection(true);
        if (string == null) {
            int n = this.get_offset() + this.read_long();
            if (this.codebaseCache != null && this.codebaseCache.containsVal(n)) {
                return (String)this.codebaseCache.getKey(n);
            }
            throw new MARSHAL("Codebase indirection @ " + this.index, 0, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.codebaseCache == null) {
            this.codebaseCache = new CacheTable(false);
        }
        this.codebaseCache.put(string, this.stringIndirection);
        return string;
    }

    public java.lang.Object read_Abstract() {
        return this.read_abstract_interface();
    }

    public Serializable read_Value() {
        return this.read_value();
    }

    public void read_any_array(AnySeqHolder anySeqHolder, int n, int n2) {
        this.read_any_array(anySeqHolder.value, n, n2);
    }

    public void read_boolean_array(BooleanSeqHolder booleanSeqHolder, int n, int n2) {
        this.read_boolean_array(booleanSeqHolder.value, n, n2);
    }

    public void read_char_array(CharSeqHolder charSeqHolder, int n, int n2) {
        this.read_char_array(charSeqHolder.value, n, n2);
    }

    public void read_wchar_array(WCharSeqHolder wCharSeqHolder, int n, int n2) {
        this.read_wchar_array(wCharSeqHolder.value, n, n2);
    }

    public void read_octet_array(OctetSeqHolder octetSeqHolder, int n, int n2) {
        this.read_octet_array(octetSeqHolder.value, n, n2);
    }

    public void read_short_array(ShortSeqHolder shortSeqHolder, int n, int n2) {
        this.read_short_array(shortSeqHolder.value, n, n2);
    }

    public void read_ushort_array(UShortSeqHolder uShortSeqHolder, int n, int n2) {
        this.read_ushort_array(uShortSeqHolder.value, n, n2);
    }

    public void read_long_array(LongSeqHolder longSeqHolder, int n, int n2) {
        this.read_long_array(longSeqHolder.value, n, n2);
    }

    public void read_ulong_array(ULongSeqHolder uLongSeqHolder, int n, int n2) {
        this.read_ulong_array(uLongSeqHolder.value, n, n2);
    }

    public void read_ulonglong_array(ULongLongSeqHolder uLongLongSeqHolder, int n, int n2) {
        this.read_ulonglong_array(uLongLongSeqHolder.value, n, n2);
    }

    public void read_longlong_array(LongLongSeqHolder longLongSeqHolder, int n, int n2) {
        this.read_longlong_array(longLongSeqHolder.value, n, n2);
    }

    public void read_float_array(FloatSeqHolder floatSeqHolder, int n, int n2) {
        this.read_float_array(floatSeqHolder.value, n, n2);
    }

    public void read_double_array(DoubleSeqHolder doubleSeqHolder, int n, int n2) {
        this.read_double_array(doubleSeqHolder.value, n, n2);
    }

    public String[] _truncatable_ids() {
        return _ids;
    }

    public void printBuffer() {
        int n = 0;
        while (n < this.size) {
            int n2 = 0;
            while (n2 < 16) {
                String string;
                int n3 = this.buf[n + n2];
                if (n3 < 0) {
                    n3 = 256 + n3;
                }
                if ((string = Integer.toHexString(n3)).length() == 1) {
                    string = "0" + string;
                }
                System.out.print(string + " ");
                ++n2;
            }
            System.out.println(new String(this.buf, n, 16));
            n += 16;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

