/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.rmi.ClientSubcontract;
import com.ibm.rmi.CodeSetComponentInfo;
import com.ibm.rmi.IOR;
import com.ibm.rmi.MarshalOutputStream;
import com.ibm.rmi.ORB;
import com.ibm.rmi.corba.TypeCodeImpl;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.IIOPOutputStream;
import com.ibm.rmi.io.ValueHandlerImpl;
import com.ibm.rmi.util.CacheTable;
import com.ibm.rmi.util.PartnerVersion;
import com.ibm.rmi.util.RepositoryId;
import com.ibm.rmi.util.Utility;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.CustomMarshal;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.DataOutputStream;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;
import sun.io.CharToByteConverter;

public class CDROutputStream
extends org.omg.CORBA_2_3.portable.OutputStream
implements MarshalOutputStream,
DataOutputStream,
PartnerVersion {
    protected boolean littleEndian;
    protected int size;
    protected int buflen;
    protected int offset;
    protected byte[] buf;
    protected ORB orb;
    protected int blockSizeIndex = -1;
    protected int tcsChar = -1;
    protected int tcsWChar = -1;
    protected CharToByteConverter tcsCharConverter = null;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final String kWriteMethod = "write";
    private CacheTable codebaseCache = null;
    private CacheTable valueCache = null;
    private CacheTable repositoryIdCache = null;
    private int end_flag = 0;
    private boolean mustChunk = false;
    private boolean inBlock = false;
    private int end_flag_index = 0;
    private ValueHandler valueHandler = null;
    private Connection conn = null;
    private short partnerMajor;
    private short partnerMinor;
    private static String _id = "IDL:omg.org/CORBA/DataOutputStream:1.0";
    private static String[] _ids = new String[]{_id};
    static /* synthetic */ Class class$org$omg$CORBA$portable$OutputStream;

    public CDROutputStream(org.omg.CORBA.ORB oRB) {
        this(oRB, false);
    }

    public CDROutputStream(org.omg.CORBA.ORB oRB, boolean bl) {
        this(oRB, bl, 1024);
    }

    public CDROutputStream(org.omg.CORBA.ORB oRB, boolean bl, int n) {
        this.orb = (ORB)oRB;
        this.littleEndian = bl;
        this.buf = new byte[n];
        this.size = 0;
        this.buflen = n;
        this.offset = 0;
    }

    public CDROutputStream(org.omg.CORBA.ORB oRB, int n, int n2) {
        this(oRB, false);
        this.tcsChar = n;
        this.tcsWChar = n2;
    }

    public CDROutputStream() {
    }

    public void setPartnerVersion(short s, short s2) {
        this.partnerMajor = s;
        this.partnerMinor = s2;
    }

    public short getPartnerMajor() {
        Connection connection;
        if (this.partnerMajor == 0 && (connection = this.getConnection()) != null && connection instanceof PartnerVersion) {
            this.partnerMajor = ((PartnerVersion)((java.lang.Object)connection)).getPartnerMajor();
        }
        return this.partnerMajor;
    }

    public short getPartnerMinor() {
        Connection connection;
        if (this.partnerMinor == 0 && (connection = this.getConnection()) != null && connection instanceof PartnerVersion) {
            this.partnerMinor = ((PartnerVersion)((java.lang.Object)connection)).getPartnerMinor();
        }
        return this.partnerMinor;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.size];
        System.arraycopy(this.buf, 0, byArray, 0, this.size);
        return byArray;
    }

    private final void alignAndReserve(int n, int n2) {
        int n3;
        if (n > 1 && (n3 = this.size & n - 1) != 0) {
            n3 = n - n3;
            this.size += n3;
        }
        if (this.size + n2 >= this.buflen) {
            this.grow(n, n2);
        }
    }

    private byte[] convertToAscii(char[] cArray) {
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] > '\u00ff') {
                throw new DATA_CONVERSION(6, CompletionStatus.COMPLETED_NO);
            }
            byArray[n] = (byte)(cArray[n] & 0xFF);
            ++n;
        }
        return byArray;
    }

    private byte[] convertToTcsChar(char[] cArray) {
        int n = this.getTcsChar();
        if (n == 0 || n == 65537 || n == 65568) {
            return this.convertToAscii(cArray);
        }
        if (n == 268567780 || n == 65551) {
            int n2 = 0;
            while (n2 < cArray.length) {
                if (cArray[n2] > '\u007f') break;
                ++n2;
            }
            if (n2 >= cArray.length) {
                return this.convertToAscii(cArray);
            }
        }
        CharToByteConverter charToByteConverter = this.getCharConverter();
        try {
            int n3 = cArray.length * charToByteConverter.getMaxBytesPerChar();
            byte[] byArray = new byte[n3];
            int n4 = 0;
            charToByteConverter.reset();
            n4 += charToByteConverter.convert(cArray, 0, cArray.length, byArray, 0, n3);
            if ((n4 += charToByteConverter.flush(byArray, charToByteConverter.nextByteIndex(), n3)) < n3) {
                byte[] byArray2 = new byte[n4];
                System.arraycopy(byArray, 0, byArray2, 0, n4);
                return byArray2;
            }
            return byArray;
        }
        catch (CharConversionException charConversionException) {
            throw new DATA_CONVERSION(6, CompletionStatus.COMPLETED_NO);
        }
    }

    private final char[] convertToTcsWChar(char[] cArray) {
        int n = this.getTcsWChar();
        if (n == 0) {
            throw new INV_OBJREF(1, CompletionStatus.COMPLETED_NO);
        }
        if (n == 65792) {
            return cArray;
        }
        return Utility.convertToUTF16(cArray, this.littleEndian);
    }

    protected void grow(int n, int n2) {
        if (this.buf == null) {
            int n3 = 1024;
            while (this.size + n2 >= n3) {
                n3 *= 2;
            }
            this.buf = new byte[n3];
            this.buflen = this.buf.length;
            return;
        }
        byte[] byArray = this.buf;
        int n4 = byArray.length * 2;
        while (this.size + n2 >= n4) {
            n4 *= 2;
        }
        this.buf = new byte[n4];
        System.arraycopy(byArray, 0, this.buf, 0, byArray.length);
        this.buflen = this.buf.length;
    }

    public final void putEndian() throws SystemException {
        this.write_boolean(this.littleEndian);
    }

    public final boolean littleEndian() {
        return this.littleEndian;
    }

    public InputStream create_input_stream() {
        if (this.codebaseCache != null) {
            this.codebaseCache.done();
        }
        if (this.valueCache != null) {
            this.valueCache.done();
        }
        if (this.repositoryIdCache != null) {
            this.repositoryIdCache.done();
        }
        return new CDRInputStream((org.omg.CORBA.ORB)this.orb, this.buf, this.size, this.littleEndian);
    }

    public final void write_longdouble(double d) {
        throw new NO_IMPLEMENT(3, CompletionStatus.COMPLETED_MAYBE);
    }

    public final void write_octet(byte by) {
        if (this.size + 1 >= this.buflen) {
            this.alignAndReserve(1, 1);
        }
        this.buf[this.size++] = by;
    }

    public final void write_boolean(boolean bl) {
        this.write_octet(bl ? (byte)1 : 0);
    }

    public final void write_char(char c) {
        byte[] byArray = this.convertToTcsChar(new char[]{c});
        if (byArray.length > 1) {
            throw new DATA_CONVERSION(6, CompletionStatus.COMPLETED_NO);
        }
        this.write_octet(byArray[0]);
    }

    private final void writeLittleEndianWchar(char c) {
        this.buf[this.size++] = (byte)(c & 0xFF);
        this.buf[this.size++] = (byte)(c >>> 8 & 0xFF);
    }

    private final void writeBigEndianWchar(char c) {
        this.buf[this.size++] = (byte)(c >>> 8 & 0xFF);
        this.buf[this.size++] = (byte)(c & 0xFF);
    }

    private final void writeLittleEndianShort(short s) {
        this.buf[this.size++] = (byte)(s & 0xFF);
        this.buf[this.size++] = (byte)(s >>> 8 & 0xFF);
    }

    private final void writeBigEndianShort(short s) {
        this.buf[this.size++] = (byte)(s >>> 8 & 0xFF);
        this.buf[this.size++] = (byte)(s & 0xFF);
    }

    private final void writeLittleEndianLong(int n) {
        this.buf[this.size++] = (byte)(n & 0xFF);
        this.buf[this.size++] = (byte)(n >>> 8 & 0xFF);
        this.buf[this.size++] = (byte)(n >>> 16 & 0xFF);
        this.buf[this.size++] = (byte)(n >>> 24 & 0xFF);
    }

    private final void writeBigEndianLong(int n) {
        this.buf[this.size++] = (byte)(n >>> 24 & 0xFF);
        this.buf[this.size++] = (byte)(n >>> 16 & 0xFF);
        this.buf[this.size++] = (byte)(n >>> 8 & 0xFF);
        this.buf[this.size++] = (byte)(n & 0xFF);
    }

    private final void writeLittleEndianLongLong(long l) {
        this.buf[this.size++] = (byte)(l & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 8 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 16 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 24 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 32 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 40 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 48 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 56 & 0xFFL);
    }

    private final void writeBigEndianLongLong(long l) {
        this.buf[this.size++] = (byte)(l >>> 56 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 48 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 40 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 32 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 24 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 16 & 0xFFL);
        this.buf[this.size++] = (byte)(l >>> 8 & 0xFFL);
        this.buf[this.size++] = (byte)(l & 0xFFL);
    }

    public final void write_wchar(char c) {
        char[] cArray = this.convertToTcsWChar(new char[]{c});
        if (cArray.length > 1) {
            throw new DATA_CONVERSION(6, CompletionStatus.COMPLETED_NO);
        }
        this.alignAndReserve(2, 2);
        if (this.littleEndian) {
            this.writeLittleEndianWchar(cArray[0]);
        } else {
            this.writeBigEndianWchar(cArray[0]);
        }
    }

    public final void write_short(short s) {
        this.alignAndReserve(2, 2);
        if (this.littleEndian) {
            this.writeLittleEndianShort(s);
        } else {
            this.writeBigEndianShort(s);
        }
    }

    public final void write_ushort(short s) {
        this.write_short(s);
    }

    public final void write_long(int n) {
        if ((this.size & 3) != 0 || this.size + 4 >= this.buflen) {
            this.alignAndReserve(4, 4);
        }
        if (this.littleEndian) {
            this.writeLittleEndianLong(n);
        } else {
            this.writeBigEndianLong(n);
        }
    }

    public final void write_ulong(int n) {
        this.write_long(n);
    }

    public final void write_longlong(long l) {
        this.alignAndReserve(8, 8);
        if (this.littleEndian) {
            this.writeLittleEndianLongLong(l);
        } else {
            this.writeBigEndianLongLong(l);
        }
    }

    public final void write_ulonglong(long l) {
        this.write_longlong(l);
    }

    public final void write_float(float f) {
        this.write_long(Float.floatToIntBits(f));
    }

    public final void write_double(double d) {
        this.write_longlong(Double.doubleToLongBits(d));
    }

    public final void write_string(String string) {
        int n;
        if (string == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        byte[] byArray = this.convertToTcsChar(string.toCharArray());
        int n2 = this.size & 3;
        if (n2 != 0) {
            n2 = 4 - n2;
            this.size += n2;
        }
        if (this.size + 4 + (n = byArray.length + 1) >= this.buflen) {
            this.alignAndReserve(4, 4 + n);
        }
        if (this.littleEndian) {
            this.writeLittleEndianLong(n);
        } else {
            this.writeBigEndianLong(n);
        }
        --n;
        int n3 = 0;
        while (n3 < n) {
            this.buf[this.size++] = byArray[n3];
            ++n3;
        }
        this.buf[this.size++] = 0;
    }

    public final void write_wstring(String string) {
        int n;
        if (string == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        char[] cArray = this.convertToTcsWChar(string.toCharArray());
        int n2 = this.size & 3;
        if (n2 != 0) {
            n2 = 4 - n2;
            this.size += n2;
        }
        if (this.size + 4 + (n = cArray.length + 1) * 2 >= this.buflen) {
            this.alignAndReserve(4, 4 + n * 2);
        }
        if (this.littleEndian) {
            this.writeLittleEndianLong(n);
            --n;
            int n3 = 0;
            while (n3 < n) {
                char c = cArray[n3];
                this.buf[this.size++] = (byte)(c & 0xFF);
                this.buf[this.size++] = (byte)(c >>> 8 & 0xFF);
                ++n3;
            }
        } else {
            this.writeBigEndianLong(n);
            --n;
            int n4 = 0;
            while (n4 < n) {
                char c = cArray[n4];
                this.buf[this.size++] = (byte)(c >>> 8 & 0xFF);
                this.buf[this.size++] = (byte)(c & 0xFF);
                ++n4;
            }
        }
        this.buf[this.size++] = 0;
        this.buf[this.size++] = 0;
    }

    public final void write_octet_array(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        int n3 = n;
        while (n3 < n2 + n) {
            int n4;
            int n5;
            if (this.size + 1 >= this.buflen) {
                this.alignAndReserve(1, 1);
            }
            int n6 = (n5 = n2 + n - n3) < (n4 = this.buf.length - this.size) ? n5 : n4;
            System.arraycopy(byArray, n3, this.buf, this.size, n6);
            this.size += n6;
            n3 += n6;
        }
    }

    public void write_Principal(Principal principal) {
        this.write_long(principal.name().length);
        this.write_octet_array(principal.name(), 0, principal.name().length);
    }

    public void write_any(Any any) {
        if (any == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_TypeCode(any.type());
        any.write_value(this);
    }

    public void write_TypeCode(TypeCode typeCode) {
        if (typeCode == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        TypeCodeImpl typeCodeImpl = typeCode instanceof TypeCodeImpl ? (TypeCodeImpl)typeCode : new TypeCodeImpl((org.omg.CORBA.ORB)this.orb, typeCode);
        typeCodeImpl.write_value(this);
    }

    public void write_Object(Object object) {
        if (object == null) {
            IOR.NULL.write(this);
            return;
        }
        ObjectImpl objectImpl = (ObjectImpl)object;
        ClientSubcontract clientSubcontract = null;
        IOR iOR = null;
        try {
            clientSubcontract = (ClientSubcontract)((java.lang.Object)objectImpl._get_delegate());
            iOR = clientSubcontract.marshal();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iOR == null) {
            if (object instanceof Stub) {
                try {
                    ((Stub)object).connect(this.orb);
                }
                catch (RemoteException remoteException) {
                    throw new MARSHAL(0, CompletionStatus.COMPLETED_MAYBE);
                }
            } else {
                this.orb.connect(object);
            }
            clientSubcontract = (ClientSubcontract)((java.lang.Object)objectImpl._get_delegate());
            iOR = clientSubcontract.marshal();
        }
        iOR.write(this);
    }

    public void write_abstract_interface(java.lang.Object object) {
        boolean bl = false;
        Object object2 = null;
        if (object != null && object instanceof Object) {
            object2 = (Object)object;
            bl = true;
        }
        this.write_boolean(bl);
        if (bl) {
            this.write_Object(object2);
        } else {
            try {
                this.write_value((Serializable)object);
            }
            catch (ClassCastException classCastException) {
                if (object instanceof Serializable) {
                    throw classCastException;
                }
                Utility.throwNotSerializableForCorba();
            }
        }
    }

    public void write_value(Serializable serializable, Class clazz) {
        this.write_value(serializable);
    }

    public void write_value(Serializable serializable, String string) {
        if (serializable == null) {
            this.write_long(0);
            return;
        }
        if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
            this.write_long(-1);
            this.write_long(this.valueCache.getVal(serializable) - this.get_offset());
            return;
        }
        Class clazz = serializable.getClass();
        boolean bl = this.mustChunk;
        boolean bl2 = false;
        short s = this.getPartnerMajor();
        short s2 = this.getPartnerMinor();
        if (s != 0 && s < 12 && s2 < 2) {
            bl2 = true;
        }
        if (this.inBlock) {
            this.end_block();
        }
        if (clazz.isArray()) {
            if (this.valueHandler == null) {
                this.valueHandler = new ValueHandlerImpl(false);
            }
            if (this.mustChunk) {
                int n = this.writeValueTag(true, false, Util.getCodebase(clazz));
                this.write_repositoryId(RepositoryId.createSequenceRepID(clazz, bl2));
                this.updateIndirectionTable(n, serializable, serializable);
                this.start_block();
                --this.end_flag;
                this.valueHandler.writeValue(this, serializable);
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n = this.writeValueTag(false, false, Util.getCodebase(clazz));
                this.write_repositoryId(RepositoryId.createSequenceRepID(clazz, bl2));
                this.updateIndirectionTable(n, serializable, serializable);
                --this.end_flag;
                this.valueHandler.writeValue(this, serializable);
                this.writeEndTag(false);
            }
        } else if (serializable instanceof ValueBase) {
            this.mustChunk = true;
            int n = this.writeValueTag(true, false, Util.getCodebase(clazz));
            String string2 = ((ValueBase)serializable)._truncatable_ids()[0];
            this.write_repositoryId(string2);
            this.updateIndirectionTable(n, serializable, serializable);
            this.start_block();
            --this.end_flag;
            this.writeIDLValue(serializable, string2);
            this.end_block();
            this.writeEndTag(true);
        } else if (this.shouldWriteAsIDLEntity(serializable)) {
            this.writeIDLEntity((IDLEntity)serializable);
        } else if (serializable instanceof String) {
            if (this.mustChunk) {
                int n = this.writeValueTag(true, false, null);
                this.write_repositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
                this.updateIndirectionTable(n, serializable, serializable);
                this.start_block();
                --this.end_flag;
                this.write_wstring((String)((java.lang.Object)serializable));
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n = this.writeValueTag(false, false, null);
                this.write_repositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
                this.updateIndirectionTable(n, serializable, serializable);
                --this.end_flag;
                this.write_wstring((String)((java.lang.Object)serializable));
                this.writeEndTag(false);
            }
        } else if (serializable instanceof Class) {
            this.writeClass(string, (Class)serializable);
        } else {
            Serializable serializable2;
            if (this.valueHandler == null) {
                this.valueHandler = new ValueHandlerImpl(false);
            }
            if ((serializable = this.valueHandler.writeReplace(serializable2 = serializable)) == null) {
                this.write_long(0);
                return;
            }
            if (serializable != serializable2) {
                if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
                    this.write_long(-1);
                    this.write_long(this.valueCache.getVal(serializable) - this.get_offset());
                    return;
                }
                clazz = serializable.getClass();
            }
            if (this.mustChunk || this.valueHandler.isCustomMarshaled(clazz)) {
                this.mustChunk = true;
                int n = this.writeValueTag(true, false, Util.getCodebase(clazz));
                this.write_repositoryId(RepositoryId.createForJavaType(clazz, bl2));
                this.updateIndirectionTable(n, serializable, serializable2);
                --this.end_flag;
                this.start_block();
                this.valueHandler.writeValue(this, serializable);
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n = this.writeValueTag(false, false, Util.getCodebase(clazz));
                this.write_repositoryId(RepositoryId.createForJavaType(clazz, bl2));
                this.updateIndirectionTable(n, serializable, serializable2);
                --this.end_flag;
                this.valueHandler.writeValue(this, serializable);
                this.writeEndTag(false);
            }
        }
        this.mustChunk = bl;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    public void write_value(Serializable serializable) {
        if (serializable == null) {
            this.write_long(0);
            return;
        }
        if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
            this.write_long(-1);
            this.write_long(this.valueCache.getVal(serializable) - this.get_offset());
            return;
        }
        Class clazz = serializable.getClass();
        boolean bl = this.mustChunk;
        boolean bl2 = false;
        short s = this.getPartnerMajor();
        short s2 = this.getPartnerMinor();
        if (s != 0 && s < 12 && s2 < 2) {
            bl2 = true;
        }
        if (this.inBlock) {
            this.end_block();
        }
        if (clazz.isArray()) {
            if (this.valueHandler == null) {
                this.valueHandler = new ValueHandlerImpl(false);
            }
            if (this.mustChunk) {
                int n = this.writeValueTag(true, false, Util.getCodebase(clazz));
                this.write_repositoryId(RepositoryId.createSequenceRepID(clazz, bl2));
                this.updateIndirectionTable(n, serializable, serializable);
                this.start_block();
                --this.end_flag;
                this.valueHandler.writeValue(this, serializable);
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n = this.writeValueTag(false, false, Util.getCodebase(clazz));
                this.write_repositoryId(RepositoryId.createSequenceRepID(clazz, bl2));
                this.updateIndirectionTable(n, serializable, serializable);
                --this.end_flag;
                this.valueHandler.writeValue(this, serializable);
                this.writeEndTag(false);
            }
        } else if (serializable instanceof ValueBase) {
            this.mustChunk = true;
            int n = this.writeValueTag(true, false, Util.getCodebase(clazz));
            String string = ((ValueBase)serializable)._truncatable_ids()[0];
            this.write_repositoryId(string);
            this.updateIndirectionTable(n, serializable, serializable);
            this.start_block();
            --this.end_flag;
            this.writeIDLValue(serializable, string);
            this.end_block();
            this.writeEndTag(true);
        } else if (this.shouldWriteAsIDLEntity(serializable)) {
            this.writeIDLEntity((IDLEntity)serializable);
        } else if (serializable instanceof String) {
            if (this.mustChunk) {
                int n = this.writeValueTag(true, false, null);
                this.write_repositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
                this.updateIndirectionTable(n, serializable, serializable);
                this.start_block();
                --this.end_flag;
                this.write_wstring((String)((java.lang.Object)serializable));
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n = this.writeValueTag(false, false, null);
                this.write_repositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
                this.updateIndirectionTable(n, serializable, serializable);
                --this.end_flag;
                this.write_wstring((String)((java.lang.Object)serializable));
                this.writeEndTag(false);
            }
        } else if (serializable instanceof Class) {
            this.writeClass(RepositoryId.kClassDescValueRepID, (Class)serializable);
        } else {
            Serializable serializable2;
            if (this.valueHandler == null) {
                this.valueHandler = new ValueHandlerImpl(false);
            }
            if ((serializable = this.valueHandler.writeReplace(serializable2 = serializable)) == null) {
                this.write_long(0);
                return;
            }
            if (serializable != serializable2) {
                if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
                    this.write_long(-1);
                    this.write_long(this.valueCache.getVal(serializable) - this.get_offset());
                    return;
                }
                clazz = serializable.getClass();
            }
            if (this.mustChunk || this.valueHandler.isCustomMarshaled(clazz)) {
                this.mustChunk = true;
                int n = this.writeValueTag(true, false, Util.getCodebase(clazz));
                this.write_repositoryId(RepositoryId.createForJavaType(clazz, bl2));
                this.updateIndirectionTable(n, serializable, serializable2);
                --this.end_flag;
                this.start_block();
                this.valueHandler.writeValue(this, serializable);
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n = this.writeValueTag(false, false, Util.getCodebase(clazz));
                this.write_repositoryId(RepositoryId.createForJavaType(clazz, bl2));
                this.updateIndirectionTable(n, serializable, serializable2);
                --this.end_flag;
                this.valueHandler.writeValue(this, serializable);
                this.writeEndTag(false);
            }
        }
        this.mustChunk = bl;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    public void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        if (serializable == null) {
            this.write_long(0);
            return;
        }
        if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
            this.write_long(-1);
            this.write_long(this.valueCache.getVal(serializable) - this.get_offset());
            return;
        }
        boolean bl = this.mustChunk;
        boolean bl2 = false;
        if (this.mustChunk) {
            if (this.inBlock) {
                this.end_block();
            }
            int n = this.writeValueTag(true, false, Util.getCodebase(serializable.getClass()));
            this.write_repositoryId(boxedValueHelper.get_id());
            this.updateIndirectionTable(n, serializable, serializable);
            this.start_block();
            --this.end_flag;
            if (bl2) {
                ((CustomMarshal)((java.lang.Object)serializable)).marshal(this);
            } else {
                boxedValueHelper.write_value(this, serializable);
            }
            this.end_block();
            this.writeEndTag(true);
        } else {
            int n = this.writeValueTag(false, false, Util.getCodebase(serializable.getClass()));
            this.write_repositoryId(boxedValueHelper.get_id());
            this.updateIndirectionTable(n, serializable, serializable);
            --this.end_flag;
            boxedValueHelper.write_value(this, serializable);
            this.writeEndTag(false);
        }
        this.mustChunk = bl;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    public int get_offset() {
        return this.offset + this.size;
    }

    public void start_block() {
        this.inBlock = true;
        this.write_long(0);
        this.blockSizeIndex = this.size;
    }

    public void end_block() {
        if (!this.inBlock) {
            return;
        }
        this.inBlock = false;
        if (this.size == this.blockSizeIndex) {
            this.size -= 4;
            this.blockSizeIndex = -1;
            return;
        }
        int n = this.size;
        this.size = this.blockSizeIndex - 4;
        this.write_long(n - this.blockSizeIndex);
        this.size = n;
        this.blockSizeIndex = -1;
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    private Connection getConnection() {
        if (this.conn != null) {
            return this.conn;
        }
        if (this instanceof IIOPOutputStream) {
            this.conn = ((IIOPOutputStream)this).getConnection();
        }
        return this.conn;
    }

    private int getTcsChar() {
        if (this.tcsChar != -1) {
            return this.tcsChar;
        }
        Connection connection = this.getConnection();
        this.tcsChar = connection != null ? connection.getCharCodeSet() : 65537;
        return this.tcsChar;
    }

    private int getTcsWChar() {
        if (this.tcsWChar != -1) {
            return this.tcsWChar;
        }
        Connection connection = this.getConnection();
        this.tcsWChar = connection != null ? connection.getWCharCodeSet() : 65792;
        if (this.tcsWChar == 0 && this.getPartnerMajor() < 12 && this.getPartnerMinor() < 1) {
            this.tcsWChar = 65792;
        }
        return this.tcsWChar;
    }

    private CharToByteConverter getCharConverter() {
        String string;
        if (this.tcsCharConverter != null) {
            return this.tcsCharConverter;
        }
        int n = this.getTcsChar();
        String string2 = CodeSetComponentInfo.mapRegistryId(n);
        if (this.orb != null && n != 0x5010001 && n == CodeSetComponentInfo.mapRegistryId(string = this.orb.getORBCharEncoding())) {
            string2 = string;
        }
        try {
            this.tcsCharConverter = CharToByteConverter.getConverter(string2);
            this.tcsCharConverter.setSubstitutionMode(false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DATA_CONVERSION(9, CompletionStatus.COMPLETED_NO);
        }
        return this.tcsCharConverter;
    }

    public final void write_boolean_array(boolean[] blArray, int n, int n2) {
        if (blArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.size + n2 >= this.buflen) {
            this.alignAndReserve(1, n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.buf[this.size++] = blArray[n3 + n] ? (byte)1 : 0;
            ++n3;
        }
    }

    public final void write_char_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.size + n2 >= this.buflen) {
            this.alignAndReserve(1, n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n3 + n];
            if (c > '\u00ff') {
                throw new DATA_CONVERSION(6, CompletionStatus.COMPLETED_NO);
            }
            this.buf[this.size++] = (byte)(c & 0xFF);
            ++n3;
        }
    }

    public final void write_wchar_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.alignAndReserve(2, n2 * 2);
        }
        if (this.littleEndian) {
            int n3 = 0;
            while (n3 < n2) {
                this.writeLittleEndianWchar(cArray[n3 + n]);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                this.writeBigEndianWchar(cArray[n4 + n]);
                ++n4;
            }
        }
    }

    public final void write_short_array(short[] sArray, int n, int n2) {
        if (sArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.alignAndReserve(2, n2 * 2);
        }
        if (this.littleEndian) {
            int n3 = 0;
            while (n3 < n2) {
                this.writeLittleEndianShort(sArray[n3 + n]);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                this.writeBigEndianShort(sArray[n4 + n]);
                ++n4;
            }
        }
    }

    public final void write_ushort_array(short[] sArray, int n, int n2) {
        this.write_short_array(sArray, n, n2);
    }

    public final void write_long_array(int[] nArray, int n, int n2) {
        if (nArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.alignAndReserve(4, n2 * 4);
        }
        if (this.littleEndian) {
            int n3 = 0;
            while (n3 < n2) {
                this.writeLittleEndianLong(nArray[n3 + n]);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                this.writeBigEndianLong(nArray[n4 + n]);
                ++n4;
            }
        }
    }

    public final void write_ulong_array(int[] nArray, int n, int n2) {
        this.write_long_array(nArray, n, n2);
    }

    public final void write_longlong_array(long[] lArray, int n, int n2) {
        if (lArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.alignAndReserve(8, n2 * 8);
        }
        if (this.littleEndian) {
            int n3 = 0;
            while (n3 < n2) {
                this.writeLittleEndianLongLong(lArray[n3 + n]);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                this.writeBigEndianLongLong(lArray[n4 + n]);
                ++n4;
            }
        }
    }

    public final void write_ulonglong_array(long[] lArray, int n, int n2) {
        this.write_longlong_array(lArray, n, n2);
    }

    public final void write_float_array(float[] fArray, int n, int n2) {
        if (fArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.alignAndReserve(4, n2 * 4);
        }
        if (this.littleEndian) {
            int n3 = 0;
            while (n3 < n2) {
                this.writeLittleEndianLong(Float.floatToIntBits(fArray[n3 + n]));
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                this.writeBigEndianLong(Float.floatToIntBits(fArray[n4 + n]));
                ++n4;
            }
        }
    }

    public final void write_double_array(double[] dArray, int n, int n2) {
        if (dArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.alignAndReserve(8, n2 * 8);
        }
        if (this.littleEndian) {
            int n3 = 0;
            while (n3 < n2) {
                this.writeLittleEndianLongLong(Double.doubleToLongBits(dArray[n3 + n]));
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                this.writeBigEndianLongLong(Double.doubleToLongBits(dArray[n4 + n]));
                ++n4;
            }
        }
    }

    public void write_string_array(String[] stringArray, int n, int n2) {
        if (stringArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.write_string(stringArray[n3 + n]);
            ++n3;
        }
    }

    public void write_wstring_array(String[] stringArray, int n, int n2) {
        if (stringArray == null) {
            throw new BAD_PARAM(1, CompletionStatus.COMPLETED_MAYBE);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.write_wstring(stringArray[n3 + n]);
            ++n3;
        }
    }

    public final void write_any_array(Any[] anyArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.write_any(anyArray[n3 + n]);
            ++n3;
        }
    }

    public final void reset() {
        this.offset += this.size;
        this.size = 0;
        this.end_flag = 0;
        this.end_flag_index = 0;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.size);
    }

    public void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream outputStream) {
        outputStream.write_long(this.size);
        outputStream.write_octet_array(this.buf, 0, this.size);
    }

    public final int getSize() {
        return this.size;
    }

    protected byte[] getBuffer() {
        return this.buf;
    }

    private final void updateIndirectionTable(int n, java.lang.Object object, java.lang.Object object2) {
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(true);
        }
        this.valueCache.put(object, n);
        if (object2 != object) {
            this.valueCache.put(object2, n);
        }
    }

    private final void write_repositoryId(String string) {
        byte[] byArray;
        if (this.repositoryIdCache != null && this.repositoryIdCache.containsKey(string)) {
            this.write_long(-1);
            this.write_long(this.repositoryIdCache.getVal(string) - this.get_offset());
            return;
        }
        int n = this.size & 3;
        if (n != 0) {
            n = 4 - n;
            this.size += n;
        }
        if ((byArray = RepositoryId.getByteArray(string)) == null) {
            int n2 = string.length() + 1;
            byArray = new byte[4 + n2];
            int n3 = 0;
            if (this.littleEndian) {
                byArray[n3++] = (byte)(n2 & 0xFF);
                byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
                byArray[n3++] = (byte)(n2 >>> 16 & 0xFF);
                byArray[n3++] = (byte)(n2 >>> 24 & 0xFF);
            } else {
                byArray[n3++] = (byte)(n2 >>> 24 & 0xFF);
                byArray[n3++] = (byte)(n2 >>> 16 & 0xFF);
                byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
                byArray[n3++] = (byte)(n2 & 0xFF);
            }
            char[] cArray = new char[string.length()];
            string.getChars(0, --n2, cArray, 0);
            int n4 = 0;
            while (n4 < n2) {
                if (cArray[n4] > '\u00ff') {
                    throw new DATA_CONVERSION(6, CompletionStatus.COMPLETED_NO);
                }
                byArray[n3++] = (byte)(cArray[n4] >>> 0 & 0xFF);
                ++n4;
            }
            byArray[n3++] = 0;
            RepositoryId.setByteArray(string, byArray);
        }
        if (this.repositoryIdCache == null) {
            this.repositoryIdCache = new CacheTable(true);
        }
        this.repositoryIdCache.put(string, this.get_offset());
        this.write_octet_array(byArray, 0, byArray.length);
    }

    private void write_codebase(String string, int n) {
        if (this.codebaseCache != null && this.codebaseCache.containsKey(string)) {
            this.write_long(-1);
            this.write_long(this.codebaseCache.getVal(string) - this.get_offset());
        } else {
            this.write_string(string);
            if (this.codebaseCache == null) {
                this.codebaseCache = new CacheTable(true);
            }
            this.codebaseCache.put(string, n);
        }
    }

    private final int writeValueTag(boolean bl, boolean bl2, String string) {
        int n = 0;
        if (bl && bl2) {
            if (string == null) {
                this.write_long(RepositoryId.kPreComputed_StandardRMIChunked_NoRep);
                n = this.get_offset() - 4;
            } else {
                this.write_long(RepositoryId.kPreComputed_CodeBaseRMIChunked_NoRep);
                n = this.get_offset() - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (bl && !bl2) {
            if (string == null) {
                this.write_long(RepositoryId.kPreComputed_StandardRMIChunked);
                n = this.get_offset() - 4;
            } else {
                this.write_long(RepositoryId.kPreComputed_CodeBaseRMIChunked);
                n = this.get_offset() - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (string == null) {
            this.write_long(RepositoryId.kPreComputed_StandardRMIUnchunked);
            n = this.get_offset() - 4;
        } else {
            this.write_long(RepositoryId.kPreComputed_CodeBaseRMIUnchunked);
            n = this.get_offset() - 4;
            this.write_codebase(string, this.get_offset());
        }
        return n;
    }

    private void writeIDLValue(Serializable serializable, String string) {
        if (serializable instanceof StreamableValue) {
            ((StreamableValue)serializable)._write(this);
        } else if (serializable instanceof CustomValue) {
            ((CustomValue)serializable).marshal(this);
        } else {
            BoxedValueHelper boxedValueHelper = Utility.getHelper(serializable.getClass(), null, string);
            boolean bl = false;
            if (bl) {
                ((CustomMarshal)((java.lang.Object)serializable)).marshal(this);
            } else {
                boxedValueHelper.write_value(this, serializable);
            }
        }
    }

    private void writeEndTag(boolean bl) {
        if (bl) {
            if (this.size == this.end_flag_index) {
                this.size -= 4;
            }
            this.write_long(this.end_flag);
        }
        this.end_flag_index = this.size;
        ++this.end_flag;
    }

    private void writeClass(String string, Class clazz) {
        if (this.mustChunk) {
            int n = this.writeValueTag(true, false, null);
            this.updateIndirectionTable(n, clazz, clazz);
            if (string != null) {
                this.write_repositoryId(string);
            } else {
                this.write_repositoryId(RepositoryId.kClassDescValueRepID);
            }
            this.start_block();
            --this.end_flag;
            Utility.writeClassValue(this, clazz);
            this.end_block();
            this.writeEndTag(true);
        } else {
            int n = this.writeValueTag(false, false, null);
            this.updateIndirectionTable(n, clazz, clazz);
            if (string != null) {
                this.write_repositoryId(string);
            } else {
                this.write_repositoryId(RepositoryId.kClassDescValueRepID);
            }
            --this.end_flag;
            Utility.writeClassValue(this, clazz);
            this.writeEndTag(false);
        }
    }

    private boolean shouldWriteAsIDLEntity(Serializable serializable) {
        return serializable instanceof IDLEntity && !(serializable instanceof ValueBase) && !(serializable instanceof Object);
    }

    private void writeIDLEntity(IDLEntity iDLEntity) {
        this.mustChunk = true;
        String string = RepositoryId.createForJavaType(iDLEntity);
        Class clazz = iDLEntity.getClass();
        String string2 = Util.getCodebase(clazz);
        int n = this.writeValueTag(true, false, string2);
        this.updateIndirectionTable(n, iDLEntity, iDLEntity);
        this.write_repositoryId(string);
        --this.end_flag;
        this.start_block();
        try {
            ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
            Class clazz2 = Utility.loadClassForClass(clazz.getName() + "Helper", string2, classLoader, clazz, classLoader);
            Class[] classArray = new Class[]{class$org$omg$CORBA$portable$OutputStream == null ? (class$org$omg$CORBA$portable$OutputStream = CDROutputStream.class$("org.omg.CORBA.portable.OutputStream")) : class$org$omg$CORBA$portable$OutputStream, clazz};
            Method method = clazz2.getDeclaredMethod(kWriteMethod, classArray);
            java.lang.Object[] objectArray = new java.lang.Object[]{this, iDLEntity};
            method.invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MARSHAL(classNotFoundException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new MARSHAL(noSuchMethodException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MARSHAL(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new MARSHAL(invocationTargetException.getMessage());
        }
        this.end_block();
        this.writeEndTag(true);
    }

    public void write_Abstract(java.lang.Object object) {
        this.write_abstract_interface(object);
    }

    public void write_Value(Serializable serializable) {
        this.write_value(serializable);
    }

    public String[] _truncatable_ids() {
        return _ids;
    }

    public void printBuffer() {
        int n = 0;
        while (n < this.size) {
            int n2 = 0;
            while (n2 < 16) {
                String string;
                int n3 = this.buf[n + n2];
                if (n3 < 0) {
                    n3 = 256 + n3;
                }
                if ((string = Integer.toHexString(n3)).length() == 1) {
                    string = "0" + string;
                }
                System.out.print(string + " ");
                ++n2;
            }
            System.out.println(new String(this.buf, n, 16));
            n += 16;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

