/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.rmi.IOR;
import com.ibm.rmi.RequestHandler;
import com.ibm.rmi.ServerRequest;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.IIOPConnection;
import com.ibm.rmi.iiop.IIOPInputStream;
import com.ibm.rmi.iiop.IIOPOutputStream;
import com.ibm.rmi.iiop.LocateReplyMessage;
import com.ibm.rmi.iiop.LocateRequestMessage;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.iiop.Work;
import com.ibm.rmi.iiop.WorkQueue;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;

final class CachedWorkerThread
extends Thread {
    private static WorkQueue workQueue = new WorkQueue();
    private static Work currentWork;

    public void run() {
        while (true) {
            currentWork = workQueue.getWorkToDo(this);
            this.doWork(currentWork.getRequestHandler(), currentWork.getConnection(), currentWork.getIIOPInputStream());
        }
    }

    static void addWorkToDo(RequestHandler requestHandler, IIOPConnection iIOPConnection, IIOPInputStream iIOPInputStream) {
        Work work = new Work(requestHandler, iIOPConnection, iIOPInputStream);
        workQueue.addWorkToDo(work);
    }

    void doWork(RequestHandler requestHandler, Connection connection, IIOPInputStream iIOPInputStream) {
        IIOPOutputStream iIOPOutputStream = null;
        Message message = iIOPInputStream.getMessage();
        connection.requestBegins();
        if (connection.isClosed()) {
            connection.requestEnds();
            return;
        }
        switch (message.getType()) {
            case 0: {
                ServerRequest serverRequest = (ServerRequest)((Object)iIOPInputStream);
                try {
                    iIOPOutputStream = (IIOPOutputStream)((Object)requestHandler.process(serverRequest));
                    if (!serverRequest.isOneWay()) break;
                    connection.requestEnds();
                    Thread.currentThread().stop();
                    break;
                }
                catch (SystemException systemException) {
                    try {
                        iIOPOutputStream = (IIOPOutputStream)((Object)serverRequest.createSystemExceptionResponse(systemException, null));
                        break;
                    }
                    catch (Exception exception) {
                        connection.requestEnds();
                        return;
                    }
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    UNKNOWN uNKNOWN = new UNKNOWN(4, CompletionStatus.COMPLETED_MAYBE);
                    try {
                        iIOPOutputStream = (IIOPOutputStream)((Object)serverRequest.createSystemExceptionResponse(uNKNOWN, null));
                        break;
                    }
                    catch (Exception exception) {
                        connection.requestEnds();
                        return;
                    }
                }
            }
            case 3: {
                LocateReplyMessage locateReplyMessage;
                LocateRequestMessage locateRequestMessage = (LocateRequestMessage)message;
                int n = message.getRequestId();
                IOR iOR = null;
                try {
                    iOR = requestHandler.locate(locateRequestMessage.getObjectKey());
                    locateReplyMessage = iOR == null ? new LocateReplyMessage(n, 1, message.getGIOPMajor(), message.getGIOPMinor()) : new LocateReplyMessage(n, 2, message.getGIOPMajor(), message.getGIOPMinor());
                }
                catch (Exception exception) {
                    locateReplyMessage = new LocateReplyMessage(n, 0, message.getGIOPMajor(), message.getGIOPMinor());
                }
                iIOPOutputStream = new IIOPOutputStream(iIOPInputStream.getConnection().getORB(), iIOPInputStream.getConnection());
                locateReplyMessage.write(iIOPOutputStream);
                iIOPOutputStream.setMessage(locateReplyMessage);
                if (iOR == null) break;
                iOR.write(iIOPOutputStream);
                break;
            }
            case 2: {
                connection.requestEnds();
                return;
            }
            default: {
                connection.requestEnds();
                return;
            }
        }
        try {
            connection.sendReply(iIOPOutputStream);
            connection.requestEnds();
        }
        catch (Exception exception) {
            connection.requestEnds();
            return;
        }
    }
}

