/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.org.omg.CORBA.ValueDefPackage.FullValueDescription;
import com.ibm.org.omg.SendingContext.CodeBase;
import com.ibm.org.omg.SendingContext.CodeBaseHelper;
import com.ibm.rmi.IOR;
import com.ibm.rmi.MarshalOutputStream;
import com.ibm.rmi.ServerGIOP;
import com.ibm.rmi.iiop.CDRConnection;
import com.ibm.rmi.iiop.CachedWorkerThread;
import com.ibm.rmi.iiop.ClientResponseImpl;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.ConnectionTable;
import com.ibm.rmi.iiop.DeleteConn;
import com.ibm.rmi.iiop.FVDCodeBaseDelegate;
import com.ibm.rmi.iiop.IIOPInputStream;
import com.ibm.rmi.iiop.IIOPOutputStream;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.OutCallDesc;
import com.ibm.rmi.iiop.ReaderThread;
import com.ibm.rmi.iiop.ReplyMessage;
import com.ibm.rmi.iiop.RequestMessage;
import com.ibm.rmi.iiop.ServerRequestImpl;
import com.ibm.rmi.util.Condition;
import com.ibm.rmi.util.Lock;
import com.ibm.rmi.util.PartnerVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public final class IIOPConnection
extends Connection
implements CDRConnection,
PartnerVersion {
    private static final int OPENING = 1;
    private static final int ESTABLISHED = 2;
    private static final int CLOSE_SENT = 3;
    private static final int CLOSE_RECVD = 4;
    private static final int ABORT = 5;
    private Hashtable out_calls = new Hashtable();
    protected String remote_host;
    protected int remote_port;
    private String threadName;
    protected int requestCount = 0;
    private ServerGIOP server;
    private byte GIOPMajor = 1;
    private byte GIOPMinor = 0;
    private boolean firstMessage = true;
    private Hashtable implementations = null;
    private Hashtable fvds = null;
    private Hashtable bases = null;
    private CodeBase codeBaseRef;
    private boolean postInitialRequestContexts = false;
    private boolean postInitialReplyContexts = false;
    private int tcsChar = 0;
    private int tcsWChar = 0;
    private IOR codeBaseServerIOR = null;
    private FVDCodeBaseDelegate cbDelegate;
    Thread reader;
    int state;
    private Condition event;
    private Lock lock;
    private boolean writeLocked;
    InputStream inputStream;
    OutputStream outputStream;
    private short partnerMajor;
    private short partnerMinor;
    private static Hashtable cbs = new Hashtable();

    public IIOPConnection(ORB oRB, ServerGIOP serverGIOP, ConnectionTable connectionTable, String string, int n) {
        this.orb = oRB;
        this.server = serverGIOP;
        this.connectionTable = connectionTable;
        this.threadName = "JavaIDL Reader for " + string + ":" + n;
        final ThreadGroup threadGroup = oRB.threadGroup;
        final String string2 = this.threadName;
        final IIOPConnection iIOPConnection = this;
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    IIOPConnection.this.reader = new ReaderThread(threadGroup, iIOPConnection, string2);
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    IIOPConnection.this.reader = new ReaderThread(iIOPConnection, string2);
                    return null;
                }
            });
        }
        this.remote_host = string;
        this.remote_port = n;
        this.state = 1;
        this.event = new Condition();
        this.lock = new Lock();
    }

    public IIOPConnection(ORB oRB, ServerGIOP serverGIOP, String string, int n, Socket socket, InputStream inputStream, OutputStream outputStream, ConnectionTable connectionTable) {
        this(oRB, serverGIOP, connectionTable, string, n);
        this.socket = socket;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.connectionTable = connectionTable;
        this.isServer = true;
        this.state = 2;
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    IIOPConnection.this.reader.setDaemon(true);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.reader.start();
    }

    public synchronized void setPartnerVersion(short s, short s2) {
        this.partnerMajor = s;
        this.partnerMinor = s2;
    }

    public synchronized short getPartnerMajor() {
        return this.partnerMajor;
    }

    public synchronized short getPartnerMinor() {
        return this.partnerMinor;
    }

    public synchronized boolean isPostInitialRequestContexts() {
        return this.postInitialRequestContexts;
    }

    public synchronized boolean isPostInitialReplyContexts() {
        return this.postInitialReplyContexts;
    }

    public synchronized void setPostInitialRequestContexts() {
        this.postInitialRequestContexts = true;
    }

    public synchronized void setPostInitialReplyContexts() {
        this.postInitialReplyContexts = true;
    }

    public synchronized void setCodeBaseRef(IOR iOR) {
        this.codeBaseServerIOR = iOR;
    }

    public synchronized IOR getCodeBaseRef() {
        return this.codeBaseServerIOR;
    }

    public synchronized void setCodeSets(int n, int n2) {
        this.tcsChar = n;
        this.tcsWChar = n2;
    }

    public synchronized int getCharCodeSet() {
        return this.tcsChar;
    }

    public synchronized int getWCharCodeSet() {
        return this.tcsWChar;
    }

    public CodeBase getFVDCodeBase() {
        if (this.cbDelegate == null) {
            this.cbDelegate = new FVDCodeBaseDelegate(this);
        }
        return this.cbDelegate;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public ServerGIOP getServerGIOP() {
        return this.server;
    }

    String getHost() {
        return this.remote_host;
    }

    int getPort() {
        return this.remote_port;
    }

    public IIOPInputStream createInputStream() throws Exception {
        byte[] byArray = new byte[1024];
        Message message = Message.createFromStream(byArray, this.inputStream);
        if (this.firstMessage) {
            this.GIOPMajor = message.getGIOPMajor();
            this.GIOPMinor = message.getGIOPMinor();
            this.firstMessage = false;
        }
        switch (message.getType()) {
            case 0: {
                return new ServerRequestImpl((Connection)this, byArray, (RequestMessage)message);
            }
            case 1: {
                return new ClientResponseImpl((Connection)this, byArray, (ReplyMessage)message);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new IIOPInputStream(this, byArray, message);
            }
        }
        throw new INTERNAL(11, CompletionStatus.COMPLETED_NO);
    }

    void processInput(IIOPInputStream iIOPInputStream) throws DeleteConn {
        int n = iIOPInputStream.getMessage().getType();
        switch (n) {
            case 0: 
            case 3: {
                if (this.debug) {
                    this.dprint("Connection:processInput: got incoming request");
                }
                CachedWorkerThread.addWorkToDo(this.server.getRequestHandler(), this, iIOPInputStream);
                break;
            }
            case 1: 
            case 4: {
                if (this.debug) {
                    this.dprint("Connection:processInput: got RESPONSE");
                }
                Integer n2 = new Integer(iIOPInputStream.getMessage().getRequestId());
                OutCallDesc outCallDesc = (OutCallDesc)this.out_calls.get(n2);
                this.out_calls.remove(n2);
                this.lock.lock();
                outCallDesc.s = iIOPInputStream;
                outCallDesc.done.signal();
                this.lock.unlock();
                break;
            }
            case 2: {
                if (!this.debug) break;
                this.dprint("Connection:processInput: got cancel");
                break;
            }
            case 5: {
                if (this.debug) {
                    this.dprint("Connection.processInput: got CloseConn, purging");
                }
                this.purge_calls(2, true, false);
                break;
            }
            default: {
                if (this.debug) {
                    this.dprint("Connection: bad message type " + String.valueOf(n));
                }
                this.purge_calls(1, true, false);
            }
        }
    }

    void purge_calls(int n, boolean bl, boolean bl2) {
        CompletionStatus completionStatus;
        block12: {
            if (this.debug) {
                this.dprint("purge_calls: starting: code = " + n + " die = " + bl);
            }
            if (this.state == 5 || this.state == 4) {
                if (this.debug) {
                    this.dprint("purge_calls: exiting duplicate invocation");
                }
                return;
            }
            try {
                if (!bl2) {
                    this.writeLock();
                }
            }
            catch (SystemException systemException) {
                if (!this.debug) break block12;
                this.dprint("purge_calls: caught exception " + systemException + "; continuing");
            }
        }
        this.lock.lock();
        if (n == 2) {
            this.state = 4;
            completionStatus = CompletionStatus.COMPLETED_NO;
        } else {
            this.state = 5;
            completionStatus = CompletionStatus.COMPLETED_MAYBE;
        }
        this.lock.unlock();
        try {
            this.inputStream.close();
            this.outputStream.close();
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        COMM_FAILURE cOMM_FAILURE = new COMM_FAILURE(n, completionStatus);
        Enumeration enumeration = this.out_calls.elements();
        while (enumeration.hasMoreElements()) {
            OutCallDesc outCallDesc = (OutCallDesc)enumeration.nextElement();
            this.lock.lock();
            outCallDesc.exc = cOMM_FAILURE;
            outCallDesc.done.signal();
            this.lock.unlock();
        }
        this.out_calls.clear();
        this.connectionTable.deleteConn(this.remote_host, this.remote_port);
        this.writeUnlock();
        if (bl) {
            Thread.currentThread().stop();
        }
    }

    public void setConnection(Socket socket, ConnectionTable connectionTable) throws Exception {
        this.socket = socket;
        this.inputStream = this.socket.getInputStream();
        this.outputStream = this.socket.getOutputStream();
        this.connectionTable = connectionTable;
        this.lock.lock();
        this.state = 2;
        this.event.signalAll();
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    IIOPConnection.this.reader.setDaemon(true);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.reader.start();
        this.lock.unlock();
    }

    public void abortConnection() {
        this.lock.lock();
        this.state = 5;
        this.event.signalAll();
        this.connectionTable.deleteConn(this.remote_host, this.remote_port);
        this.lock.unlock();
    }

    private boolean writeLock() {
        this.lock.lock();
        block5: while (true) {
            switch (this.state) {
                case 1: {
                    this.event.wait(this.lock);
                    continue block5;
                }
                case 2: {
                    if (!this.writeLocked) {
                        this.writeLocked = true;
                        this.lock.unlock();
                        return true;
                    }
                    this.event.wait(this.lock);
                    continue block5;
                }
                case 4: 
                case 5: {
                    this.lock.unlock();
                    throw new COMM_FAILURE(2, CompletionStatus.COMPLETED_NO);
                }
            }
            break;
        }
        if (this.debug) {
            this.dprint("Connection:writeLock: weird state");
        }
        this.lock.unlock();
        this.delete(1);
        return false;
    }

    private void writeUnlock() {
        this.lock.lock();
        this.writeLocked = false;
        this.event.signalAll();
        this.lock.unlock();
    }

    public void delete() {
        this.delete(1);
    }

    void delete(int n) {
        DeleteConn deleteConn = new DeleteConn(n);
        this.reader.stop(deleteConn);
    }

    public IIOPInputStream invoke(IIOPOutputStream iIOPOutputStream) throws SystemException {
        return this.send(iIOPOutputStream, false);
    }

    public IIOPInputStream send(IIOPOutputStream iIOPOutputStream, boolean bl) {
        OutCallDesc outCallDesc;
        boolean bl2;
        block9: {
            bl2 = false;
            outCallDesc = new OutCallDesc();
            outCallDesc.thd = Thread.currentThread();
            int n = iIOPOutputStream.getMessage().getRequestId();
            try {
                this.writeLock();
                bl2 = true;
                this.out_calls.put(new Integer(n), outCallDesc);
                try {
                    iIOPOutputStream.writeTo(this.outputStream);
                    this.outputStream.flush();
                }
                catch (IOException iOException) {
                    throw new COMM_FAILURE(3, CompletionStatus.COMPLETED_NO);
                }
                this.writeUnlock();
                bl2 = false;
                if (bl) {
                    IIOPInputStream iIOPInputStream = null;
                    java.lang.Object var8_8 = null;
                    if (bl2) {
                        this.writeUnlock();
                    }
                    return iIOPInputStream;
                }
                this.lock.lock();
                while (outCallDesc.s == null && outCallDesc.exc == null) {
                    outCallDesc.done.wait(this.lock);
                }
                this.lock.unlock();
                if (outCallDesc.exc == null) break block9;
                throw outCallDesc.exc;
            }
            catch (Throwable throwable) {
                java.lang.Object var8_10 = null;
                if (bl2) {
                    this.writeUnlock();
                }
                throw throwable;
            }
        }
        java.lang.Object var8_9 = null;
        if (bl2) {
            this.writeUnlock();
        }
        return outCallDesc.s;
    }

    public void sendReply(MarshalOutputStream marshalOutputStream) throws Exception {
        block2: {
            boolean bl = false;
            try {
                this.writeLock();
                bl = true;
                marshalOutputStream.writeTo(this.outputStream);
                this.outputStream.flush();
                this.writeUnlock();
                bl = false;
            }
            catch (Exception exception) {
                if (!bl) break block2;
                this.writeUnlock();
            }
        }
    }

    private static CodeBase getCodeBase(ORB oRB, IOR iOR) {
        CodeBase codeBase = (CodeBase)cbs.get(iOR);
        if (codeBase != null) {
            return codeBase;
        }
        if (iOR == null) {
            throw new MARSHAL("No sending context");
        }
        Object object = oRB.string_to_object(iOR.stringify());
        codeBase = CodeBaseHelper.narrow(object);
        cbs.put(iOR, codeBase);
        return codeBase;
    }

    public String getImplementation(String string) {
        String string2 = null;
        if (this.implementations == null) {
            this.implementations = new Hashtable();
        } else {
            string2 = (String)this.implementations.get(string);
        }
        if (string2 == null) {
            if (this.codeBaseRef == null) {
                this.codeBaseRef = IIOPConnection.getCodeBase(this.orb, this.codeBaseServerIOR);
            }
            if ((string2 = this.codeBaseRef.implementation(string)) != null) {
                this.implementations.put(string, string2);
            }
        }
        return string2;
    }

    public FullValueDescription getFVD(String string) {
        FullValueDescription fullValueDescription = null;
        if (this.fvds == null) {
            this.fvds = new Hashtable();
        } else {
            fullValueDescription = (FullValueDescription)this.fvds.get(string);
        }
        if (fullValueDescription == null) {
            if (this.codeBaseRef == null) {
                this.codeBaseRef = IIOPConnection.getCodeBase(this.orb, this.codeBaseServerIOR);
            }
            if ((fullValueDescription = this.codeBaseRef.meta(string)) != null) {
                this.fvds.put(string, fullValueDescription);
            }
        }
        return fullValueDescription;
    }

    public String[] getBases(String string) {
        String[] stringArray = null;
        if (this.bases == null) {
            this.bases = new Hashtable();
        } else {
            stringArray = (String[])this.bases.get(string);
        }
        if (stringArray == null) {
            if (this.codeBaseRef == null) {
                this.codeBaseRef = IIOPConnection.getCodeBase(this.orb, this.codeBaseServerIOR);
            }
            if ((stringArray = this.codeBaseRef.bases(string)) != null) {
                this.bases.put(string, stringArray);
            }
        }
        return stringArray;
    }

    private void sendCloseConnection() {
        Message message = new Message(this.GIOPMajor, this.GIOPMinor);
        message.setType(5);
        IIOPOutputStream iIOPOutputStream = this.orb.newOutputStream(this);
        message.write(iIOPOutputStream);
        iIOPOutputStream.setMessage(message);
        try {
            iIOPOutputStream.writeTo(this.outputStream);
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isBusy() {
        return this.requestCount > 0 || this.out_calls.size() > 0;
    }

    public synchronized void cleanUp() throws Exception {
        this.writeLock();
        if (this.requestCount > 0 || this.out_calls.size() > 0) {
            this.writeUnlock();
            throw new Exception();
        }
        try {
            if (this.isServer) {
                this.sendCloseConnection();
                this.lock.lock();
                this.state = 3;
                this.lock.unlock();
            }
            Exception exception = new Exception();
            this.reader.stop(exception);
            this.purge_calls(2, false, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void requestBegins() {
        ++this.requestCount;
    }

    public synchronized void requestEnds() {
        --this.requestCount;
    }

    public boolean isClosed() {
        boolean bl;
        try {
            this.writeLock();
            this.writeUnlock();
            bl = false;
        }
        catch (Exception exception) {
            bl = true;
        }
        return bl;
    }

    public void print() {
        System.out.println("Connection for " + this.remote_host + " @ " + this.remote_port);
        System.out.println("    Time stamp = " + this.timeStamp);
        boolean bl = this.reader.isAlive();
        if (bl) {
            System.out.println(" Reader is Alive");
        } else {
            System.out.println(" Reader is not Alive");
        }
    }
}

