/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.rmi.IOR;
import com.ibm.rmi.ServiceContext;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.iiop.IIOPInputStream;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.util.Utility;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class ReplyMessage
extends Message {
    protected ServiceContext[] ctx;
    protected int status;
    protected String exceptionId;
    protected String exClassName;
    protected int minorCode;
    protected CompletionStatus completionStatus;
    protected IOR ior;
    public static final int NO_EXCEPTION = 0;
    public static final int USER_EXCEPTION = 1;
    public static final int SYSTEM_EXCEPTION = 2;
    public static final int LOCATION_FORWARD = 3;

    public ReplyMessage(byte by, byte by2) {
        super(by, by2);
    }

    public ReplyMessage(ServiceContext[] serviceContextArray, int n, int n2, byte by, byte by2) {
        super(by, by2);
        this.setType(1);
        this.ctx = serviceContextArray;
        this.requestId = n;
        this.status = n2;
    }

    public ServiceContext[] getServiceContextList() {
        return this.ctx;
    }

    public int getReplyStatus() {
        return this.status;
    }

    public String getExceptionId() {
        return this.exceptionId;
    }

    public int getMinorCode() {
        return this.minorCode;
    }

    public IOR getIOR() {
        return this.ior;
    }

    public SystemException getSystemException() {
        SystemException systemException;
        try {
            systemException = (SystemException)Class.forName(this.exClassName).newInstance();
        }
        catch (Exception exception) {
            throw new INTERNAL("BAD SystemException: " + this.exClassName, 0, CompletionStatus.COMPLETED_MAYBE);
        }
        systemException.minor = this.minorCode;
        systemException.completed = this.completionStatus;
        return systemException;
    }

    public void write(OutputStream outputStream) throws SystemException {
        super.write(outputStream);
        if (this.ctx != null) {
            outputStream.write_long(this.ctx.length);
            int n = 0;
            while (n < this.ctx.length) {
                this.ctx[n].write(outputStream);
                ++n;
            }
        } else {
            outputStream.write_long(0);
        }
        outputStream.write_long(this.requestId);
        outputStream.write_long(this.status);
    }

    public void read(InputStream inputStream) throws SystemException {
        block10: {
            block9: {
                this.ctx = new ServiceContext[inputStream.read_long()];
                int n = 0;
                while (n < this.ctx.length) {
                    this.ctx[n] = new ServiceContext();
                    this.ctx[n].read(inputStream);
                    ++n;
                }
                this.requestId = inputStream.read_long();
                this.status = inputStream.read_long();
                if (this.status != 2) break block9;
                String string = inputStream.read_string();
                this.exClassName = Utility.classNameOf(string);
                this.minorCode = inputStream.read_long();
                int n2 = inputStream.read_long();
                switch (n2) {
                    case 0: {
                        this.completionStatus = CompletionStatus.COMPLETED_YES;
                        break block10;
                    }
                    case 1: {
                        this.completionStatus = CompletionStatus.COMPLETED_NO;
                        break block10;
                    }
                    case 2: {
                        this.completionStatus = CompletionStatus.COMPLETED_MAYBE;
                        break block10;
                    }
                    default: {
                        throw new INTERNAL("BAD completion status: " + n2, 0, CompletionStatus.COMPLETED_MAYBE);
                    }
                }
            }
            if (this.status == 1) {
                IIOPInputStream iIOPInputStream = (IIOPInputStream)inputStream;
                this.exceptionId = iIOPInputStream.peek_string();
            } else if (this.status == 3) {
                CDRInputStream cDRInputStream = (CDRInputStream)inputStream;
                this.ior = new IOR(cDRInputStream.orb);
                this.ior.read(inputStream);
            }
        }
    }
}

