/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.rmi.ServiceContext;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.iiop.CDROutputStream;
import com.ibm.rmi.iiop.Message;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class RequestMessage
extends Message {
    protected ServiceContext[] ctx;
    protected boolean responseExpected;
    protected byte[] objectKey;
    protected String operation;
    protected Principal principal;
    private static final int JAVAIDL_ALIGN_SERVICE_ID = -1106033203;

    public RequestMessage(byte by, byte by2) {
        super(by, by2);
    }

    public RequestMessage(ServiceContext[] serviceContextArray, int n, boolean bl, byte[] byArray, String string, Principal principal, byte by, byte by2) {
        super(by, by2);
        this.setType(0);
        this.ctx = serviceContextArray;
        this.requestId = n;
        this.responseExpected = bl;
        this.objectKey = byArray;
        this.operation = string;
        this.principal = principal;
    }

    public byte[] getObjectKey() {
        return this.objectKey;
    }

    public ServiceContext[] getServiceContextList() {
        return this.ctx;
    }

    public String getOperation() {
        return this.operation;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public boolean isResponseExpected() {
        return this.responseExpected;
    }

    public void write(OutputStream outputStream) throws SystemException {
        CDROutputStream cDROutputStream = (CDROutputStream)outputStream;
        int n = cDROutputStream.tcsChar;
        cDROutputStream.tcsChar = 0;
        super.write(outputStream);
        if (this.ctx != null) {
            outputStream.write_long(this.ctx.length);
            int n2 = 0;
            while (n2 < this.ctx.length) {
                this.ctx[n2].write(outputStream);
                ++n2;
            }
        } else {
            outputStream.write_long(0);
        }
        outputStream.write_long(this.requestId);
        outputStream.write_boolean(this.responseExpected);
        outputStream.write_long(this.objectKey.length);
        outputStream.write_octet_array(this.objectKey, 0, this.objectKey.length);
        outputStream.write_string(this.operation);
        if (this.principal != null) {
            outputStream.write_Principal(this.principal);
        } else {
            outputStream.write_long(0);
        }
        cDROutputStream.tcsChar = n;
    }

    public void read(InputStream inputStream) throws SystemException {
        CDRInputStream cDRInputStream = (CDRInputStream)inputStream;
        int n = cDRInputStream.tcsChar;
        cDRInputStream.tcsChar = 0;
        this.ctx = new ServiceContext[inputStream.read_long()];
        int n2 = 0;
        while (n2 < this.ctx.length) {
            this.ctx[n2] = new ServiceContext();
            this.ctx[n2].read(inputStream);
            ++n2;
        }
        this.requestId = inputStream.read_long();
        this.responseExpected = inputStream.read_boolean();
        int n3 = inputStream.read_long();
        this.objectKey = new byte[n3];
        inputStream.read_octet_array(this.objectKey, 0, n3);
        this.operation = inputStream.read_string();
        this.principal = inputStream.read_Principal();
        cDRInputStream.tcsChar = n;
    }

    public void realignAndWrite(OutputStream outputStream, CDROutputStream cDROutputStream, byte[] byArray, ServiceContext[] serviceContextArray, int n) {
        if (byArray.length == this.objectKey.length && serviceContextArray == this.ctx) {
            this.objectKey = byArray;
            this.write(outputStream);
        } else {
            this.objectKey = byArray;
            this.ctx = serviceContextArray;
            if (n != 0) {
                int n2;
                this.write(cDROutputStream);
                int n3 = n2 = cDROutputStream.getSize() % 8 == 0 ? 8 : 4;
                if (n2 != n) {
                    Object[] objectArray;
                    if (this.ctx == null) {
                        this.ctx = new ServiceContext[1];
                    } else {
                        objectArray = new ServiceContext[this.ctx.length + 1];
                        int n4 = 0;
                        while (n4 < this.ctx.length) {
                            objectArray[n4] = this.ctx[n4];
                            ++n4;
                        }
                        this.ctx = objectArray;
                    }
                    objectArray = new byte[4];
                    this.ctx[this.ctx.length - 1] = new ServiceContext(-1106033203, (byte[])objectArray);
                }
            }
            this.write(outputStream);
        }
    }
}

