/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.rmi.IOR;
import com.ibm.rmi.RequestHandler;
import com.ibm.rmi.ServerRequest;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.IIOPInputStream;
import com.ibm.rmi.iiop.IIOPOutputStream;
import com.ibm.rmi.iiop.LocateReplyMessage;
import com.ibm.rmi.iiop.LocateRequestMessage;
import com.ibm.rmi.iiop.Message;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;

public class WorkerThread
extends Thread {
    private Connection conn = null;
    private IIOPInputStream request = null;
    private IIOPOutputStream response = null;
    private int msgType;
    private RequestHandler handler;

    public WorkerThread(RequestHandler requestHandler, Connection connection, IIOPInputStream iIOPInputStream) {
        this.conn = connection;
        this.request = iIOPInputStream;
        this.handler = requestHandler;
    }

    public void run() {
        Message message = this.request.getMessage();
        this.conn.requestBegins();
        switch (message.getType()) {
            case 0: {
                ServerRequest serverRequest = (ServerRequest)((Object)this.request);
                try {
                    this.response = (IIOPOutputStream)((Object)this.handler.process(serverRequest));
                    if (!serverRequest.isOneWay()) break;
                    this.conn.requestEnds();
                    Thread.currentThread().stop();
                    break;
                }
                catch (SystemException systemException) {
                    try {
                        this.response = (IIOPOutputStream)((Object)serverRequest.createSystemExceptionResponse(systemException, null));
                        break;
                    }
                    catch (Exception exception) {
                        this.conn.requestEnds();
                        return;
                    }
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    UNKNOWN uNKNOWN = new UNKNOWN(4, CompletionStatus.COMPLETED_MAYBE);
                    try {
                        this.response = (IIOPOutputStream)((Object)serverRequest.createSystemExceptionResponse(uNKNOWN, null));
                        break;
                    }
                    catch (Exception exception) {
                        this.conn.requestEnds();
                        return;
                    }
                }
            }
            case 3: {
                LocateReplyMessage locateReplyMessage;
                LocateRequestMessage locateRequestMessage = (LocateRequestMessage)message;
                int n = message.getRequestId();
                IOR iOR = null;
                try {
                    iOR = this.handler.locate(locateRequestMessage.getObjectKey());
                    locateReplyMessage = iOR == null ? new LocateReplyMessage(n, 1, message.getGIOPMajor(), message.getGIOPMinor()) : new LocateReplyMessage(n, 2, message.getGIOPMajor(), message.getGIOPMinor());
                }
                catch (Exception exception) {
                    locateReplyMessage = new LocateReplyMessage(n, 0, message.getGIOPMajor(), message.getGIOPMinor());
                }
                this.response = new IIOPOutputStream(this.request.getConnection().getORB(), this.request.getConnection());
                locateReplyMessage.write(this.response);
                this.response.setMessage(locateReplyMessage);
                if (iOR == null) break;
                iOR.write(this.response);
                break;
            }
            case 2: {
                this.conn.requestEnds();
                return;
            }
            default: {
                this.conn.requestEnds();
                return;
            }
        }
        try {
            this.conn.sendReply(this.response);
            this.conn.requestEnds();
        }
        catch (Exception exception) {
            this.conn.requestEnds();
            return;
        }
    }
}

