/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class LibraryManager {
    private static boolean attempted = false;
    private static int majorVersion = 1;
    private static int minorVersion = 10;

    private static native int getMajorVersion();

    private static native int getMinorVersion();

    public static boolean load() {
        try {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        System.loadLibrary("orb");
                        return null;
                    }
                });
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (!attempted) {
                    System.out.println("ERROR! Shared library orb could not be found.");
                }
                throw unsatisfiedLinkError;
            }
            if (!(attempted || LibraryManager.getMajorVersion() == majorVersion && LibraryManager.getMinorVersion() == minorVersion)) {
                System.out.println("WARNING : The orb library is not the correct version.");
                System.out.println("          Expected v" + majorVersion + "." + minorVersion + " but loaded v" + LibraryManager.getMajorVersion() + "." + LibraryManager.getMinorVersion() + "\n");
                System.out.println("          *** YOU ARE ADVISED TO USE EXPECTED VERSION ***");
            }
            attempted = true;
            return true;
        }
        catch (Error error) {
            attempted = true;
            return false;
        }
    }

    protected static void enableOverride(String string, Object object) {
        try {
            LibraryManager.setEnableOverride(Class.forName(string), object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    private static native boolean setEnableOverride(Class var0, Object var1);
}

