/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.javax.rmi.CORBA;

import com.ibm.rmi.util.Utility;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.StubDelegate;
import javax.rmi.CORBA.Tie;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA_2_3.portable.ObjectImpl;

public class StubDelegateImpl
implements StubDelegate {
    private transient int hashCode = 0;
    private transient int typeLength;
    private transient byte[] typeData;
    private transient int numProfiles = 0;
    private transient int[] profileTags;
    private transient byte[][] profileData;

    private void init(Stub stub) {
        if (this.numProfiles == 0) {
            try {
                OutputStream outputStream = stub._orb().create_output_stream();
                outputStream.write_Object(stub);
                InputStream inputStream = outputStream.create_input_stream();
                this.typeLength = inputStream.read_long();
                this.typeData = new byte[this.typeLength];
                inputStream.read_octet_array(this.typeData, 0, this.typeLength);
                this.numProfiles = inputStream.read_long();
                this.profileTags = new int[this.numProfiles];
                this.profileData = new byte[this.numProfiles][];
                int n = 0;
                while (n < this.numProfiles) {
                    this.profileTags[n] = inputStream.read_long();
                    this.profileData[n] = new byte[inputStream.read_long()];
                    inputStream.read_octet_array(this.profileData[n], 0, this.profileData[n].length);
                    ++n;
                }
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                // empty catch block
            }
        }
    }

    public int hashCode(Stub stub) {
        this.init(stub);
        if (this.hashCode == 0) {
            int n = 0;
            while (n < this.typeLength) {
                this.hashCode = this.hashCode * 37 + this.typeData[n];
                ++n;
            }
            int n2 = 0;
            while (n2 < this.numProfiles) {
                this.hashCode = this.hashCode * 37 + this.profileTags[n2];
                int n3 = 0;
                while (n3 < this.profileData[n2].length) {
                    this.hashCode = this.hashCode * 37 + this.profileData[n2][n3];
                    ++n3;
                }
                ++n2;
            }
        }
        return this.hashCode;
    }

    public boolean equals(Stub stub, Object object) {
        if (object == null) {
            return false;
        }
        this.init(stub);
        if (object instanceof StubDelegateImpl) {
            StubDelegateImpl stubDelegateImpl = (StubDelegateImpl)object;
            if (stubDelegateImpl.hashCode != this.hashCode) {
                return false;
            }
            if (stubDelegateImpl.typeLength != this.typeLength) {
                return false;
            }
            int n = 0;
            while (n < this.typeLength) {
                if (this.typeData[n] != stubDelegateImpl.typeData[n]) {
                    return false;
                }
                ++n;
            }
            if (stubDelegateImpl.numProfiles != this.numProfiles) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.numProfiles) {
                if (stubDelegateImpl.profileTags[n2] != this.profileTags[n2]) {
                    return false;
                }
                if (stubDelegateImpl.profileData[n2].length != this.profileData[n2].length) {
                    return false;
                }
                int n3 = 0;
                while (n3 < this.profileData[n2].length) {
                    if (stubDelegateImpl.profileData[n2][n3] != this.profileData[n2][n3]) {
                        return false;
                    }
                    ++n3;
                }
                ++n2;
            }
            return true;
        }
        return object.equals(this);
    }

    public String toString(Stub stub) {
        try {
            return stub._orb().object_to_string(stub);
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            return null;
        }
    }

    public void connect(Stub stub, ORB oRB) throws RemoteException {
        boolean bl = false;
        try {
            Delegate delegate = stub._get_delegate();
            if (delegate.orb(stub) != oRB) {
                bl = true;
            }
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            if (this.numProfiles == 0) {
                Tie tie = Utility.getAndForgetTie(stub);
                if (tie == null) {
                    bl = true;
                }
                try {
                    ORB oRB2 = tie.orb();
                    if (oRB2 != oRB) {
                        bl = true;
                    }
                }
                catch (BAD_OPERATION bAD_OPERATION2) {
                    tie.orb(oRB);
                    stub._set_delegate(((ObjectImpl)((Object)tie))._get_delegate());
                }
            }
            try {
                OutputStream outputStream = oRB.create_output_stream();
                outputStream.write_long(this.typeLength);
                outputStream.write_octet_array(this.typeData, 0, this.typeLength);
                outputStream.write_long(this.numProfiles);
                int n = 0;
                while (n < this.numProfiles) {
                    outputStream.write_long(this.profileTags[n]);
                    outputStream.write_long(this.profileData[n].length);
                    outputStream.write_octet_array(this.profileData[n], 0, this.profileData[n].length);
                    ++n;
                }
                ObjectImpl objectImpl = (ObjectImpl)outputStream.create_input_stream().read_Object();
                stub._set_delegate(objectImpl._get_delegate());
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        if (bl) {
            throw new RemoteException("CORBA BAD_OPERATION 0");
        }
    }

    public void readObject(Stub stub, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.typeLength = objectInputStream.readInt();
        this.typeData = new byte[this.typeLength];
        objectInputStream.readFully(this.typeData);
        this.numProfiles = objectInputStream.readInt();
        this.profileTags = new int[this.numProfiles];
        this.profileData = new byte[this.numProfiles][];
        int n = 0;
        while (n < this.numProfiles) {
            this.profileTags[n] = objectInputStream.readInt();
            this.profileData[n] = new byte[objectInputStream.readInt()];
            objectInputStream.readFully(this.profileData[n]);
            ++n;
        }
    }

    public void writeObject(Stub stub, ObjectOutputStream objectOutputStream) throws IOException {
        this.init(stub);
        objectOutputStream.writeInt(this.typeLength);
        objectOutputStream.write(this.typeData);
        objectOutputStream.writeInt(this.numProfiles);
        int n = 0;
        while (n < this.numProfiles) {
            objectOutputStream.writeInt(this.profileTags[n]);
            objectOutputStream.writeInt(this.profileData[n].length);
            objectOutputStream.write(this.profileData[n]);
            ++n;
        }
    }
}

