/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.plaf.mac.MacInternalFrameTitlePane;
import com.sun.java.swing.plaf.mac.MacLookAndFeel;
import com.sun.java.swing.plaf.mac.MacScrollBarUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class MacBorders {

    static class ScrollBarBorder
    implements Border,
    UIResource {
        ScrollBarBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JScrollBar jScrollBar = (JScrollBar)component;
            MacScrollBarUI macScrollBarUI = (MacScrollBarUI)jScrollBar.getUI();
            graphics.setColor(MacLookAndFeel.getBlack());
            graphics.translate(n, n2);
            if (macScrollBarUI.isFreeStanding) {
                graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            } else if (jScrollBar.getOrientation() == 1) {
                graphics.drawLine(0, 0, n3 - 1, 0);
                graphics.drawLine(0, 0, 0, n4 - 1);
                graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            } else {
                graphics.drawLine(0, 0, 0, n4 - 1);
                graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
                graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
            }
            graphics.translate(-n, -n2);
        }

        public Insets getBorderInsets(Component component) {
            JScrollBar jScrollBar = (JScrollBar)component;
            MacScrollBarUI macScrollBarUI = (MacScrollBarUI)jScrollBar.getUI();
            if (macScrollBarUI.isFreeStanding) {
                return new Insets(1, 1, 1, 1);
            }
            if (jScrollBar.getOrientation() == 1) {
                return new Insets(1, 1, 1, 0);
            }
            return new Insets(1, 1, 0, 1);
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    static class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        static Insets borderInsets = new Insets(1, 1, 2, 2);

        PopupMenuBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(MacLookAndFeel.getBlack());
            graphics.drawRect(0, 0, n3 - 2, n4 - 2);
            graphics.setColor(MacLookAndFeel.getGray10());
            graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
            graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            graphics.translate(-n, -n2);
        }

        public Insets getBorderInsets(Component component) {
            return borderInsets;
        }
    }

    static class MenuItemBorder
    extends AbstractBorder
    implements UIResource {
        static Insets borderInsets = new Insets(2, 2, 2, 2);

        MenuItemBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ColorUIResource colorUIResource;
            ColorUIResource colorUIResource2;
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            graphics.translate(n, n2);
            if (buttonModel.isArmed() || buttonModel.isSelected()) {
                colorUIResource2 = MacLookAndFeel.getAccentHighlight();
                colorUIResource = MacLookAndFeel.getBlack();
            } else {
                colorUIResource2 = MacLookAndFeel.getWhite();
                colorUIResource = MacLookAndFeel.getGray6();
            }
            Container container = component.getParent();
            if (container instanceof JMenuBar) {
                graphics.setColor(colorUIResource2);
                graphics.drawLine(0, 0, n3 - 1, 0);
                graphics.setColor(colorUIResource);
                graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            } else {
                boolean bl = false;
                if (container instanceof JPopupMenu) {
                    bl = ((JPopupMenu)container).getComponentIndex(component) == 0;
                }
                graphics.setColor(colorUIResource2);
                graphics.drawLine(0, 0, 0, n4 - 1);
                if (bl) {
                    graphics.drawLine(0, 0, n3 - 1, 0);
                }
                graphics.setColor(colorUIResource);
                graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
            }
            graphics.translate(-n, -n2);
        }

        public Insets getBorderInsets(Component component) {
            return borderInsets;
        }
    }

    static class MenuBarBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(0, 0, 1, 0);

        MenuBarBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(MacLookAndFeel.getWhite());
            graphics.drawLine(0, 0, n3 - 1, 0);
            graphics.setColor(MacLookAndFeel.getGray4());
            graphics.drawLine(0, n4 - 2, n3 - 1, n4 - 2);
            graphics.setColor(MacLookAndFeel.getBlack());
            graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            graphics.translate(-n, -n2);
        }

        public Insets getBorderInsets(Component component) {
            return borderInsets;
        }
    }

    static class InternalFrameBorder
    implements Border {
        private static Insets insets = new Insets(2, 6, 7, 7);
        private static final int titleBarHeight = MacInternalFrameTitlePane.titleBarHeight;

        InternalFrameBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (component instanceof JInternalFrame && ((JInternalFrame)component).isSelected()) {
                graphics.setColor(MacLookAndFeel.getGray2());
                graphics.fillRect(0, 0, n3 - 2, n4 - 2);
                graphics.setColor(MacLookAndFeel.getBlack());
                this.drawOutline(component, graphics, n, n2, n3, n4);
                graphics.setColor(MacLookAndFeel.getWhite());
                graphics.drawLine(1, 1, 1, n4 - 4);
                graphics.drawLine(1, 1, n3 - 4, 1);
                graphics.drawLine(4, n4 - 6, n3 - 6, n4 - 6);
                graphics.drawLine(n3 - 6, n4 - 6, n3 - 6, titleBarHeight + 1);
                graphics.setColor(MacLookAndFeel.getGray4());
                graphics.drawLine(4, titleBarHeight + 1, 4, n4 - 7);
                graphics.drawLine(2, n4 - 3, n3 - 3, n4 - 3);
                graphics.drawLine(n3 - 3, n4 - 3, n3 - 3, 2);
            } else {
                graphics.setColor(MacLookAndFeel.getGray1());
                graphics.fillRect(0, 0, n3 - 2, n4 - 2);
                graphics.setColor(MacLookAndFeel.getGray8());
                this.drawOutline(component, graphics, n, n2, n3, n4);
            }
        }

        public void drawOutline(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.drawRect(0, 0, n3 - 2, n4 - 2);
            graphics.drawLine(n3 - 1, 2, n3 - 1, n4 - 1);
            graphics.drawLine(2, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(5, titleBarHeight + 1, 5, n4 - 7);
            graphics.drawLine(5, n4 - 7, n3 - 7, n4 - 7);
            graphics.drawLine(n3 - 7, n4 - 7, n3 - 7, titleBarHeight + 1);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }
    }

    static class WindowShadeBorder
    implements Border {
        private static Insets insets = new Insets(2, 6, 2, 7);
        private static final int titleBarHeight = MacInternalFrameTitlePane.titleBarHeight;

        WindowShadeBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (component instanceof JInternalFrame && ((JInternalFrame)component).isSelected()) {
                graphics.setColor(MacLookAndFeel.getGray2());
                graphics.fillRect(0, 0, n3 - 2, n4 - 2);
                graphics.setColor(MacLookAndFeel.getBlack());
                this.drawOutline(component, graphics, n, n2, n3, n4);
                graphics.setColor(MacLookAndFeel.getWhite());
                graphics.drawLine(1, 1, 1, n4 - 4);
                graphics.drawLine(1, 1, n3 - 4, 1);
                graphics.setColor(MacLookAndFeel.getGray4());
                graphics.drawLine(4, titleBarHeight + 1, 4, n4 - 7);
                graphics.drawLine(2, n4 - 3, n3 - 3, n4 - 3);
                graphics.drawLine(n3 - 3, n4 - 3, n3 - 3, 2);
            } else {
                graphics.setColor(MacLookAndFeel.getGray1());
                graphics.fillRect(0, 0, n3 - 2, n4 - 2);
                graphics.setColor(MacLookAndFeel.getGray8());
                this.drawOutline(component, graphics, n, n2, n3, n4);
            }
        }

        public void drawOutline(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.drawRect(0, 0, n3 - 2, n4 - 2);
            graphics.drawLine(n3 - 1, 2, n3 - 1, n4 - 1);
            graphics.drawLine(2, n4 - 1, n3 - 1, n4 - 1);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }
    }

    static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        RadioButtonIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isSelected()) {
                    if (buttonModel.isPressed() && buttonModel.isArmed()) {
                        UIManager.getIcon("RadioButton.pressedOn").paintIcon(component, graphics, n, n2);
                        return;
                    }
                    UIManager.getIcon("RadioButton.on").paintIcon(component, graphics, n, n2);
                    return;
                }
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    UIManager.getIcon("RadioButton.pressedOff").paintIcon(component, graphics, n, n2);
                    return;
                }
                UIManager.getIcon("RadioButton.off").paintIcon(component, graphics, n, n2);
                return;
            }
            if (buttonModel.isSelected()) {
                UIManager.getIcon("RadioButton.disabledOn").paintIcon(component, graphics, n, n2);
                return;
            }
            UIManager.getIcon("RadioButton.disabledOff").paintIcon(component, graphics, n, n2);
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }
    }

    static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        CheckBoxIcon() {
        }

        protected int getControlSize() {
            return 12;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            ColorUIResource colorUIResource;
            ColorUIResource colorUIResource2;
            ColorUIResource colorUIResource3;
            ColorUIResource colorUIResource4;
            ColorUIResource colorUIResource5;
            JCheckBox jCheckBox = (JCheckBox)component;
            ButtonModel buttonModel = jCheckBox.getModel();
            int n3 = this.getControlSize();
            boolean bl = buttonModel.isSelected();
            int n4 = this.getControlSize();
            if (buttonModel.isPressed() && buttonModel.isArmed()) {
                colorUIResource5 = MacLookAndFeel.getGray7();
                colorUIResource4 = MacLookAndFeel.getGray9();
                colorUIResource3 = MacLookAndFeel.getGray6();
                colorUIResource2 = MacLookAndFeel.getGray5();
                colorUIResource = MacLookAndFeel.getGray8();
            } else {
                colorUIResource5 = MacLookAndFeel.getGray1();
                colorUIResource4 = MacLookAndFeel.getWhite();
                colorUIResource3 = MacLookAndFeel.getGray6();
                colorUIResource2 = MacLookAndFeel.getGray4();
                colorUIResource = MacLookAndFeel.getGray4();
            }
            graphics.translate(n, n2);
            if (buttonModel.isEnabled()) {
                graphics.setColor(colorUIResource5);
                graphics.fillRect(0, 0, n4 - 1, n4 - 1);
                graphics.setColor(colorUIResource3);
                graphics.drawLine(2, n4 - 2, n4 - 2, n4 - 2);
                graphics.drawLine(n4 - 2, 2, n4 - 2, n4 - 2);
                graphics.setColor(colorUIResource4);
                graphics.drawLine(1, 2, 1, n4 - 2);
                graphics.drawLine(2, 1, n4 - 2, 1);
                if (bl) {
                    this.drawCheck(component, graphics, MacLookAndFeel.getBlack(), colorUIResource2, colorUIResource, n4);
                }
                graphics.setColor(MacLookAndFeel.getBlack());
                graphics.drawRect(0, 0, n4 - 1, n4 - 1);
            } else {
                if (bl) {
                    this.drawCheck(component, graphics, MacLookAndFeel.getGray6(), MacLookAndFeel.getGray1(), MacLookAndFeel.getGray1(), n4);
                }
                graphics.setColor(MacLookAndFeel.getGray6());
                graphics.drawRect(0, 0, n4 - 1, n4 - 1);
            }
            graphics.translate(-n, -n2);
        }

        protected void drawCheck(Component component, Graphics graphics, Color color, Color color2, Color color3, int n) {
            graphics.setColor(color);
            graphics.drawLine(5, n - 4, 2, n - 7);
            graphics.drawLine(5, n - 4, n, 1);
            graphics.drawLine(5, n - 5, 3, n - 7);
            graphics.drawLine(5, n - 5, n - 2, 2);
            graphics.setColor(color2);
            graphics.drawLine(4, n - 4, 3, n - 5);
            graphics.drawLine(6, n - 3, n + 1, 2);
            graphics.setColor(color3);
            graphics.drawLine(5, n - 3, n, 2);
        }

        public int getIconWidth() {
            return this.getControlSize() + 2;
        }

        public int getIconHeight() {
            return this.getControlSize();
        }
    }

    public static class TextFieldBorder
    implements Border {
        private static Insets insets = new Insets(4, 4, 4, 4);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            if (component.isEnabled()) {
                graphics.setColor(MacLookAndFeel.getBlack());
                graphics.drawRect(2, 2, n3 - 5, n4 - 5);
                if (((JComponent)component).hasFocus()) {
                    graphics.setColor(MacLookAndFeel.getFocusColor());
                    graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                    graphics.drawRect(1, 1, n3 - 3, n4 - 3);
                    graphics.setColor(MacLookAndFeel.getGray1());
                    graphics.drawLine(0, 0, 0, 0);
                    graphics.drawLine(0, n4 - 1, 0, n4 - 1);
                    graphics.drawLine(n3 - 1, 0, n3 - 1, 0);
                    graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, n4 - 1);
                } else {
                    graphics.setColor(MacLookAndFeel.getGray1());
                    graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                    graphics.drawRect(1, 1, n3 - 3, n4 - 3);
                    graphics.setColor(MacLookAndFeel.getGray6());
                    graphics.drawLine(1, 1, n3 - 3, 1);
                    graphics.drawLine(1, 1, 1, n4 - 3);
                    graphics.setColor(MacLookAndFeel.getWhite());
                    graphics.drawLine(n3 - 2, 2, n3 - 2, n4 - 2);
                    graphics.drawLine(2, n4 - 2, n3 - 2, n4 - 2);
                }
            }
            graphics.translate(-n, -n2);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }
    }

    static class ToggleButtonBorder
    implements Border {
        private static Insets insets = new Insets(3, 3, 3, 3);

        ToggleButtonBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ColorUIResource colorUIResource;
            ColorUIResource colorUIResource2;
            ColorUIResource colorUIResource3;
            ColorUIResource colorUIResource4;
            JToggleButton jToggleButton = (JToggleButton)component;
            ButtonModel buttonModel = jToggleButton.getModel();
            graphics.translate(n, n2);
            if (jToggleButton.isEnabled()) {
                colorUIResource4 = MacLookAndFeel.getBlack();
                if (jToggleButton.isSelected()) {
                    colorUIResource3 = MacLookAndFeel.getGray9();
                    colorUIResource2 = MacLookAndFeel.getGray4();
                    colorUIResource = MacLookAndFeel.getGray7();
                } else {
                    colorUIResource3 = MacLookAndFeel.getWhite();
                    colorUIResource2 = MacLookAndFeel.getGray5();
                    colorUIResource = MacLookAndFeel.getGray2();
                }
            } else if (buttonModel.isSelected()) {
                colorUIResource4 = MacLookAndFeel.getGray7();
                colorUIResource3 = MacLookAndFeel.getGray3();
                colorUIResource2 = MacLookAndFeel.getGray3();
                colorUIResource = MacLookAndFeel.getGray3();
            } else {
                colorUIResource4 = MacLookAndFeel.getGray4();
                colorUIResource3 = MacLookAndFeel.getGray1();
                colorUIResource2 = MacLookAndFeel.getGray1();
                colorUIResource = MacLookAndFeel.getGray1();
            }
            graphics.setColor(colorUIResource4);
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            graphics.setColor(colorUIResource3);
            graphics.drawRect(1, 1, n3 - 3, n4 - 3);
            graphics.drawRect(2, 2, n3 - 5, n4 - 5);
            graphics.setColor(colorUIResource2);
            graphics.drawLine(n3 - 2, 1, n3 - 2, n4 - 2);
            graphics.drawLine(n3 - 3, 1, n3 - 3, n4 - 2);
            graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
            graphics.drawLine(1, n4 - 3, n3 - 2, n4 - 3);
            graphics.setColor(colorUIResource);
            graphics.drawRect(n3 - 3, 1, 1, 1);
            graphics.drawRect(1, n4 - 3, 1, 1);
            graphics.translate(-n, -n2);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }
    }

    static class DefaultButtonBorder
    implements Border {
        private static Insets insets = new Insets(3, 3, 3, 3);
        private static Insets zeroInsets = new Insets(0, 0, 0, 0);

        DefaultButtonBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            if (jButton.isDefaultButton()) {
                graphics.translate(n, n2);
                graphics.setColor(MacLookAndFeel.getBlack());
                graphics.drawLine(3, 0, n3 - 4, 0);
                graphics.drawLine(3, n4 - 1, n3 - 4, n4 - 1);
                graphics.drawLine(0, 3, 0, n4 - 4);
                graphics.drawLine(n3 - 1, 3, n3 - 1, n4 - 4);
                graphics.drawLine(3, 0, 0, 3);
                graphics.drawLine(0, n4 - 4, 3, n4 - 1);
                graphics.drawLine(n3 - 4, 0, n3 - 1, 3);
                graphics.drawLine(n3 - 4, n4 - 1, n3 - 1, n4 - 4);
                graphics.setColor(MacLookAndFeel.getGray4());
                graphics.drawLine(4, 2, n3 - 4, 2);
                graphics.drawLine(3, n4 - 3, n3 - 5, n4 - 3);
                graphics.drawLine(2, 4, 2, n4 - 4);
                graphics.drawLine(n3 - 3, 3, n3 - 3, n4 - 5);
                graphics.drawLine(4, 2, 2, 4);
                graphics.drawLine(n3 - 5, n4 - 3, n3 - 3, n4 - 5);
                graphics.drawLine(3, n4 - 4, 3, n4 - 4);
                graphics.drawLine(n3 - 4, 3, n3 - 4, 3);
                graphics.setColor(MacLookAndFeel.getGray7());
                graphics.drawLine(3, 4, 4, 3);
                graphics.drawLine(3, n4 - 5, 4, n4 - 4);
                graphics.drawLine(n3 - 4, n4 - 5, n3 - 5, n4 - 4);
                graphics.drawLine(n3 - 4, 4, n3 - 5, 3);
                graphics.drawLine(4, n4 - 2, n3 - 4, n4 - 2);
                graphics.drawLine(n3 - 2, 4, n3 - 2, n4 - 4);
                graphics.drawLine(n3 - 3, n4 - 3, n3 - 3, n4 - 3);
                graphics.setColor(MacLookAndFeel.getGray6());
                graphics.drawLine(n3 - 4, n4 - 3, n3 - 3, n4 - 4);
                graphics.drawLine(3, n4 - 2, 3, n4 - 2);
                graphics.drawLine(n3 - 2, 3, n3 - 2, 3);
                graphics.setColor(MacLookAndFeel.getGray3());
                graphics.drawLine(1, n4 - 4, 2, n4 - 3);
                graphics.drawLine(n3 - 4, 1, n3 - 3, 2);
                graphics.translate(-n, -n2);
            }
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Insets getBorderInsets(Component component) {
            JButton jButton = (JButton)component;
            if (jButton.isDefaultCapable()) {
                return insets;
            }
            return zeroInsets;
        }
    }

    static class ButtonBorder
    implements Border {
        private static Insets insets = new Insets(3, 3, 3, 3);

        ButtonBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            graphics.translate(n, n2);
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    this.drawPressedBorder(component, graphics, n3, n4);
                } else {
                    this.drawActiveBorder(component, graphics, n3, n4);
                }
            } else {
                this.drawOutlineBorder(component, graphics, MacLookAndFeel.getGray6(), n3, n4);
            }
        }

        private void drawActiveBorder(Component component, Graphics graphics, int n, int n2) {
            this.drawOutlineBorder(component, graphics, MacLookAndFeel.getBlack(), n, n2);
            graphics.setColor(MacLookAndFeel.getGray3());
            graphics.drawLine(1, 2, 2, 1);
            graphics.drawLine(n - 2, 2, n - 3, 1);
            graphics.drawLine(1, n2 - 3, 2, n2 - 2);
            graphics.setColor(MacLookAndFeel.getWhite());
            graphics.drawLine(2, 2, 2, n2 - 4);
            graphics.drawLine(2, 2, n - 4, 2);
            graphics.drawLine(2, 2, 3, 3);
            graphics.setColor(MacLookAndFeel.getGray4());
            graphics.drawLine(3, n2 - 3, n - 4, n2 - 3);
            graphics.drawLine(n - 4, n2 - 4, n - 4, n2 - 4);
            graphics.drawLine(n - 3, n2 - 4, n - 3, 3);
            graphics.setColor(MacLookAndFeel.getGray7());
            graphics.drawLine(3, n2 - 2, n - 3, n2 - 2);
            graphics.drawLine(n - 3, n2 - 3, n - 3, n2 - 3);
            graphics.drawLine(n - 2, n2 - 3, n - 2, 3);
        }

        private void drawPressedBorder(Component component, Graphics graphics, int n, int n2) {
            this.drawOutlineBorder(component, graphics, MacLookAndFeel.getBlack(), n, n2);
            graphics.setColor(MacLookAndFeel.getGray10());
            graphics.drawLine(1, 2, 1, n2 - 3);
            graphics.drawLine(2, 2, 2, 2);
            graphics.drawLine(2, 1, n - 3, 1);
            graphics.setColor(MacLookAndFeel.getGray9());
            graphics.drawLine(2, 3, 2, n2 - 4);
            graphics.drawLine(3, 3, 3, 3);
            graphics.drawLine(2, 2, n - 4, 2);
            graphics.setColor(MacLookAndFeel.getGray7());
            graphics.drawLine(3, n2 - 3, n - 4, n2 - 3);
            graphics.drawLine(n - 3, 3, n - 3, n2 - 4);
            graphics.drawLine(n - 4, n2 - 4, n - 4, n2 - 4);
            graphics.drawLine(3, n2 - 2, 3, n2 - 2);
            graphics.drawLine(n - 2, 2, n - 2, 2);
            graphics.setColor(MacLookAndFeel.getGray6());
            graphics.drawLine(3, n2 - 2, n - 3, n2 - 2);
            graphics.drawLine(n - 2, 3, n - 2, n2 - 4);
            graphics.drawLine(n - 3, n2 - 3, n - 3, n2 - 3);
        }

        private void drawOutlineBorder(Component component, Graphics graphics, Color color, int n, int n2) {
            graphics.setColor(color);
            graphics.drawLine(2, 0, n - 3, 0);
            graphics.drawLine(0, 2, 0, n2 - 3);
            graphics.drawLine(2, n2 - 1, n - 3, n2 - 1);
            graphics.drawLine(n - 1, 2, n - 1, n2 - 3);
            graphics.drawLine(1, 1, 1, 1);
            graphics.drawLine(n - 2, 1, n - 2, 1);
            graphics.drawLine(1, n2 - 2, 1, n2 - 2);
            graphics.drawLine(n - 2, n2 - 2, n - 2, n2 - 2);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }
    }
}

