/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.plaf.mac.MacLookAndFeel;
import com.sun.java.swing.plaf.mac.MacUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

class MacInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    static int titleBarHeight = 20;

    public MacInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    public void paintComponent(Graphics graphics) {
        boolean bl = MacUtils.isLeftToRight(this.frame);
        int n = this.getHeight();
        int n2 = this.getWidth();
        String string = this.frame.getTitle();
        graphics.setFont(MacLookAndFeel.getControlFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getHeight() - fontMetrics.getLeading();
        int n4 = (titleBarHeight - n3) / 2 + fontMetrics.getAscent() + fontMetrics.getLeading();
        int n5 = fontMetrics.stringWidth(string);
        int n6 = n2 / 2 - n5 / 2;
        graphics.drawString(string, n6, n4 -= 2);
        if (this.frame.isSelected()) {
            graphics.setColor(MacLookAndFeel.getGray2());
            graphics.fillRect(0, 0, n2 - 1, n - 1);
            graphics.setColor(MacLookAndFeel.getBlack());
            graphics.drawLine(0, n - 1, n2 - 1, n - 1);
            graphics.drawString(string, n6, n4);
            graphics.setColor(MacLookAndFeel.getGray4());
            graphics.drawLine(0, n - 2, n2, n - 2);
            int n7 = 0;
            int n8 = 2;
            if (this.frame.isClosable()) {
                if (bl) {
                    n7 += 16;
                } else {
                    n8 += 16;
                }
            }
            if (this.frame.isIconifiable()) {
                if (bl) {
                    n8 += 16;
                } else {
                    n7 += 16;
                }
            }
            if (this.frame.isMaximizable()) {
                if (bl) {
                    n8 += 16;
                } else {
                    n7 += 16;
                }
            }
            this.drawGrips(graphics, n7, n6 - 4);
            this.drawGrips(graphics, n6 + n5 + 4, n2 - n8);
        } else {
            graphics.setColor(MacLookAndFeel.getGray1());
            graphics.fillRect(0, 0, n2 - 1, n - 1);
            graphics.setColor(MacLookAndFeel.getGray8());
            graphics.drawLine(0, n - 1, n2 - 1, n - 1);
            graphics.drawString(string, n6, n4);
        }
        this.iconButton.setVisible(this.frame.isSelected());
        this.closeButton.setVisible(this.frame.isSelected());
        this.maxButton.setVisible(this.frame.isSelected());
    }

    void drawGrips(Graphics graphics, int n, int n2) {
        graphics.setColor(MacLookAndFeel.getWhite());
        int n3 = 2;
        while (n3 <= 12) {
            graphics.drawLine(n, n3, n2 - 1, n3);
            n3 += 2;
        }
        graphics.setColor(MacLookAndFeel.getGray6());
        int n4 = 2;
        while (n4 <= 12) {
            graphics.drawLine(n + 1, n4 + 1, n2, n4 + 1);
            n4 += 2;
        }
    }

    protected LayoutManager createLayout() {
        return new MacTitlePaneLayout();
    }

    protected void createButtons() {
        super.createButtons();
        EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 0);
        this.iconButton.setBorder(emptyBorder);
        this.maxButton.setBorder(emptyBorder);
        this.closeButton.setBorder(emptyBorder);
        this.iconButton.setPressedIcon(UIManager.getIcon("InternalFrame.iconifyPressed"));
        this.maxButton.setPressedIcon(UIManager.getIcon("InternalFrame.maximizePressed"));
        this.closeButton.setPressedIcon(UIManager.getIcon("InternalFrame.closePressed"));
        this.iconButton.setContentAreaFilled(false);
        this.maxButton.setContentAreaFilled(false);
        this.closeButton.setContentAreaFilled(false);
    }

    protected void setButtonIcons() {
        this.iconButton.setIcon(this.iconIcon);
        this.closeButton.setIcon(this.closeIcon);
        this.maxButton.setIcon(this.maxIcon);
    }

    protected void assembleSystemMenu() {
    }

    protected void addSystemMenuItems(JMenu jMenu) {
    }

    protected void addSubComponents() {
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    JButton getMaxB() {
        return this.maxButton;
    }

    JButton getIconB() {
        return this.iconButton;
    }

    JButton getCloseB() {
        return this.closeButton;
    }

    JInternalFrame getFrame() {
        return this.frame;
    }

    public class MacTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        public MacTitlePaneLayout() {
            super(MacInternalFrameTitlePane.this);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(100, titleBarHeight);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            int n;
            JButton jButton = MacInternalFrameTitlePane.this.getCloseB();
            JButton jButton2 = MacInternalFrameTitlePane.this.getIconB();
            JButton jButton3 = MacInternalFrameTitlePane.this.getMaxB();
            JInternalFrame jInternalFrame = MacInternalFrameTitlePane.this.getFrame();
            boolean bl = MacUtils.isLeftToRight(jInternalFrame);
            int n2 = 13;
            int n3 = MacInternalFrameTitlePane.this.getWidth();
            int n4 = n = bl ? 0 : n3 - (n2 - 1);
            if (jInternalFrame.isClosable()) {
                jButton.setBounds(n, 2, n2, n2);
            } else if (jButton.getParent() != null) {
                jButton.getParent().remove(jButton);
            }
            int n5 = n = bl ? n3 - (n2 - 1) : 0;
            if (jInternalFrame.isIconifiable()) {
                jButton2.setBounds(n, 2, n2, n2);
                n += bl ? -(n2 + 3) : n2 + 3;
            } else if (jButton2.getParent() != null) {
                jButton2.getParent().remove(jButton2);
            }
            if (jInternalFrame.isMaximizable()) {
                jButton3.setBounds(n, 2, n2, n2);
            } else if (jButton3.getParent() != null) {
                jButton3.getParent().remove(jButton3);
            }
        }
    }
}

