/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.plaf.mac.MacLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ButtonModel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;

public class MacScrollButton
extends BasicArrowButton {
    private static Color background;
    private static Color highlight;
    private static Color shadow;
    private static Color pressedBackground;
    private static Color pressedHighlight;
    private static Color pressedShadow;
    private static Color arrowColor;
    private int buttonWidth;

    public MacScrollButton(int n, int n2) {
        super(n);
        background = UIManager.getColor("ScrollBar.arrowBackground");
        highlight = UIManager.getColor("ScrollBar.arrowHighlight");
        shadow = UIManager.getColor("ScrollBar.arrowShadow");
        pressedBackground = UIManager.getColor("ScrollBar.pressedArrowBackground");
        pressedHighlight = UIManager.getColor("ScrollBar.pressedArrowHighlight");
        pressedShadow = UIManager.getColor("ScrollBar.pressedArrowShadow");
        arrowColor = UIManager.getColor("ScrollBar.arrowColor");
        this.buttonWidth = n2;
    }

    public void paint(Graphics graphics) {
        boolean bl;
        ButtonModel buttonModel = this.getModel();
        boolean bl2 = bl = buttonModel.isArmed() && buttonModel.isPressed();
        if (this.isEnabled()) {
            graphics.setColor(bl ? pressedBackground : background);
        } else {
            graphics.setColor(MacLookAndFeel.getGray0());
        }
        graphics.fillRect(0, 0, this.buttonWidth, this.buttonWidth);
        if (this.isEnabled()) {
            graphics.setColor(bl ? pressedShadow : highlight);
            graphics.drawLine(0, 0, this.buttonWidth - 2, 0);
            graphics.drawLine(0, 0, 0, this.buttonWidth - 2);
            graphics.setColor(bl ? pressedHighlight : shadow);
            graphics.drawLine(this.buttonWidth - 1, 1, this.buttonWidth - 1, this.buttonWidth - 1);
            graphics.drawLine(1, this.buttonWidth - 1, this.buttonWidth - 1, this.buttonWidth - 1);
        } else {
            graphics.setColor(MacLookAndFeel.getGray9());
            switch (this.getDirection()) {
                case 1: {
                    graphics.drawLine(0, this.buttonWidth - 1, this.buttonWidth - 1, this.buttonWidth - 1);
                    break;
                }
                case 5: {
                    graphics.drawLine(0, 0, this.buttonWidth - 1, 0);
                    break;
                }
                case 3: {
                    graphics.drawLine(0, 0, 0, this.buttonWidth - 1);
                    break;
                }
                case 7: {
                    graphics.drawLine(this.buttonWidth - 1, 0, this.buttonWidth - 1, this.buttonWidth - 1);
                }
            }
        }
        graphics.setColor(this.isEnabled() ? arrowColor : MacLookAndFeel.getGray6());
        switch (this.getDirection()) {
            case 1: {
                graphics.drawLine(6, 5, 7, 5);
                graphics.drawLine(5, 6, 8, 6);
                graphics.drawLine(4, 7, 9, 7);
                graphics.drawLine(3, 8, 10, 8);
                break;
            }
            case 5: {
                graphics.drawLine(3, 5, 10, 5);
                graphics.drawLine(4, 6, 9, 6);
                graphics.drawLine(5, 7, 8, 7);
                graphics.drawLine(6, 8, 7, 8);
                break;
            }
            case 7: {
                graphics.drawLine(5, 6, 5, 7);
                graphics.drawLine(6, 5, 6, 8);
                graphics.drawLine(7, 4, 7, 9);
                graphics.drawLine(8, 3, 8, 10);
                break;
            }
            case 3: {
                graphics.drawLine(5, 3, 5, 10);
                graphics.drawLine(6, 4, 6, 9);
                graphics.drawLine(7, 5, 7, 8);
                graphics.drawLine(8, 6, 8, 7);
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.buttonWidth, this.buttonWidth);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }
}

