/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.plaf.mac.MacLookAndFeel;
import com.sun.java.swing.plaf.mac.MacUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class MacTabbedPaneUI
extends BasicTabbedPaneUI {
    protected int minTabWidth = 40;
    protected Color selectColor;
    protected Color selectHighlight;
    protected Color nonSelectColor;
    protected int slant = 6;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MacTabbedPaneUI();
    }

    protected LayoutManager createLayoutManager() {
        return new TabbedPaneLayout();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.selectColor = UIManager.getColor("TabbedPane.selected");
        this.selectHighlight = UIManager.getColor("TabbedPane.selectHighlight");
        this.nonSelectColor = UIManager.getColor("TabbedPane.nonSelected");
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = n4 + (n6 - 1);
        int n8 = n3 + (n5 - 1);
        switch (n) {
            default: 
        }
        this.paintTopTabBorder(n2, graphics, n3, n4, n5, n6, n7, n8, bl);
    }

    protected void paintTopTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        int n8 = this.getRunForTab(this.tabPane.getTabCount(), n);
        int n9 = this.lastTabInRun(this.tabPane.getTabCount(), n8);
        int n10 = this.tabRuns[n8];
        int n11 = n5 - 1;
        int n12 = n4 - 1;
        if (this.shouldFillGap(n8, n, n2, n3)) {
            graphics.translate(n2, n3);
            graphics.setColor(this.nonSelectColor);
            int[] nArray = new int[4];
            int[] nArray2 = new int[4];
            nArray[0] = 1;
            nArray[1] = this.slant;
            nArray[2] = this.slant + 4;
            nArray[3] = 1;
            nArray2[0] = n5 - 1;
            nArray2[1] = 3;
            nArray2[2] = 0;
            nArray2[3] = 0;
            graphics.fillPolygon(new Polygon(nArray, nArray2, 4));
            nArray[0] = n12 + 1;
            nArray[1] = n12 - this.slant;
            nArray[2] = n12 - (this.slant + 4);
            nArray[3] = n12 + 1;
            nArray2[0] = n5 - 1;
            nArray2[1] = 3;
            nArray2[2] = 0;
            nArray2[3] = 0;
            graphics.fillPolygon(new Polygon(nArray, nArray2, 4));
            graphics.drawLine(0, n11 - 3, 0, 0);
            graphics.translate(-n2, -n3);
            boolean bl2 = MacUtils.isLeftToRight(this.tabPane);
            int n13 = this.tabPane.getWidth();
            if (bl2 && n == n10 || !bl2 && n == n9) {
                nArray[0] = 0;
                nArray[1] = n2;
                nArray[2] = n2;
                nArray[3] = 0;
                nArray2[0] = n3;
                nArray2[1] = n3;
                nArray2[2] = n3 + n5;
                nArray2[3] = n3 + n5;
                graphics.fillPolygon(new Polygon(nArray, nArray2, 4));
            }
            if (bl2 && n == n9 || !bl2 && n == n10) {
                nArray[0] = n2 + n4;
                nArray[1] = n13;
                nArray[2] = n13;
                nArray[3] = n2 + n4;
                nArray2[0] = n3;
                nArray2[1] = n3;
                nArray2[2] = n3 + n5;
                nArray2[3] = n3 + n5;
                graphics.fillPolygon(new Polygon(nArray, nArray2, 4));
            }
            if (bl2 && n == n10 || !bl2 && n == n9) {
                graphics.setColor(MacLookAndFeel.getBlack());
                graphics.drawLine(0, n3, n2, n3);
                graphics.setColor(MacLookAndFeel.getGray1());
                graphics.drawLine(0, n3 + 1, n2, n3 + 1);
            }
            if (bl2 && n == n9 || !bl2 && n == n10) {
                graphics.setColor(MacLookAndFeel.getBlack());
                graphics.drawLine(n2 + n4, n3, n13, n3);
                graphics.setColor(MacLookAndFeel.getGray1());
                graphics.drawLine(n2 + n4, n3 + 1, n13, n3 + 1);
            }
        }
        graphics.translate(n2, n3);
        graphics.setColor(MacLookAndFeel.getGray0());
        graphics.drawLine(1, n11 - 1, this.slant + 1, 3);
        graphics.drawLine(this.slant + 1, 3, this.slant + 2, 2);
        graphics.drawLine(this.slant + 2, 2, this.slant + 4, 1);
        graphics.drawLine(this.slant + 4, 1, n12 - (this.slant + 4), 1);
        graphics.setColor(MacLookAndFeel.getGray7());
        graphics.drawLine(n12 - (this.slant + 4), 1, n12 - (this.slant + 2), 2);
        graphics.drawLine(n12 - (this.slant + 2), 2, n12 - this.slant - 1, 3);
        graphics.drawLine(n12 - this.slant - 1, 3, n12 - 1, n11 - 1);
        graphics.setColor(MacLookAndFeel.getBlack());
        graphics.drawLine(0, n11, this.slant, 3);
        graphics.drawLine(this.slant, 3, this.slant + 1, 2);
        graphics.drawLine(this.slant + 2, 1, this.slant + 4, 0);
        graphics.drawLine(this.slant + 4, 0, n12 - (this.slant + 4), 0);
        graphics.drawLine(n12 - (this.slant + 4), 0, n12 - (this.slant + 2), 1);
        graphics.drawLine(n12 - (this.slant + 1), 2, n12 - this.slant, 3);
        graphics.drawLine(n12 - this.slant, 3, n12, n11);
        graphics.translate(-n2, -n3);
    }

    protected boolean shouldFillGap(int n, int n2, int n3, int n4) {
        return n < this.runCount - 1;
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = n6 / 2;
        if (bl) {
            graphics.setColor(this.tabPane.getBackground());
        } else {
            graphics.setColor(this.nonSelectColor);
        }
        switch (n) {
            default: 
        }
        graphics.translate(n3, n4);
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray[0] = 1;
        nArray[1] = this.slant + 1;
        nArray[2] = n5 - nArray[1];
        nArray[3] = n5 - 1;
        nArray2[0] = n6;
        nArray2[1] = 3;
        nArray2[2] = nArray2[1];
        nArray2[3] = nArray2[0];
        graphics.fillPolygon(new Polygon(nArray, nArray2, 4));
        nArray[0] = this.slant + 1;
        nArray[1] = this.slant + 3;
        nArray[2] = n5 - nArray[1];
        nArray[3] = n5 - nArray[0];
        nArray2[0] = 3;
        nArray2[1] = 1;
        nArray2[2] = nArray2[1];
        nArray2[3] = nArray2[0];
        graphics.fillPolygon(new Polygon(nArray, nArray2, 4));
        graphics.translate(-n3, -n4);
    }

    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        return 0;
    }

    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        return 0;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n = this.tabPane.getTabPlacement();
        Insets insets = jComponent.getInsets();
        Dimension dimension = jComponent.getSize();
        if (this.tabPane.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            switch (n) {
                default: 
            }
            graphics.fillRect(insets.left, insets.top, dimension.width - insets.right - insets.left, this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight));
            this.paintHighlightBelowTab();
        }
        super.paint(graphics, jComponent);
    }

    protected void paintHighlightBelowTab() {
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(MacLookAndFeel.getBlack());
        Rectangle rectangle = this.rects[n2];
        graphics.drawLine(n3, n4, rectangle.x - 1, n4);
        if (rectangle.x + rectangle.width < n3 + n5 - 2) {
            graphics.drawLine(rectangle.x + rectangle.width, n4, n3 + n5 - 2, n4);
        }
        graphics.setColor(MacLookAndFeel.getGray1());
        graphics.drawLine(n3, n4 + 1, rectangle.x - 1, n4 + 1);
        if (rectangle.x + rectangle.width < n3 + n5 - 2) {
            graphics.drawLine(rectangle.x + rectangle.width, n4 + 1, n3 + n5 - 2, n4 + 1);
        }
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(MacLookAndFeel.getBlack());
        graphics.drawLine(n3, n4 + (n6 - 1), n3 + (n5 - 1), n4 + (n6 - 1));
        graphics.setColor(MacLookAndFeel.getGray6());
        graphics.drawLine(n3 + 1, n4 + (n6 - 1) - 1, n3 + (n5 - 1) - 1, n4 + (n6 - 1) - 1);
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(MacLookAndFeel.getBlack());
        graphics.drawLine(n3, n4, n3, n4 + (n6 - 1));
        graphics.setColor(MacLookAndFeel.getGray1());
        graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + (n6 - 1) - 1);
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(MacLookAndFeel.getBlack());
        graphics.drawLine(n3 + (n5 - 1), n4, n3 + (n5 - 1), n4 + (n6 - 1));
        graphics.setColor(MacLookAndFeel.getGray6());
        graphics.drawLine(n3 + (n5 - 1) - 1, n4 + 1, n3 + (n5 - 1) - 1, n4 + (n6 - 1) - 1);
    }

    protected int calculateTabHeight(int n, int n2, int n3) {
        int n4 = n3;
        Icon icon = this.getIconForTab(n2);
        Insets insets = this.getTabInsets(n, n2);
        if (icon != null) {
            n4 = Math.max(n4, icon.getIconHeight());
        }
        return n4 += insets.top + insets.bottom;
    }

    protected int calculateMaxTabHeight(int n) {
        FontMetrics fontMetrics = this.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.tabPane.getTabCount()) {
            Icon icon = this.tabPane.getIconAt(n3);
            if (icon != null && icon.getIconHeight() > n2) {
                bl = true;
                break;
            }
            ++n3;
        }
        return super.calculateMaxTabHeight(n) - (bl ? this.tabInsets.top + this.tabInsets.bottom : 0);
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        String string = this.tabPane.getTitleAt(n2);
        Icon icon = this.getIconForTab(n2);
        Insets insets = this.getTabInsets(n, n2);
        int n3 = insets.left + insets.right + 5;
        if (icon != null) {
            n3 += icon.getIconWidth() + this.textIconGap;
        }
        return n3 += SwingUtilities.computeStringWidth(fontMetrics, string);
    }

    protected int getTabRunOverlay(int n) {
        return 0;
    }

    public class TabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        public TabbedPaneLayout() {
            super(MacTabbedPaneUI.this);
        }

        protected void padSelectedTab(int n, int n2) {
        }
    }
}

