/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.plaf.mac.MacUtils;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;

public class MacTreeUI
extends BasicTreeUI {
    protected boolean pressedOnControl = false;
    protected boolean highlightControl = false;
    protected Icon expandedIconR;
    protected Icon collapsedIconR;
    protected Icon darkExpandedIcon;
    protected Icon darkExpandedIconR;
    protected Icon darkCollapsedIcon;
    protected Icon darkCollapsedIconR;
    protected TreePath firstPath;
    protected MouseMotionListener mouseMotionHandler;
    private int rightMargin;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MacTreeUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.expandedIconR = UIManager.getIcon("Tree.expandedIconR");
        this.collapsedIconR = UIManager.getIcon("Tree.collapsedIconR");
        this.darkExpandedIcon = UIManager.getIcon("Tree.darkExpandedIcon");
        this.darkExpandedIconR = UIManager.getIcon("Tree.darkExpandedIconR");
        this.darkCollapsedIcon = UIManager.getIcon("Tree.darkCollapsedIcon");
        this.darkCollapsedIconR = UIManager.getIcon("Tree.darkCollapsedIconR");
    }

    protected void installListeners() {
        super.installListeners();
        this.mouseMotionHandler = this.createMouseMotionListener();
        if (this.mouseMotionHandler != null) {
            this.tree.addMouseMotionListener(this.mouseMotionHandler);
        }
    }

    protected void uninstallListeners() {
        if (this.mouseMotionHandler != null) {
            this.tree.removeMouseMotionListener(this.mouseMotionHandler);
            this.mouseMotionHandler = null;
        }
        super.uninstallListeners();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new MouseMotionHandler();
    }

    protected boolean isLocationInExpandControl(TreePath treePath, int n, int n2) {
        boolean bl;
        int n3 = this.getRowForPath(this.tree, treePath);
        int n4 = treePath.getPathCount() - 1;
        boolean bl2 = bl = n4 > 0 || n4 == 0 && this.getShowsRootHandles();
        if (this.tree != null && !this.isLeaf(n3) && bl) {
            int n5;
            Icon icon = this.tree.isExpanded(treePath) ? this.getExpandedIcon() : this.getCollapsedIcon();
            Rectangle rectangle = this.tree.getPathBounds(treePath);
            Insets insets = this.tree.getInsets();
            int n6 = rectangle.y + rectangle.height / 2;
            int n7 = n6 - icon.getIconHeight() / 2;
            int n8 = n6 + icon.getIconHeight() / 2;
            if (MacUtils.isLeftToRight(this.tree)) {
                int n9 = insets.left;
                n5 = insets.left + icon.getIconWidth() - 1;
            } else {
                n5 = this.rightMargin - insets.right;
                int n10 = this.rightMargin - icon.getIconWidth() + 1;
            }
            if (n2 >= n7 && n2 <= n8 && n >= insets.left && n <= n5) {
                return true;
            }
        }
        return false;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.getRightMargin();
        super.paint(graphics, jComponent);
    }

    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
    }

    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
    }

    protected boolean shouldPaintExpandControl(TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (!this.getShowsRootHandles() && this.isRootVisible() && treePath.getPathCount() == 1) {
            return false;
        }
        return super.shouldPaintExpandControl(treePath, n, bl, bl2, bl3);
    }

    protected void paintExpandControl(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = MacUtils.isLeftToRight(this.tree);
        if (bl4) {
            graphics.translate(insets.left, 0);
        } else {
            graphics.translate(insets.right, 0);
        }
        Object object = treePath.getLastPathComponent();
        if (!(bl3 || bl2 && this.treeModel.getChildCount(object) <= 0)) {
            int n2 = rectangle2.y + rectangle2.height / 2;
            if (bl) {
                Icon icon = this.getExpandedIcon();
                int n3 = icon.getIconWidth() / 2;
                if (!bl4) {
                    n3 = this.rightMargin - n3 - insets.right;
                }
                if (icon != null) {
                    this.drawCentered(this.tree, graphics, icon, n3, n2);
                }
            } else {
                Icon icon = this.getCollapsedIcon();
                int n4 = icon.getIconWidth() / 2;
                if (!bl4) {
                    n4 = this.rightMargin - n4 - insets.right;
                }
                if (icon != null) {
                    this.drawCentered(this.tree, graphics, icon, n4, n2);
                }
            }
        }
        if (bl4) {
            graphics.translate(-insets.left, 0);
        } else {
            graphics.translate(-insets.right, 0);
        }
    }

    public Icon getExpandedIcon() {
        if (this.highlightControl) {
            if (MacUtils.isLeftToRight(this.tree)) {
                return this.darkExpandedIcon;
            }
            return this.darkExpandedIconR;
        }
        if (MacUtils.isLeftToRight(this.tree)) {
            return super.getExpandedIcon();
        }
        return this.expandedIconR;
    }

    public Icon getCollapsedIcon() {
        if (this.highlightControl) {
            if (MacUtils.isLeftToRight(this.tree)) {
                return this.darkCollapsedIcon;
            }
            return this.darkCollapsedIconR;
        }
        if (MacUtils.isLeftToRight(this.tree)) {
            return super.getCollapsedIcon();
        }
        return this.collapsedIconR;
    }

    protected JTree getTree() {
        return this.tree;
    }

    protected void handleExpandControlClick(TreePath treePath, int n, int n2) {
        super.handleExpandControlClick(treePath, n, n2);
    }

    protected void repaintControl(TreePath treePath) {
        Rectangle rectangle = this.getPathBounds(this.tree, treePath);
        rectangle.x = this.tree.getInsets().left;
        rectangle.width = this.getExpandedIcon().getIconWidth();
        this.tree.repaint(rectangle);
    }

    private void getRightMargin() {
        boolean bl = MacUtils.isLeftToRight(this.tree);
        if (!bl) {
            Container container = this.tree.getParent();
            while (container != null && !(container instanceof JScrollPane) && !(container instanceof JPanel)) {
                container = container.getParent();
            }
            if (container != null) {
                Rectangle rectangle = container.getBounds();
                if (container instanceof JScrollPane) {
                    JScrollPane jScrollPane = (JScrollPane)container;
                    JViewport jViewport = jScrollPane.getViewport();
                    rectangle = jViewport.getViewRect();
                }
                this.rightMargin = rectangle.x + rectangle.width - 1;
            }
        }
    }

    public class MouseMotionHandler
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            if (MacTreeUI.this.pressedOnControl) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                TreePath treePath = MacTreeUI.this.getClosestPathForLocation(MacTreeUI.this.getTree(), n, n2);
                boolean bl = MacTreeUI.this.isLocationInExpandControl(treePath, n, n2);
                if (!MacTreeUI.this.highlightControl && treePath == MacTreeUI.this.firstPath && bl) {
                    MacTreeUI.this.highlightControl = true;
                    MacTreeUI.this.repaintControl(MacTreeUI.this.firstPath);
                } else if (MacTreeUI.this.highlightControl && !bl) {
                    MacTreeUI.this.highlightControl = false;
                    MacTreeUI.this.repaintControl(MacTreeUI.this.firstPath);
                }
            }
        }
    }

    public class MouseHandler
    extends BasicTreeUI.MouseHandler {
        public MouseHandler() {
            super(MacTreeUI.this);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            TreePath treePath;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            MacTreeUI.this.firstPath = treePath = MacTreeUI.this.getClosestPathForLocation(MacTreeUI.this.getTree(), n, n2);
            if (MacTreeUI.this.isLocationInExpandControl(treePath, n, n2)) {
                MacTreeUI.this.pressedOnControl = true;
                MacTreeUI.this.highlightControl = true;
                MacTreeUI.this.repaintControl(treePath);
            } else {
                super.mousePressed(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            TreePath treePath = MacTreeUI.this.getClosestPathForLocation(MacTreeUI.this.getTree(), n, n2);
            MacTreeUI.this.highlightControl = false;
            if (MacTreeUI.this.pressedOnControl && treePath == MacTreeUI.this.firstPath && MacTreeUI.this.isLocationInExpandControl(treePath, n, n2)) {
                MacTreeUI.this.pressedOnControl = false;
                MacTreeUI.this.handleExpandControlClick(treePath, n, n2);
            } else {
                MacTreeUI.this.pressedOnControl = false;
                super.mouseReleased(mouseEvent);
            }
        }
    }
}

