/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopPaneUI;

public class MotifDesktopPaneUI
extends BasicDesktopPaneUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifDesktopPaneUI();
    }

    protected void installDesktopManager() {
        if (this.desktop.getDesktopManager() == null) {
            this.desktopManager = new MotifDesktopManager();
            this.desktop.setDesktopManager(this.desktopManager);
        }
    }

    public Insets getInsets(JComponent jComponent) {
        return new Insets(0, 0, 0, 0);
    }

    private class MotifDesktopManager
    extends DefaultDesktopManager
    implements Serializable {
        JComponent dragPane;
        boolean usingDragPane;
        private transient JLayeredPane layeredPaneForDragPane;

        private MotifDesktopManager() {
        }

        public void setBoundsForFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
            if (!this.usingDragPane) {
                boolean bl = jComponent.getWidth() != n3 || jComponent.getHeight() != n4;
                Rectangle rectangle = jComponent.getBounds();
                jComponent.setBounds(n, n2, n3, n4);
                SwingUtilities.computeUnion(n, n2, n3, n4, rectangle);
                jComponent.getParent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (bl) {
                    jComponent.validate();
                }
            } else {
                Rectangle rectangle = this.dragPane.getBounds();
                this.dragPane.setBounds(n, n2, n3, n4);
                SwingUtilities.computeUnion(n, n2, n3, n4, rectangle);
                this.dragPane.getParent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void beginDraggingFrame(JComponent jComponent) {
            this.usingDragPane = false;
            if (jComponent.getParent() instanceof JLayeredPane) {
                if (this.dragPane == null) {
                    this.dragPane = new DragPane();
                }
                this.layeredPaneForDragPane = (JLayeredPane)jComponent.getParent();
                this.layeredPaneForDragPane.setLayer(this.dragPane, Integer.MAX_VALUE);
                this.dragPane.setBounds(jComponent.getX(), jComponent.getY(), jComponent.getWidth(), jComponent.getHeight());
                this.layeredPaneForDragPane.add(this.dragPane);
                this.usingDragPane = true;
            }
        }

        public void dragFrame(JComponent jComponent, int n, int n2) {
            this.setBoundsForFrame(jComponent, n, n2, jComponent.getWidth(), jComponent.getHeight());
        }

        public void endDraggingFrame(JComponent jComponent) {
            if (this.usingDragPane) {
                if (this.layeredPaneForDragPane != null) {
                    this.layeredPaneForDragPane.remove(this.dragPane);
                    this.usingDragPane = false;
                    this.setBoundsForFrame(jComponent, this.dragPane.getX(), this.dragPane.getY(), this.dragPane.getWidth(), this.dragPane.getHeight());
                } else if (jComponent.getParent() != null) {
                    jComponent.getParent().remove(this.dragPane);
                    this.usingDragPane = false;
                    this.setBoundsForFrame(jComponent, this.dragPane.getX(), this.dragPane.getY(), this.dragPane.getWidth(), this.dragPane.getHeight());
                }
            }
        }

        public void beginResizingFrame(JComponent jComponent, int n) {
            this.usingDragPane = false;
            if (jComponent.getParent() instanceof JLayeredPane) {
                if (this.dragPane == null) {
                    this.dragPane = new DragPane();
                }
                JLayeredPane jLayeredPane = (JLayeredPane)jComponent.getParent();
                jLayeredPane.setLayer(this.dragPane, Integer.MAX_VALUE);
                this.dragPane.setBounds(jComponent.getX(), jComponent.getY(), jComponent.getWidth(), jComponent.getHeight());
                jLayeredPane.add(this.dragPane);
                this.usingDragPane = true;
            }
        }

        public void resizeFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
            this.setBoundsForFrame(jComponent, n, n2, n3, n4);
        }

        public void endResizingFrame(JComponent jComponent) {
            if (this.usingDragPane) {
                JLayeredPane jLayeredPane = (JLayeredPane)jComponent.getParent();
                jLayeredPane.remove(this.dragPane);
                this.usingDragPane = false;
                this.setBoundsForFrame(jComponent, this.dragPane.getX(), this.dragPane.getY(), this.dragPane.getWidth(), this.dragPane.getHeight());
            }
        }
    }

    private class DragPane
    extends JComponent {
        private DragPane() {
        }

        public void paint(Graphics graphics) {
            graphics.setColor(Color.darkGray);
            graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }
}

