/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import com.ibm.jvm.Constants;
import com.ibm.jvm.io.LocalizedInputStream;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import sun.awt.NativeLibLoader;
import sun.security.action.GetPropertyAction;

public class Cursor
implements Serializable {
    public static final int DEFAULT_CURSOR = 0;
    public static final int CROSSHAIR_CURSOR = 1;
    public static final int TEXT_CURSOR = 2;
    public static final int WAIT_CURSOR = 3;
    public static final int SW_RESIZE_CURSOR = 4;
    public static final int SE_RESIZE_CURSOR = 5;
    public static final int NW_RESIZE_CURSOR = 6;
    public static final int NE_RESIZE_CURSOR = 7;
    public static final int N_RESIZE_CURSOR = 8;
    public static final int S_RESIZE_CURSOR = 9;
    public static final int W_RESIZE_CURSOR = 10;
    public static final int E_RESIZE_CURSOR = 11;
    public static final int HAND_CURSOR = 12;
    public static final int MOVE_CURSOR = 13;
    protected static Cursor[] predefined = new Cursor[14];
    static final String[][] cursorProperties = new String[][]{{"AWT.DefaultCursor", "Default Cursor"}, {"AWT.CrosshairCursor", "Crosshair Cursor"}, {"AWT.TextCursor", "Text Cursor"}, {"AWT.WaitCursor", "Wait Cursor"}, {"AWT.SWResizeCursor", "Southwest Resize Cursor"}, {"AWT.SEResizeCursor", "Southeast Resize Cursor"}, {"AWT.NWResizeCursor", "Northwest Resize Cursor"}, {"AWT.NEResizeCursor", "Northeast Resize Cursor"}, {"AWT.NResizeCursor", "North Resize Cursor"}, {"AWT.SResizeCursor", "South Resize Cursor"}, {"AWT.WResizeCursor", "West Resize Cursor"}, {"AWT.EResizeCursor", "East Resize Cursor"}, {"AWT.HandCursor", "Hand Cursor"}, {"AWT.MoveCursor", "Move Cursor"}};
    int type = 0;
    public static final int CUSTOM_CURSOR = -1;
    private static final Hashtable systemCustomCursors = new Hashtable(1);
    private static final String systemCustomCursorDirPrefix = Cursor.initCursorDir();
    private static final String systemCustomCursorPropertiesFile = systemCustomCursorDirPrefix + Constants.cursors_properties;
    private static Properties systemCustomCursorProperties = null;
    private static final String CursorDotPrefix = "Cursor.";
    private static final String DotFileSuffix = ".File";
    private static final String DotHotspotSuffix = ".HotSpot";
    private static final String DotNameSuffix = ".Name";
    private static final long serialVersionUID = 8028237497568985504L;
    private transient long pData;
    protected String name;

    private static String initCursorDir() {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("java.home"));
        return string + File.separator + "lib" + File.separator + "images" + File.separator + "cursors" + File.separator;
    }

    private static native void initIDs();

    public static Cursor getPredefinedCursor(int n) {
        if (n < 0 || n > 13) {
            throw new IllegalArgumentException("illegal cursor type");
        }
        if (predefined[n] == null) {
            Cursor.predefined[n] = new Cursor(n);
        }
        return predefined[n];
    }

    public static Cursor getSystemCustomCursor(String string) throws AWTException {
        Cursor cursor = (Cursor)systemCustomCursors.get(string);
        if (cursor == null) {
            String string2;
            Hashtable hashtable = systemCustomCursors;
            synchronized (hashtable) {
                if (systemCustomCursorProperties == null) {
                    Cursor.loadSystemCustomCursorProperties();
                }
            }
            String string3 = CursorDotPrefix + string;
            String string4 = string3 + DotFileSuffix;
            if (!systemCustomCursorProperties.containsKey(string4)) {
                System.err.println("Cursor.getSystemCustomCursor(" + string + ") returned null");
                return null;
            }
            final String string5 = systemCustomCursorProperties.getProperty(string4);
            String string6 = systemCustomCursorProperties.getProperty(string3 + DotNameSuffix);
            if (string6 == null) {
                string6 = string;
            }
            if ((string2 = systemCustomCursorProperties.getProperty(string3 + DotHotspotSuffix)) == null) {
                throw new AWTException("no hotspot property defined for cursor: " + string);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (stringTokenizer.countTokens() != 2) {
                throw new AWTException("failed to parse hotspot property for cursor: " + string);
            }
            int n = 0;
            int n2 = 0;
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
                n2 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new AWTException("failed to parse hotspot property for cursor: " + string);
            }
            try {
                final int n3 = n;
                final int n4 = n2;
                final String string7 = string6;
                cursor = (Cursor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Toolkit toolkit = Toolkit.getDefaultToolkit();
                        Image image = toolkit.getImage(systemCustomCursorDirPrefix + string5);
                        return toolkit.createCustomCursor(image, new Point(n3, n4), string7);
                    }
                });
            }
            catch (Exception exception) {
                throw new AWTException("Exception: " + exception.getClass() + " " + exception.getMessage() + " occurred while creating cursor " + string);
            }
            if (cursor == null) {
                System.err.println("Cursor.getSystemCustomCursor(" + string + ") returned null");
            } else {
                systemCustomCursors.put(string, cursor);
            }
        }
        return cursor;
    }

    public static Cursor getDefaultCursor() {
        return Cursor.getPredefinedCursor(0);
    }

    public Cursor(int n) {
        if (n < 0 || n > 13) {
            throw new IllegalArgumentException("illegal cursor type");
        }
        this.type = n;
        this.name = Toolkit.getProperty(cursorProperties[n][0], cursorProperties[n][1]);
    }

    protected Cursor(String string) {
        this.type = -1;
        this.name = string;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getName() + "]";
    }

    private static void loadSystemCustomCursorProperties() throws AWTException {
        Hashtable hashtable = systemCustomCursors;
        synchronized (hashtable) {
            systemCustomCursorProperties = new Properties();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public Object run() throws Exception {
                        FileInputStream fileInputStream = null;
                        try {
                            fileInputStream = new FileInputStream(systemCustomCursorPropertiesFile);
                            systemCustomCursorProperties.load(LocalizedInputStream.localize(fileInputStream));
                            Object var3_2 = null;
                            if (fileInputStream == null) return null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            if (fileInputStream == null) throw throwable;
                            fileInputStream.close();
                            throw throwable;
                        }
                        fileInputStream.close();
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                systemCustomCursorProperties = null;
                throw new AWTException("Exception: " + exception.getClass() + " " + exception.getMessage() + " occurred while loading: " + systemCustomCursorPropertiesFile);
            }
        }
    }

    protected native void finalize() throws Throwable;

    static {
        NativeLibLoader.loadLibraries();
        Cursor.initIDs();
    }
}

