/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventDispatchThread;
import java.awt.EventQueue;
import java.awt.EventQueueItem;
import java.awt.MenuComponent;
import java.awt.Queue;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.EmptyStackException;
import sun.awt.DebugHelper;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;

public class EventQueue {
    private static final DebugHelper dbg = DebugHelper.create(class$java$awt$EventQueue == null ? (class$java$awt$EventQueue = EventQueue.class$("java.awt.EventQueue")) : class$java$awt$EventQueue);
    private static int threadInitNumber;
    private static final int LOW_PRIORITY = 0;
    private static final int NORM_PRIORITY = 1;
    private static final int HIGH_PRIORITY = 2;
    private static final int NUM_PRIORITIES = 3;
    private Queue[] queues = new Queue[3];
    private EventQueue nextQueue;
    private EventQueue previousQueue;
    private EventDispatchThread dispatchThread;
    private static final boolean debug = false;
    private final String[] osName = new String[]{""};
    private boolean fUNIX = false;
    int[] queuewait = new int[3];
    static /* synthetic */ Class class$java$awt$EventQueue;

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    public EventQueue() {
        int n = 1;
        this.osName[0] = System.getProperty("os.name");
        if (this.osName[0] != null && this.osName[0].indexOf("Windows") != -1) {
            String string = System.getProperty("java.awt.EventQueue.priorityBoost");
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                    if (5 + n > 10) {
                        n = 5;
                    } else if (5 + n < 1) {
                        n = -4;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
            } else {
                n = 0;
            }
        }
        int n2 = 0;
        while (n2 < 3) {
            this.queues[n2] = new Queue();
            ++n2;
        }
        String string = "AWT-EventQueue-" + EventQueue.nextThreadNum();
        this.dispatchThread = new EventDispatchThread(string, this);
        this.dispatchThread.setPriority(5 + n);
        this.dispatchThread.start();
        if (this.osName[0] != null && (this.osName[0].indexOf("Linux") != -1 || this.osName[0].indexOf("AIX") != -1 || this.osName[0].indexOf("OS/390") != -1)) {
            this.fUNIX = true;
        }
    }

    public void postEvent(AWTEvent aWTEvent) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof SunToolkit) {
            ((SunToolkit)toolkit).flushPendingEvents();
        }
        this.postEventPrivate(aWTEvent);
    }

    final void postEventPrivate(AWTEvent aWTEvent) {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            int n = aWTEvent.getID();
            if (this.nextQueue != null) {
                this.nextQueue.postEventPrivate(aWTEvent);
            } else if (aWTEvent instanceof PeerEvent && (((PeerEvent)aWTEvent).getFlags() & 1L) != 0L) {
                this.postEvent(aWTEvent, 2);
            } else if (n == 800 || n == 801) {
                this.postEvent(aWTEvent, 0);
            } else {
                this.postEvent(aWTEvent, 1);
            }
        }
    }

    private void postEvent(AWTEvent aWTEvent, int n) {
        EventQueueItem eventQueueItem = new EventQueueItem(aWTEvent);
        if (this.queues[n].head == null) {
            boolean bl = this.noEvents();
            this.queues[n].head = this.queues[n].tail = eventQueueItem;
            if (aWTEvent.getID() == 800 || aWTEvent.getID() == 801) {
                Object object = aWTEvent.getSource();
                ((Component)object).coalesceEvents(aWTEvent, aWTEvent);
            }
            if (bl) {
                this.notifyAll();
            }
        } else {
            Object object = aWTEvent.getSource();
            boolean bl = aWTEvent instanceof PeerEvent;
            if (object instanceof Component) {
                EventQueueItem eventQueueItem2 = this.queues[n].head;
                while (true) {
                    if (eventQueueItem2.id == eventQueueItem.id && eventQueueItem2.event.getSource() == object) {
                        AWTEvent aWTEvent2 = ((Component)object).coalesceEvents(eventQueueItem2.event, aWTEvent);
                        if (bl && aWTEvent2 == null && eventQueueItem2.event instanceof PeerEvent) {
                            aWTEvent2 = ((PeerEvent)eventQueueItem2.event).coalesceEvents((PeerEvent)aWTEvent);
                        }
                        if (aWTEvent2 != null) {
                            eventQueueItem2.event = aWTEvent2;
                            return;
                        }
                    }
                    if (eventQueueItem2.next == null) break;
                    eventQueueItem2 = eventQueueItem2.next;
                }
            }
            if (aWTEvent.getID() == 800 || aWTEvent.getID() == 801) {
                ((Component)object).coalesceEvents(aWTEvent, aWTEvent);
            }
            this.queues[n].tail.next = eventQueueItem;
            this.queues[n].tail = eventQueueItem;
        }
    }

    private boolean noEvents() {
        int n = 0;
        while (n < 3) {
            if (this.queues[n].head != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized AWTEvent getNextEvent() throws InterruptedException {
        EventQueueItem eventQueueItem = null;
        if (this.fUNIX) {
            while (true) {
                int n = 0;
                while (n < 3) {
                    int n2 = 2;
                    while (n2 >= 0) {
                        block12: {
                            if (this.queues[n2].head != null) {
                                if (this.queuewait[n2] > 3) {
                                    this.queuewait[n2] = 0;
                                    break block12;
                                } else {
                                    eventQueueItem = this.queues[n2].head;
                                    this.queues[n2].head = eventQueueItem.next;
                                    if (eventQueueItem.next == null) {
                                        this.queues[n2].tail = null;
                                    }
                                    int n3 = n2;
                                    this.queuewait[n3] = this.queuewait[n3] + 1;
                                    return eventQueueItem.event;
                                }
                            }
                            this.queuewait[n2] = 0;
                        }
                        --n2;
                    }
                    ++n;
                }
                this.wait();
            }
        }
        while (true) {
            int n = 2;
            while (n >= 0) {
                if (this.queues[n].head != null) {
                    eventQueueItem = this.queues[n].head;
                    this.queues[n].head = eventQueueItem.next;
                    if (eventQueueItem.next == null) {
                        this.queues[n].tail = null;
                    }
                    return eventQueueItem.event;
                }
                --n;
            }
            this.wait();
        }
    }

    public synchronized AWTEvent peekEvent() {
        int n = 2;
        while (n >= 0) {
            if (this.queues[n].head != null) {
                return this.queues[n].head.event;
            }
            --n;
        }
        return null;
    }

    public synchronized AWTEvent peekEvent(int n) {
        int n2 = 2;
        while (n2 >= 0) {
            EventQueueItem eventQueueItem = this.queues[n2].head;
            while (eventQueueItem != null) {
                if (eventQueueItem.id == n) {
                    return eventQueueItem.event;
                }
                eventQueueItem = eventQueueItem.next;
            }
            --n2;
        }
        return null;
    }

    protected void dispatchEvent(AWTEvent aWTEvent) {
        Object object = aWTEvent.getSource();
        if (aWTEvent instanceof ActiveEvent) {
            ((ActiveEvent)((Object)aWTEvent)).dispatch();
        } else if (object instanceof Component) {
            ((Component)object).dispatchEvent(aWTEvent);
        } else if (object instanceof MenuComponent) {
            ((MenuComponent)object).dispatchEvent(aWTEvent);
        } else {
            System.err.println("unable to dispatch event: " + aWTEvent);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void push(EventQueue eventQueue) {
        if (this.nextQueue != null) {
            this.nextQueue.push(eventQueue);
            return;
        }
        EventQueue eventQueue2 = eventQueue;
        synchronized (eventQueue2) {
            while (this.peekEvent() != null) {
                try {
                    eventQueue.postEventPrivate(this.getNextEvent());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            eventQueue.previousQueue = this;
        }
        this.nextQueue = eventQueue;
    }

    protected void pop() throws EmptyStackException {
        EventQueue eventQueue = this.previousQueue;
        EventQueue eventQueue2 = eventQueue != null ? eventQueue : this;
        synchronized (eventQueue2) {
            EventQueue eventQueue3 = this;
            synchronized (eventQueue3) {
                if (this.nextQueue != null) {
                    this.nextQueue.pop();
                    return;
                }
                if (this.previousQueue == null) {
                    throw new EmptyStackException();
                }
                this.previousQueue.nextQueue = null;
                while (this.peekEvent() != null) {
                    try {
                        this.previousQueue.postEventPrivate(this.getNextEvent());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.previousQueue = null;
            }
        }
        this.dispatchThread.stopDispatching();
    }

    public static boolean isDispatchThread() {
        EventQueue eventQueue = Toolkit.getEventQueue();
        EventQueue eventQueue2 = eventQueue.nextQueue;
        while (eventQueue2 != null) {
            eventQueue = eventQueue2;
            eventQueue2 = eventQueue.nextQueue;
        }
        return Thread.currentThread() == eventQueue.dispatchThread;
    }

    final EventDispatchThread getDispatchThread() {
        return this.dispatchThread;
    }

    final synchronized void changeKeyEventFocus(Object object) {
        int n = 0;
        while (n < 3) {
            EventQueueItem eventQueueItem = this.queues[n].head;
            while (eventQueueItem != null) {
                if (eventQueueItem.event instanceof KeyEvent) {
                    ((KeyEvent)eventQueueItem.event).setSource(object);
                }
                eventQueueItem = eventQueueItem.next;
            }
            ++n;
        }
    }

    final void removeSourceEvents(Object object) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof SunToolkit) {
            ((SunToolkit)toolkit).flushPendingEvents();
        }
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            int n = 0;
            while (n < 3) {
                EventQueueItem eventQueueItem = this.queues[n].head;
                EventQueueItem eventQueueItem2 = null;
                while (eventQueueItem != null) {
                    if (eventQueueItem.event.getSource() == object) {
                        if (eventQueueItem2 == null) {
                            this.queues[n].head = eventQueueItem.next;
                        } else {
                            eventQueueItem2.next = eventQueueItem.next;
                        }
                    } else {
                        eventQueueItem2 = eventQueueItem;
                    }
                    eventQueueItem = eventQueueItem.next;
                }
                this.queues[n].tail = eventQueueItem2;
                ++n;
            }
        }
    }

    public static void invokeLater(Runnable runnable) {
        Toolkit.getEventQueue().postEvent(new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
    }

    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Cannot call invokeAndWait from the event dispatcher thread");
        }
        class AWTInvocationLock {
            AWTInvocationLock() {
            }
        }
        AWTInvocationLock aWTInvocationLock = new AWTInvocationLock();
        EventQueue eventQueue = Toolkit.getEventQueue();
        InvocationEvent invocationEvent = new InvocationEvent(Toolkit.getDefaultToolkit(), runnable, aWTInvocationLock, true);
        AWTInvocationLock aWTInvocationLock2 = aWTInvocationLock;
        synchronized (aWTInvocationLock2) {
            Toolkit.getEventQueue().postEvent(invocationEvent);
            aWTInvocationLock.wait();
        }
        Exception exception = invocationEvent.getException();
        if (exception != null) {
            throw new InvocationTargetException(exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

