/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.peer.MenuPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class Menu
extends MenuItem
implements MenuContainer,
Accessible {
    Vector items = new Vector();
    boolean tearOff;
    boolean isHelpMenu;
    private static final String base = "menu";
    private static int nameCounter;
    private static final long serialVersionUID = -8809584163345499784L;
    private int menuSerializedDataVersion = 1;

    public Menu() {
        this("", false);
    }

    public Menu(String string) {
        this(string, false);
    }

    public Menu(String string, boolean bl) {
        super(string);
        this.tearOff = bl;
    }

    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string = base + nameCounter++;
            return string;
        }
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createMenu(this);
            }
            int n = this.getItemCount();
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = this.getItem(n2);
                menuItem.parent = this;
                menuItem.addNotify();
                ++n2;
            }
        }
    }

    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.getItemCount();
            int n2 = 0;
            while (n2 < n) {
                this.getItem(n2).removeNotify();
                ++n2;
            }
            super.removeNotify();
        }
    }

    public boolean isTearOff() {
        return this.tearOff;
    }

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.countItemsImpl();
    }

    final int countItemsImpl() {
        return this.items.size();
    }

    public MenuItem getItem(int n) {
        return this.getItemImpl(n);
    }

    final MenuItem getItemImpl(int n) {
        return (MenuItem)this.items.elementAt(n);
    }

    public MenuItem add(MenuItem menuItem) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (menuItem.parent != null) {
                menuItem.parent.remove(menuItem);
            }
            this.items.addElement(menuItem);
            menuItem.parent = this;
            MenuPeer menuPeer = (MenuPeer)this.peer;
            if (menuPeer != null) {
                menuItem.addNotify();
                menuPeer.addItem(menuItem);
            }
            MenuItem menuItem2 = menuItem;
            return menuItem2;
        }
    }

    public void add(String string) {
        this.add(new MenuItem(string));
    }

    public void insert(MenuItem menuItem, int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n < 0) {
                throw new IllegalArgumentException("index less than zero.");
            }
            int n2 = this.getItemCount();
            Vector vector = new Vector();
            int n3 = n;
            while (n3 < n2) {
                vector.addElement(this.getItem(n));
                this.remove(n);
                ++n3;
            }
            this.add(menuItem);
            int n4 = 0;
            while (n4 < vector.size()) {
                this.add((MenuItem)vector.elementAt(n4));
                ++n4;
            }
        }
    }

    public void insert(String string, int n) {
        this.insert(new MenuItem(string), n);
    }

    public void addSeparator() {
        this.add("-");
    }

    public void insertSeparator(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n < 0) {
                throw new IllegalArgumentException("index less than zero.");
            }
            int n2 = this.getItemCount();
            Vector vector = new Vector();
            int n3 = n;
            while (n3 < n2) {
                vector.addElement(this.getItem(n));
                this.remove(n);
                ++n3;
            }
            this.addSeparator();
            int n4 = 0;
            while (n4 < vector.size()) {
                this.add((MenuItem)vector.elementAt(n4));
                ++n4;
            }
        }
    }

    public void remove(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            MenuItem menuItem = this.getItem(n);
            this.items.removeElementAt(n);
            MenuPeer menuPeer = (MenuPeer)this.peer;
            if (menuPeer != null) {
                menuItem.removeNotify();
                menuItem.parent = null;
                menuPeer.delItem(n);
            }
        }
    }

    public void remove(MenuComponent menuComponent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.items.indexOf(menuComponent);
            if (n >= 0) {
                this.remove(n);
            }
        }
    }

    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.getItemCount();
            int n2 = n - 1;
            while (n2 >= 0) {
                this.remove(n2);
                --n2;
            }
        }
    }

    boolean handleShortcut(KeyEvent keyEvent) {
        int n = this.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = this.getItem(n2);
            if (menuItem.handleShortcut(keyEvent)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        int n = this.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = this.getItem(n2).getShortcutMenuItem(menuShortcut);
            if (menuItem != null) {
                return menuItem;
            }
            ++n2;
        }
        return null;
    }

    synchronized Enumeration shortcuts() {
        Vector vector = new Vector();
        int n = this.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            MenuItem menuItem = this.getItem(n2);
            if (menuItem instanceof Menu) {
                object = ((Menu)menuItem).shortcuts();
                while (object.hasMoreElements()) {
                    vector.addElement(object.nextElement());
                }
            } else {
                object = menuItem.getShortcut();
                if (object != null) {
                    vector.addElement(object);
                }
            }
            ++n2;
        }
        return vector.elements();
    }

    void deleteShortcut(MenuShortcut menuShortcut) {
        int n = this.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            this.getItem(n2).deleteShortcut();
            ++n2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = 0;
        while (n < this.items.size()) {
            MenuItem menuItem = (MenuItem)this.items.elementAt(n);
            menuItem.parent = this;
            ++n;
        }
    }

    public String paramString() {
        String string = ",tearOff=" + this.tearOff + ",isHelpMenu=" + this.isHelpMenu;
        return super.paramString() + string;
    }

    private static native void initIDs();

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenu();
        }
        return this.accessibleContext;
    }

    static {
        Menu.initIDs();
        nameCounter = 0;
    }

    protected class AccessibleAWTMenu
    extends MenuItem.AccessibleAWTMenuItem {
        protected AccessibleAWTMenu() {
            super(Menu.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }
    }
}

