/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.peer.MenuBarPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class MenuBar
extends MenuComponent
implements MenuContainer,
Accessible {
    Vector menus = new Vector();
    Menu helpMenu;
    private static final String base = "menubar";
    private static int nameCounter;
    private static final long serialVersionUID = -4930327919388951260L;
    private int menuBarSerializedDataVersion = 1;

    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string = base + nameCounter++;
            return string;
        }
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createMenuBar(this);
            }
            int n = this.getMenuCount();
            int n2 = 0;
            while (n2 < n) {
                this.getMenu(n2).addNotify();
                ++n2;
            }
        }
    }

    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.getMenuCount();
            int n2 = 0;
            while (n2 < n) {
                this.getMenu(n2).removeNotify();
                ++n2;
            }
            super.removeNotify();
        }
    }

    public Menu getHelpMenu() {
        return this.helpMenu;
    }

    public void setHelpMenu(Menu menu) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.helpMenu == menu) {
                return;
            }
            if (this.helpMenu != null) {
                this.remove(this.helpMenu);
            }
            if (menu.parent != this) {
                this.add(menu);
            }
            this.helpMenu = menu;
            if (menu != null) {
                menu.isHelpMenu = true;
                menu.parent = this;
                MenuBarPeer menuBarPeer = (MenuBarPeer)this.peer;
                if (menuBarPeer != null) {
                    if (menu.peer == null) {
                        menu.addNotify();
                    }
                    menuBarPeer.addHelpMenu(menu);
                }
            }
        }
    }

    public Menu add(Menu menu) {
        Object object = this.getTreeLock();
        synchronized (object) {
            MenuContainer menuContainer;
            if (menu.parent != null) {
                menu.parent.remove(menu);
            }
            this.menus.addElement(menu);
            menu.parent = this;
            MenuBarPeer menuBarPeer = (MenuBarPeer)this.peer;
            if (menuBarPeer != null) {
                if (menu.peer == null) {
                    menu.addNotify();
                }
                menuBarPeer.addMenu(menu);
            }
            if (this.parent != null) {
                menuContainer = (Component)this.parent;
                ((Component)menuContainer).setSize(((Component)menuContainer).width, ((Component)menuContainer).height + 1);
            }
            menuContainer = menu;
            return menuContainer;
        }
    }

    public void remove(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Menu menu = this.getMenu(n);
            this.menus.removeElementAt(n);
            MenuBarPeer menuBarPeer = (MenuBarPeer)this.peer;
            if (menuBarPeer != null) {
                menu.removeNotify();
                menu.parent = null;
                menuBarPeer.delMenu(n);
            }
        }
    }

    public void remove(MenuComponent menuComponent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.menus.indexOf(menuComponent);
            if (n >= 0) {
                this.remove(n);
            }
        }
    }

    public int getMenuCount() {
        return this.countMenus();
    }

    public int countMenus() {
        return this.getMenuCountImpl();
    }

    final int getMenuCountImpl() {
        return this.menus.size();
    }

    public Menu getMenu(int n) {
        return this.getMenuImpl(n);
    }

    final Menu getMenuImpl(int n) {
        return (Menu)this.menus.elementAt(n);
    }

    public synchronized Enumeration shortcuts() {
        Vector vector = new Vector();
        int n = this.getMenuCount();
        int n2 = 0;
        while (n2 < n) {
            Enumeration enumeration = this.getMenu(n2).shortcuts();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            ++n2;
        }
        return vector.elements();
    }

    public MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        int n = this.getMenuCount();
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = this.getMenu(n2).getShortcutMenuItem(menuShortcut);
            if (menuItem != null) {
                return menuItem;
            }
            ++n2;
        }
        return null;
    }

    boolean handleShortcut(KeyEvent keyEvent) {
        Object object;
        int n = keyEvent.getID();
        if (n != 401 && n != 402) {
            return false;
        }
        try {
            Class clazz = this.peer.getClass();
            Class[] classArray = new Class[]{keyEvent.getClass()};
            Method method = clazz.getDeclaredMethod("handleShortcut", classArray);
            object = new Object[]{keyEvent};
            Boolean bl = (Boolean)method.invoke(this.peer, (Object[])object);
            boolean bl2 = bl;
            if (bl2) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if ((keyEvent.getModifiers() & n2) == 0) {
            return false;
        }
        int n3 = this.getMenuCount();
        int n4 = 0;
        while (n4 < n3) {
            object = this.getMenu(n4);
            if (((Menu)object).handleShortcut(keyEvent)) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    public void deleteShortcut(MenuShortcut menuShortcut) {
        int n = this.getMenuCount();
        int n2 = 0;
        while (n2 < n) {
            this.getMenu(n2).deleteShortcut(menuShortcut);
            ++n2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = 0;
        while (n < this.menus.size()) {
            Menu menu = (Menu)this.menus.elementAt(n);
            menu.parent = this;
            ++n;
        }
    }

    private static native void initIDs();

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenuBar();
        }
        return this.accessibleContext;
    }

    static {
        MenuBar.initIDs();
        nameCounter = 0;
    }

    protected class AccessibleAWTMenuBar
    extends MenuComponent.AccessibleAWTMenuComponent {
        protected AccessibleAWTMenuBar() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_BAR;
        }
    }
}

