/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.MenuComponent;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.peer.MenuItemPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;

public class MenuItem
extends MenuComponent
implements Accessible {
    boolean enabled = true;
    String label;
    String actionCommand;
    long eventMask;
    transient ActionListener actionListener;
    private MenuShortcut shortcut = null;
    private static final String base = "menuitem";
    private static int nameCounter;
    private static final long serialVersionUID = -21757335363267194L;
    private int menuItemSerializedDataVersion = 1;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public MenuItem() {
        this("", null);
    }

    public MenuItem(String string) {
        this(string, null);
    }

    public MenuItem(String string, MenuShortcut menuShortcut) {
        this.label = string;
        this.shortcut = menuShortcut;
    }

    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string = base + nameCounter++;
            return string;
        }
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createMenuItem(this);
            }
        }
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String string) {
        this.label = string;
        MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
        if (menuItemPeer != null) {
            menuItemPeer.setLabel(string);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean bl) {
        this.enable(bl);
    }

    public synchronized void enable() {
        this.enabled = true;
        MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
        if (menuItemPeer != null) {
            menuItemPeer.enable();
        }
    }

    public void enable(boolean bl) {
        if (bl) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public synchronized void disable() {
        this.enabled = false;
        MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
        if (menuItemPeer != null) {
            menuItemPeer.disable();
        }
    }

    public MenuShortcut getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(MenuShortcut menuShortcut) {
        this.shortcut = menuShortcut;
        Object object = this.getTreeLock();
        synchronized (object) {
            MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
            if (menuItemPeer != null) {
                menuItemPeer.setLabel(this.label);
            }
        }
    }

    public void deleteShortcut() {
        this.shortcut = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
            if (menuItemPeer != null) {
                menuItemPeer.setLabel(this.label);
            }
        }
    }

    void deleteShortcut(MenuShortcut menuShortcut) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (menuShortcut.equals(this.shortcut)) {
                this.shortcut = null;
                MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
                if (menuItemPeer != null) {
                    menuItemPeer.setLabel(this.label);
                }
            }
        }
    }

    void doMenuEvent() {
        Toolkit.getEventQueue().postEvent(new ActionEvent(this, 1001, this.getActionCommand()));
    }

    boolean handleShortcut(KeyEvent keyEvent) {
        MenuShortcut menuShortcut = new MenuShortcut(keyEvent.getKeyCode(), (keyEvent.getModifiers() & 1) > 0);
        if (menuShortcut.equals(this.shortcut) && this.enabled) {
            if (keyEvent.getID() == 401) {
                this.doMenuEvent();
            }
            return true;
        }
        return false;
    }

    MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        return menuShortcut.equals(this.shortcut) ? this : null;
    }

    protected final void enableEvents(long l) {
        this.eventMask |= l;
        this.newEventsOnly = true;
    }

    protected final void disableEvents(long l) {
        this.eventMask &= l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand == null ? this.label : this.actionCommand;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public EventListener[] getListeners(Class clazz) {
        ActionListener actionListener = null;
        if (clazz == (class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = MenuItem.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener)) {
            actionListener = this.actionListener;
        }
        return AWTEventMulticaster.getListeners(actionListener, clazz);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        }
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 1001) {
            return (this.eventMask & 0x80L) != 0L || this.actionListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    public String paramString() {
        String string = ",label=" + this.label;
        if (this.shortcut != null) {
            string = string + ",shortcut=" + this.shortcut;
        }
        return super.paramString() + string;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "actionL", this.actionListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("actionL" == string) {
                this.addActionListener((ActionListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    private static native void initIDs();

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenuItem();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        MenuItem.initIDs();
        nameCounter = 0;
    }

    protected class AccessibleAWTMenuItem
    extends MenuComponent.AccessibleAWTMenuComponent
    implements AccessibleAction,
    AccessibleValue {
        protected AccessibleAWTMenuItem() {
            super(MenuItem.this);
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (MenuItem.this.getLabel() == null) {
                return super.getAccessibleName();
            }
            return MenuItem.this.getLabel();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_ITEM;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public String getAccessibleActionDescription(int n) {
            if (n == 0) {
                return new String("click");
            }
            return null;
        }

        public boolean doAccessibleAction(int n) {
            if (n == 0) {
                Toolkit.getEventQueue().postEvent(new ActionEvent(MenuItem.this, 1001, MenuItem.this.getActionCommand()));
                return true;
            }
            return false;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(0);
        }

        public boolean setCurrentAccessibleValue(Number number) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(0);
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(0);
        }
    }
}

