/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.peer.ScrollbarPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;

public class Scrollbar
extends Component
implements Adjustable,
Accessible {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    int value;
    int maximum;
    int minimum;
    int visibleAmount;
    int orientation;
    int lineIncrement = 1;
    int pageIncrement = 10;
    transient AdjustmentListener adjustmentListener;
    private static final String base = "scrollbar";
    private static int nameCounter = 0;
    private static final long serialVersionUID = 8451667562882310543L;
    private int scrollbarSerializedDataVersion = 1;
    static /* synthetic */ Class class$java$awt$event$AdjustmentListener;

    private static native void initIDs();

    public Scrollbar() {
        this(1, 0, 10, 0, 100);
    }

    public Scrollbar(int n) {
        this(n, 0, 10, 0, 100);
    }

    public Scrollbar(int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 0: 
            case 1: {
                this.orientation = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal scrollbar orientation");
            }
        }
        this.setValues(n2, n3, n4, n5);
    }

    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string = base + nameCounter++;
            return string;
        }
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createScrollbar(this);
            }
            super.addNotify();
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n == this.orientation) {
                return;
            }
            switch (n) {
                case 0: 
                case 1: {
                    this.orientation = n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal scrollbar orientation");
                }
            }
            if (this.peer != null) {
                this.removeNotify();
                this.addNotify();
                this.invalidate();
            }
        }
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", n == 1 ? AccessibleState.HORIZONTAL : AccessibleState.VERTICAL, n == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL);
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.setValues(n, this.visibleAmount, this.minimum, this.maximum);
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int n) {
        this.setValues(this.value, this.visibleAmount, n, this.maximum);
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int n) {
        this.setValues(this.value, this.visibleAmount, this.minimum, n);
    }

    public int getVisibleAmount() {
        return this.getVisible();
    }

    public int getVisible() {
        return this.visibleAmount;
    }

    public void setVisibleAmount(int n) {
        this.setValues(this.value, n, this.minimum, this.maximum);
    }

    public void setUnitIncrement(int n) {
        this.setLineIncrement(n);
    }

    public synchronized void setLineIncrement(int n) {
        this.lineIncrement = n;
        ScrollbarPeer scrollbarPeer = (ScrollbarPeer)this.peer;
        if (scrollbarPeer != null) {
            scrollbarPeer.setLineIncrement(n);
        }
    }

    public int getUnitIncrement() {
        return this.getLineIncrement();
    }

    public int getLineIncrement() {
        return this.lineIncrement;
    }

    public void setBlockIncrement(int n) {
        this.setPageIncrement(n);
    }

    public synchronized void setPageIncrement(int n) {
        this.pageIncrement = n;
        ScrollbarPeer scrollbarPeer = (ScrollbarPeer)this.peer;
        if (scrollbarPeer != null) {
            scrollbarPeer.setPageIncrement(n);
        }
    }

    public int getBlockIncrement() {
        return this.getPageIncrement();
    }

    public int getPageIncrement() {
        return this.pageIncrement;
    }

    public void setValues(int n, int n2, int n3, int n4) {
        int n5;
        Scrollbar scrollbar = this;
        synchronized (scrollbar) {
            if (n4 <= n3) {
                n4 = n3 + 1;
            }
            if (n2 > n4 - n3) {
                n2 = n4 - n3;
            }
            if (n2 < 1) {
                n2 = 1;
            }
            if (n < n3) {
                n = n3;
            }
            if (n > n4 - n2) {
                n = n4 - n2;
            }
            n5 = this.value;
            this.value = n;
            this.visibleAmount = n2;
            this.minimum = n3;
            this.maximum = n4;
            ScrollbarPeer scrollbarPeer = (ScrollbarPeer)this.peer;
            if (scrollbarPeer != null) {
                scrollbarPeer.setValues(n, this.visibleAmount, n3, n4);
            }
        }
        if (n5 != n && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(n5), new Integer(n));
        }
    }

    public synchronized void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, adjustmentListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, adjustmentListener);
    }

    public EventListener[] getListeners(Class clazz) {
        AdjustmentListener adjustmentListener = null;
        if (clazz != (class$java$awt$event$AdjustmentListener == null ? (class$java$awt$event$AdjustmentListener = Scrollbar.class$("java.awt.event.AdjustmentListener")) : class$java$awt$event$AdjustmentListener)) {
            return super.getListeners(clazz);
        }
        adjustmentListener = this.adjustmentListener;
        return AWTEventMulticaster.getListeners(adjustmentListener, clazz);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 601) {
            return (this.eventMask & 0x100L) != 0L || this.adjustmentListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        if (this.adjustmentListener != null) {
            this.adjustmentListener.adjustmentValueChanged(adjustmentEvent);
        }
    }

    protected String paramString() {
        return super.paramString() + ",val=" + this.value + ",vis=" + this.visibleAmount + ",min=" + this.minimum + ",max=" + this.maximum + (this.orientation == 1 ? ",vert" : ",horz");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "adjustmentL", this.adjustmentListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("adjustmentL" == string) {
                this.addAdjustmentListener((AdjustmentListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTScrollBar();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Scrollbar.initIDs();
    }

    protected class AccessibleAWTScrollBar
    extends Component.AccessibleAWTComponent
    implements AccessibleValue {
        protected AccessibleAWTScrollBar() {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (Scrollbar.this.getOrientation() == 1) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_BAR;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(Scrollbar.this.getValue());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                Scrollbar.this.setValue(number.intValue());
                return true;
            }
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(Scrollbar.this.getMinimum());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(Scrollbar.this.getMaximum());
        }
    }
}

