/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Event;
import java.awt.EventQueue;
import java.awt.FocusManager;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.im.InputContext;
import java.awt.peer.WindowPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import sun.awt.DebugHelper;
import sun.security.action.GetPropertyAction;

public class Window
extends Container
implements Accessible {
    String warningString;
    boolean nativeActive;
    static final int OPENED = 1;
    int state;
    transient Vector ownedWindowList = new Vector();
    private transient WeakReference weakThis;
    transient WindowListener windowListener;
    private transient boolean active = false;
    transient InputContext inputContext;
    private transient Object inputContextLock = new Object();
    private FocusManager focusMgr;
    private static final String base = "win";
    private static int nameCounter = 0;
    private static final long serialVersionUID = 4497834738069338734L;
    private static final DebugHelper dbg = DebugHelper.create(class$java$awt$Container == null ? (class$java$awt$Container = Window.class$("java.awt.Container")) : class$java$awt$Container);
    private int windowSerializedDataVersion = 1;
    static /* synthetic */ Class class$java$awt$Container;
    static /* synthetic */ Class class$java$awt$event$WindowListener;

    private static native void initIDs();

    Window(GraphicsConfiguration graphicsConfiguration) {
        this.setWarningString();
        this.cursor = Cursor.getPredefinedCursor(0);
        this.focusMgr = new FocusManager(this);
        this.visible = false;
        this.graphicsConfig = graphicsConfiguration == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration() : graphicsConfiguration;
        if (this.graphicsConfig.getDevice().getType() != 0) {
            throw new IllegalArgumentException("not a screen device");
        }
        this.setLayout(new BorderLayout());
        Rectangle rectangle = this.graphicsConfig.getBounds();
        int n = this.getX() + rectangle.x;
        int n2 = this.getY() + rectangle.y;
        this.setLocation(n, n2);
    }

    Window() {
        this((GraphicsConfiguration)null);
    }

    public Window(Frame frame) {
        this((GraphicsConfiguration)null);
        this.ownedInit(frame);
    }

    public Window(Window window) {
        this((GraphicsConfiguration)null);
        this.ownedInit(window);
    }

    public Window(Window window, GraphicsConfiguration graphicsConfiguration) {
        this(graphicsConfiguration);
        this.ownedInit(window);
    }

    private void ownedInit(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("null owner window");
        }
        this.parent = window;
        this.weakThis = new WeakReference(this);
        window.addOwnedWindow(this.weakThis);
    }

    protected void finalize() throws Throwable {
        if (this.parent != null) {
            ((Window)this.parent).removeOwnedWindow(this.weakThis);
        }
        super.finalize();
    }

    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string = base + nameCounter++;
            return string;
        }
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Container container = this.parent;
            if (container != null && container.getPeer() == null) {
                container.addNotify();
            }
            if (this.peer == null) {
                this.peer = this.getToolkit().createWindow(this);
            }
            super.addNotify();
        }
    }

    public void pack() {
        Container container = this.parent;
        Object object = this.getTreeLock();
        synchronized (object) {
            if (container != null && container.getPeer() == null) {
                container.addNotify();
            }
            if (this.peer == null) {
                this.addNotify();
            }
            this.setSize(this.getPreferredSize());
            this.isPacked = true;
            this.validate();
        }
    }

    public void show() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.addNotify();
            }
            this.validate();
        }
        if (this.visible) {
            this.toFront();
        } else {
            super.show();
        }
        if ((this.state & 1) == 0) {
            this.postWindowEvent(200);
            this.state |= 1;
        }
    }

    synchronized void postWindowEvent(int n) {
        WindowEvent windowEvent = new WindowEvent(this, n);
        Toolkit.getEventQueue().postEvent(windowEvent);
    }

    public void hide() {
        Vector vector = this.ownedWindowList;
        synchronized (vector) {
            int n = 0;
            while (n < this.ownedWindowList.size()) {
                Window window = (Window)((WeakReference)this.ownedWindowList.elementAt(n)).get();
                if (window != null) {
                    window.hide();
                }
                ++n;
            }
        }
        super.hide();
    }

    public void dispose() {
        class DisposeAction
        implements Runnable {
            private final /* synthetic */ Window this$0;

            DisposeAction(Window window) {
                this.this$0 = window;
            }

            public void run() {
                Vector vector = this.this$0.ownedWindowList;
                synchronized (vector) {
                    int n = 0;
                    while (n < this.this$0.ownedWindowList.size()) {
                        Window window = (Window)((WeakReference)this.this$0.ownedWindowList.elementAt(n)).get();
                        if (window != null) {
                            window.dispose();
                        }
                        ++n;
                    }
                }
                this.this$0.hide();
                this.this$0.removeNotify();
                Object object = Window.access$000(this.this$0);
                synchronized (object) {
                    if (this.this$0.inputContext != null) {
                        this.this$0.inputContext.dispose();
                        this.this$0.inputContext = null;
                    }
                }
            }
        }
        DisposeAction disposeAction = new DisposeAction(this);
        if (EventQueue.isDispatchThread()) {
            disposeAction.run();
        } else {
            try {
                EventQueue.invokeAndWait(disposeAction);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Disposal was interrupted:");
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("Exception during disposal:");
                invocationTargetException.printStackTrace();
            }
        }
        this.postWindowEvent(202);
    }

    void adjustListeningChildren(long l, int n) {
        if (n == 0) {
            return;
        }
        if ((l & 0x8000L) != 0L) {
            this.listeningChildren += n;
        }
        if ((l & 0x10000L) != 0L) {
            this.listeningBoundsChildren += n;
        }
    }

    public void toFront() {
        WindowPeer windowPeer = (WindowPeer)this.peer;
        if (windowPeer != null) {
            windowPeer.toFront();
        }
    }

    public void toBack() {
        WindowPeer windowPeer = (WindowPeer)this.peer;
        if (windowPeer != null) {
            windowPeer.toBack();
        }
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public final String getWarningString() {
        return this.warningString;
    }

    private void setWarningString() {
        this.warningString = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && !securityManager.checkTopLevelWindow(this)) {
            this.warningString = (String)AccessController.doPrivileged(new GetPropertyAction("awt.appletWarning", "Java Applet Window"));
        }
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public InputContext getInputContext() {
        if (this.inputContext == null) {
            Object object = this.inputContextLock;
            synchronized (object) {
                if (this.inputContext == null) {
                    this.inputContext = InputContext.getInstance();
                }
            }
        }
        return this.inputContext;
    }

    public void setCursor(Cursor cursor) {
        if (cursor == null) {
            cursor = Cursor.getPredefinedCursor(0);
        }
        super.setCursor(cursor);
    }

    public Window getOwner() {
        return (Window)this.parent;
    }

    public Window[] getOwnedWindows() {
        Window[] windowArray;
        Vector vector = this.ownedWindowList;
        synchronized (vector) {
            int n = this.ownedWindowList.size();
            int n2 = 0;
            Window[] windowArray2 = new Window[n];
            int n3 = 0;
            while (n3 < n) {
                windowArray2[n2] = (Window)((WeakReference)this.ownedWindowList.elementAt(n3)).get();
                if (windowArray2[n2] != null) {
                    ++n2;
                }
                ++n3;
            }
            if (n != n2) {
                windowArray = new Window[n2];
                System.arraycopy(windowArray2, 0, windowArray, 0, n2);
            } else {
                windowArray = windowArray2;
            }
        }
        return windowArray;
    }

    public synchronized void addWindowListener(WindowListener windowListener) {
        if (windowListener == null) {
            return;
        }
        this.windowListener = AWTEventMulticaster.add(this.windowListener, windowListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeWindowListener(WindowListener windowListener) {
        if (windowListener == null) {
            return;
        }
        this.windowListener = AWTEventMulticaster.remove(this.windowListener, windowListener);
    }

    public EventListener[] getListeners(Class clazz) {
        WindowListener windowListener = null;
        if (clazz != (class$java$awt$event$WindowListener == null ? (class$java$awt$event$WindowListener = Window.class$("java.awt.event.WindowListener")) : class$java$awt$event$WindowListener)) {
            return super.getListeners(clazz);
        }
        windowListener = this.windowListener;
        return AWTEventMulticaster.getListeners(windowListener, clazz);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        switch (aWTEvent.id) {
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: {
                return (this.eventMask & 0x40L) != 0L || this.windowListener != null;
            }
        }
        return super.eventEnabled(aWTEvent);
    }

    boolean isActive() {
        return this.active;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof WindowEvent) {
            this.processWindowEvent((WindowEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (this.windowListener != null) {
            switch (windowEvent.getID()) {
                case 200: {
                    this.windowListener.windowOpened(windowEvent);
                    break;
                }
                case 201: {
                    this.windowListener.windowClosing(windowEvent);
                    break;
                }
                case 202: {
                    this.windowListener.windowClosed(windowEvent);
                    break;
                }
                case 203: {
                    this.windowListener.windowIconified(windowEvent);
                    break;
                }
                case 204: {
                    this.windowListener.windowDeiconified(windowEvent);
                    break;
                }
                case 205: {
                    this.windowListener.windowActivated(windowEvent);
                    break;
                }
                case 206: {
                    this.windowListener.windowDeactivated(windowEvent);
                    break;
                }
            }
        }
    }

    void preProcessKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isActionKey() && keyEvent.getKeyCode() == 112 && keyEvent.isControlDown() && keyEvent.isShiftDown() && keyEvent.getID() == 401) {
            this.list(System.out, 0);
        }
    }

    void postProcessKeyEvent(KeyEvent keyEvent) {
        WindowPeer windowPeer = (WindowPeer)this.peer;
        if (windowPeer == null) {
            return;
        }
        switch (windowPeer.handleFocusTraversalEvent(keyEvent)) {
            default: {
                break;
            }
            case 1: {
                keyEvent.consume();
                break;
            }
            case 2: {
                if (!this.focusMgr.focusNext()) break;
                keyEvent.consume();
                break;
            }
            case 3: {
                if (!this.focusMgr.focusPrevious()) break;
                keyEvent.consume();
            }
        }
    }

    void setFocusOwner(Component component) {
        this.focusMgr.setFocusOwner(component);
    }

    void transferFocus(Component component) {
        this.nextFocus(component);
    }

    public Component getFocusOwner() {
        if (this.active || this.nativeActive) {
            return this.focusMgr.getFocusOwner();
        }
        return null;
    }

    void nextFocus(Component component) {
        this.focusMgr.focusNext(component);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        switch (aWTEvent.getID()) {
            case 1004: {
                this.setFocusOwner(this);
                break;
            }
            case 101: {
                this.invalidate();
                Object object = this.getTreeLock();
                synchronized (object) {
                    this.validate();
                }
                this.repaint();
                break;
            }
            case 205: {
                this.active = true;
                break;
            }
            case 206: {
                this.active = false;
                break;
            }
        }
        super.dispatchEventImpl(aWTEvent);
    }

    public boolean postEvent(Event event) {
        if (this.handleEvent(event)) {
            event.consume();
            return true;
        }
        return false;
    }

    public boolean isShowing() {
        return this.visible;
    }

    public void applyResourceBundle(ResourceBundle resourceBundle) {
        this.applyOrientation(ComponentOrientation.getOrientation(resourceBundle));
    }

    public void applyResourceBundle(String string) {
        this.applyResourceBundle(ResourceBundle.getBundle(string));
    }

    void addOwnedWindow(WeakReference weakReference) {
        if (weakReference != null) {
            Vector vector = this.ownedWindowList;
            synchronized (vector) {
                if (!this.ownedWindowList.contains(weakReference)) {
                    this.ownedWindowList.addElement(weakReference);
                }
            }
        }
    }

    void removeOwnedWindow(WeakReference weakReference) {
        if (weakReference != null) {
            this.ownedWindowList.removeElement(weakReference);
        }
    }

    void connectOwnedWindow(Window window) {
        WeakReference weakReference;
        window.weakThis = weakReference = new WeakReference(window);
        window.parent = this;
        this.addOwnedWindow(weakReference);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "windowL", this.windowListener);
        objectOutputStream.writeObject(null);
        Vector vector = this.ownedWindowList;
        synchronized (vector) {
            int n = 0;
            while (n < this.ownedWindowList.size()) {
                Window window = (Window)((WeakReference)this.ownedWindowList.elementAt(n)).get();
                if (window != null) {
                    objectOutputStream.writeObject("ownedL");
                    objectOutputStream.writeObject(window);
                }
                ++n;
            }
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        String string;
        Object object;
        objectInputStream.defaultReadObject();
        this.ownedWindowList = new Vector();
        while (null != (object = objectInputStream.readObject())) {
            string = ((String)object).intern();
            if ("windowL" == string) {
                this.addWindowListener((WindowListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
        try {
            while (null != (object = objectInputStream.readObject())) {
                string = ((String)object).intern();
                if ("ownedL" == string) {
                    this.connectOwnedWindow((Window)objectInputStream.readObject());
                    continue;
                }
                objectInputStream.readObject();
            }
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
        this.setWarningString();
        this.inputContextLock = new Object();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTWindow();
        }
        return this.accessibleContext;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.graphicsConfig == null) {
                this.graphicsConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            }
            GraphicsConfiguration graphicsConfiguration = this.graphicsConfig;
            return graphicsConfiguration;
        }
    }

    void resetGC() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.graphicsConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ Object access$000(Window window) {
        return window.inputContextLock;
    }

    static {
        Window.initIDs();
    }

    protected class AccessibleAWTWindow
    extends Container.AccessibleAWTContainer {
        protected AccessibleAWTWindow() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.WINDOW;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (Window.this.getFocusOwner() != null) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            return accessibleStateSet;
        }
    }
}

