/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;

public class DragSource {
    public static final Cursor DefaultCopyDrop = DragSource.load("DnD.Cursor.CopyDrop");
    public static final Cursor DefaultMoveDrop = DragSource.load("DnD.Cursor.MoveDrop");
    public static final Cursor DefaultLinkDrop = DragSource.load("DnD.Cursor.LinkDrop");
    public static final Cursor DefaultCopyNoDrop = DragSource.load("DnD.Cursor.CopyNoDrop");
    public static final Cursor DefaultMoveNoDrop = DragSource.load("DnD.Cursor.MoveNoDrop");
    public static final Cursor DefaultLinkNoDrop = DragSource.load("DnD.Cursor.LinkNoDrop");
    private static final FlavorMap defaultFlavorMap = SystemFlavorMap.getDefaultFlavorMap();
    private static DragSource dflt;
    private transient FlavorMap flavorMap = defaultFlavorMap;
    static /* synthetic */ Class class$java$awt$dnd$MouseDragGestureRecognizer;

    private static Cursor load(String string) {
        try {
            return (Cursor)Toolkit.getDefaultToolkit().getDesktopProperty(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("failed to load system cursor: " + string + " : " + exception.getMessage());
        }
    }

    public static DragSource getDefaultDragSource() {
        if (dflt == null) {
            dflt = new DragSource();
        }
        return dflt;
    }

    public static boolean isDragImageSupported() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.isDragImageSupported");
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void startDrag(DragGestureEvent dragGestureEvent, Cursor cursor, Image image, Point point, Transferable transferable, DragSourceListener dragSourceListener, FlavorMap flavorMap) throws InvalidDnDOperationException {
        DragSourceContextPeer dragSourceContextPeer;
        DragSourceContext dragSourceContext;
        if (flavorMap != null) {
            this.flavorMap = flavorMap;
        }
        if ((dragSourceContext = this.createDragSourceContext(dragSourceContextPeer = Toolkit.getDefaultToolkit().createDragSourceContextPeer(dragGestureEvent), dragGestureEvent, cursor, image, point, transferable, dragSourceListener)) == null) {
            throw new InvalidDnDOperationException();
        }
        dragSourceContextPeer.startDrag(dragSourceContext, dragSourceContext.getCursor(), image, point);
    }

    public void startDrag(DragGestureEvent dragGestureEvent, Cursor cursor, Transferable transferable, DragSourceListener dragSourceListener, FlavorMap flavorMap) throws InvalidDnDOperationException {
        this.startDrag(dragGestureEvent, cursor, null, null, transferable, dragSourceListener, flavorMap);
    }

    public void startDrag(DragGestureEvent dragGestureEvent, Cursor cursor, Image image, Point point, Transferable transferable, DragSourceListener dragSourceListener) throws InvalidDnDOperationException {
        this.startDrag(dragGestureEvent, cursor, image, point, transferable, dragSourceListener, null);
    }

    public void startDrag(DragGestureEvent dragGestureEvent, Cursor cursor, Transferable transferable, DragSourceListener dragSourceListener) throws InvalidDnDOperationException {
        this.startDrag(dragGestureEvent, cursor, null, null, transferable, dragSourceListener, null);
    }

    protected DragSourceContext createDragSourceContext(DragSourceContextPeer dragSourceContextPeer, DragGestureEvent dragGestureEvent, Cursor cursor, Image image, Point point, Transferable transferable, DragSourceListener dragSourceListener) {
        return new DragSourceContext(dragSourceContextPeer, dragGestureEvent, cursor, image, point, transferable, dragSourceListener);
    }

    public FlavorMap getFlavorMap() {
        return this.flavorMap;
    }

    public DragGestureRecognizer createDragGestureRecognizer(Class clazz, Component component, int n, DragGestureListener dragGestureListener) {
        return Toolkit.getDefaultToolkit().createDragGestureRecognizer(clazz, this, component, n, dragGestureListener);
    }

    public DragGestureRecognizer createDefaultDragGestureRecognizer(Component component, int n, DragGestureListener dragGestureListener) {
        return Toolkit.getDefaultToolkit().createDragGestureRecognizer(class$java$awt$dnd$MouseDragGestureRecognizer == null ? (class$java$awt$dnd$MouseDragGestureRecognizer = DragSource.class$("java.awt.dnd.MouseDragGestureRecognizer")) : class$java$awt$dnd$MouseDragGestureRecognizer, this, component, n, dragGestureListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

