/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;

public class MouseEvent
extends InputEvent {
    public static final int MOUSE_FIRST = 500;
    public static final int MOUSE_LAST = 506;
    public static final int MOUSE_CLICKED = 500;
    public static final int MOUSE_PRESSED = 501;
    public static final int MOUSE_RELEASED = 502;
    public static final int MOUSE_MOVED = 503;
    public static final int MOUSE_ENTERED = 504;
    public static final int MOUSE_EXITED = 505;
    public static final int MOUSE_DRAGGED = 506;
    int x;
    int y;
    int clickCount;
    boolean popupTrigger = false;
    private static final long serialVersionUID = -991214153494842848L;

    private static native void initIDs();

    public MouseEvent(Component component, int n, long l, int n2, int n3, int n4, int n5, boolean bl) {
        super(component, n, l, n2);
        this.x = n3;
        this.y = n4;
        this.clickCount = n5;
        this.popupTrigger = bl;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Point getPoint() {
        int n;
        int n2;
        MouseEvent mouseEvent = this;
        synchronized (mouseEvent) {
            n2 = this.x;
            n = this.y;
        }
        return new Point(n2, n);
    }

    public synchronized void translatePoint(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public boolean isPopupTrigger() {
        return this.popupTrigger;
    }

    public String paramString() {
        String string;
        switch (this.id) {
            case 501: {
                string = "MOUSE_PRESSED";
                break;
            }
            case 502: {
                string = "MOUSE_RELEASED";
                break;
            }
            case 500: {
                string = "MOUSE_CLICKED";
                break;
            }
            case 504: {
                string = "MOUSE_ENTERED";
                break;
            }
            case 505: {
                string = "MOUSE_EXITED";
                break;
            }
            case 503: {
                string = "MOUSE_MOVED";
                break;
            }
            case 506: {
                string = "MOUSE_DRAGGED";
                break;
            }
            default: {
                string = "unknown type";
            }
        }
        return string + ",(" + this.x + "," + this.y + ")" + ",mods=" + this.getModifiers() + ",clickCount=" + this.clickCount;
    }

    static {
        MouseEvent.initIDs();
    }
}

