/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.LookupTable;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.ShortLookupTable;
import java.awt.image.WritableRaster;
import sun.awt.image.ImagingLib;

public class LookupOp
implements BufferedImageOp,
RasterOp {
    private LookupTable ltable;
    private int numComponents;
    RenderingHints hints;

    public LookupOp(LookupTable lookupTable, RenderingHints renderingHints) {
        this.ltable = lookupTable;
        this.hints = renderingHints;
        this.numComponents = this.ltable.getNumComponents();
    }

    public final LookupTable getTable() {
        return this.ltable;
    }

    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Object object;
        ColorModel colorModel;
        ColorModel colorModel2 = bufferedImage.getColorModel();
        int n = colorModel2.getNumColorComponents();
        if (colorModel2 instanceof IndexColorModel) {
            throw new IllegalArgumentException("LookupOp cannot be performed on an indexed image");
        }
        int n2 = this.ltable.getNumComponents();
        if (n2 != 1 && n2 != colorModel2.getNumComponents() && n2 != colorModel2.getNumColorComponents()) {
            throw new IllegalArgumentException("Number of arrays in the  lookup table (" + n2 + " is not compatible with the " + " src image: " + bufferedImage);
        }
        boolean bl = false;
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            colorModel = colorModel2;
        } else {
            if (n3 != bufferedImage2.getWidth()) {
                throw new IllegalArgumentException("Src width (" + n3 + ") not equal to dst width (" + bufferedImage2.getWidth() + ")");
            }
            if (n4 != bufferedImage2.getHeight()) {
                throw new IllegalArgumentException("Src height (" + n4 + ") not equal to dst height (" + bufferedImage2.getHeight() + ")");
            }
            colorModel = bufferedImage2.getColorModel();
            if (colorModel2.getColorSpace().getType() != colorModel.getColorSpace().getType()) {
                bl = true;
                bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            }
        }
        BufferedImage bufferedImage3 = bufferedImage2;
        if (ImagingLib.filter(this, bufferedImage, bufferedImage2) == null) {
            int n5;
            int n6;
            object = bufferedImage.getRaster();
            WritableRaster writableRaster = bufferedImage2.getRaster();
            if (colorModel2.hasAlpha() && (n - 1 == n2 || n2 == 1)) {
                n6 = ((Raster)object).getMinX();
                n5 = ((Raster)object).getMinY();
                int[] nArray = new int[n - 1];
                int n7 = 0;
                while (n7 < n - 1) {
                    nArray[n7] = n7;
                    ++n7;
                }
                object = ((WritableRaster)object).createWritableChild(n6, n5, ((Raster)object).getWidth(), ((Raster)object).getHeight(), n6, n5, nArray);
            }
            if (colorModel.hasAlpha() && ((n6 = writableRaster.getNumBands()) - 1 == n2 || n2 == 1)) {
                n5 = writableRaster.getMinX();
                int n8 = writableRaster.getMinY();
                int[] nArray = new int[n - 1];
                int n9 = 0;
                while (n9 < n - 1) {
                    nArray[n9] = n9;
                    ++n9;
                }
                writableRaster = writableRaster.createWritableChild(n5, n8, writableRaster.getWidth(), writableRaster.getHeight(), n5, n8, nArray);
            }
            this.filter((Raster)object, writableRaster);
        }
        if (bl) {
            object = new ColorConvertOp(this.hints);
            ((ColorConvertOp)object).filter(bufferedImage2, bufferedImage3);
        }
        return bufferedImage3;
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        int n = raster.getNumBands();
        int n2 = writableRaster.getNumBands();
        int n3 = raster.getHeight();
        int n4 = raster.getWidth();
        int[] nArray = new int[n];
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else if (n3 != writableRaster.getHeight() || n4 != writableRaster.getWidth()) {
            throw new IllegalArgumentException("Width or height of Rasters do not match");
        }
        n2 = writableRaster.getNumBands();
        if (n != n2) {
            throw new IllegalArgumentException("Number of channels in the src (" + n + ") does not match number of channels" + " in the destination (" + n2 + ")");
        }
        int n5 = this.ltable.getNumComponents();
        if (n5 != 1 && n5 != raster.getNumBands()) {
            throw new IllegalArgumentException("Number of arrays in the  lookup table (" + n5 + " is not compatible with the " + " src Raster: " + raster);
        }
        if (ImagingLib.filter(this, raster, writableRaster) != null) {
            return writableRaster;
        }
        if (this.ltable instanceof ByteLookupTable) {
            this.byteFilter((ByteLookupTable)this.ltable, raster, writableRaster, n4, n3, n);
        } else if (this.ltable instanceof ShortLookupTable) {
            this.shortFilter((ShortLookupTable)this.ltable, raster, writableRaster, n4, n3, n);
        } else {
            int n6 = raster.getMinX();
            int n7 = raster.getMinY();
            int n8 = writableRaster.getMinX();
            int n9 = writableRaster.getMinY();
            int n10 = 0;
            while (n10 < n3) {
                int n11 = n6;
                int n12 = n8;
                int n13 = 0;
                while (n13 < n4) {
                    raster.getPixel(n11, n7, nArray);
                    this.ltable.lookupPixel(nArray, nArray);
                    writableRaster.setPixel(n12, n9, nArray);
                    ++n13;
                    ++n11;
                    ++n12;
                }
                ++n10;
                ++n7;
                ++n9;
            }
        }
        return writableRaster;
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return this.getBounds2D(bufferedImage.getRaster());
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        BufferedImage bufferedImage2;
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = 0;
        if (colorModel == null) {
            ColorModel colorModel2 = bufferedImage.getColorModel();
            WritableRaster writableRaster = bufferedImage.getRaster();
            if (colorModel2 instanceof ComponentColorModel) {
                DataBuffer dataBuffer = writableRaster.getDataBuffer();
                boolean bl = colorModel2.hasAlpha();
                boolean bl2 = colorModel2.isAlphaPremultiplied();
                int n4 = colorModel2.getTransparency();
                int[] nArray = null;
                if (this.ltable instanceof ByteLookupTable) {
                    if (dataBuffer.getDataType() == 1) {
                        if (bl) {
                            nArray = new int[2];
                            nArray[1] = n4 == 2 ? 1 : 8;
                        } else {
                            nArray = new int[]{8};
                        }
                    }
                } else if (this.ltable instanceof ShortLookupTable) {
                    n3 = 1;
                    if (dataBuffer.getDataType() == 0) {
                        if (bl) {
                            nArray = new int[2];
                            nArray[1] = n4 == 2 ? 1 : 16;
                        } else {
                            nArray = new int[]{16};
                        }
                    }
                }
                if (nArray != null) {
                    colorModel2 = new ComponentColorModel(colorModel2.getColorSpace(), nArray, bl, bl2, n4, n3);
                }
            }
            bufferedImage2 = new BufferedImage(colorModel2, colorModel2.createCompatibleWritableRaster(n, n2), colorModel2.isAlphaPremultiplied(), null);
        } else {
            bufferedImage2 = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied(), null);
        }
        return bufferedImage2;
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return raster.createCompatibleWritableRaster();
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    private final void byteFilter(ByteLookupTable byteLookupTable, Raster raster, WritableRaster writableRaster, int n, int n2, int n3) {
        int[] nArray = null;
        byte[][] byArray = byteLookupTable.getTable();
        int n4 = byteLookupTable.getOffset();
        int n5 = 1;
        if (byArray.length == 1) {
            n5 = 0;
        }
        int n6 = byArray[0].length;
        int n7 = 0;
        while (n7 < n2) {
            int n8 = 0;
            int n9 = 0;
            while (n9 < n3) {
                nArray = raster.getSamples(0, n7, n, 1, n9, nArray);
                int n10 = 0;
                while (n10 < n) {
                    int n11 = nArray[n10] - n4;
                    if (n11 < 0 || n11 > n6) {
                        throw new IllegalArgumentException("index (" + n11 + "(out of range: " + " srcPix[" + n10 + "]=" + nArray[n10] + " offset=" + n4);
                    }
                    nArray[n10] = byArray[n8][n11];
                    ++n10;
                }
                writableRaster.setSamples(0, n7, n, 1, n9, nArray);
                ++n9;
                n8 += n5;
            }
            ++n7;
        }
    }

    private final void shortFilter(ShortLookupTable shortLookupTable, Raster raster, WritableRaster writableRaster, int n, int n2, int n3) {
        int[] nArray = null;
        short[][] sArray = shortLookupTable.getTable();
        int n4 = shortLookupTable.getOffset();
        int n5 = 1;
        if (sArray.length == 1) {
            n5 = 0;
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 65535;
        n7 = 0;
        while (n7 < n2) {
            int n9 = 0;
            int n10 = 0;
            while (n10 < n3) {
                nArray = raster.getSamples(0, n7, n, 1, n10, nArray);
                n6 = 0;
                while (n6 < n) {
                    int n11 = nArray[n6] - n4;
                    if (n11 < 0 || n11 > n8) {
                        throw new IllegalArgumentException("index out of range " + n11 + " x is " + n6 + "srcPix[x]=" + nArray[n6] + " offset=" + n4);
                    }
                    nArray[n6] = sArray[n9][n11];
                    ++n6;
                }
                writableRaster.setSamples(0, n7, n, 1, n10, nArray);
                ++n10;
                n9 += n5;
            }
            ++n7;
        }
    }
}

