/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.util.Hashtable;

public class ReplicateScaleFilter
extends ImageFilter {
    protected int srcWidth;
    protected int srcHeight;
    protected int destWidth;
    protected int destHeight;
    protected int[] srcrows;
    protected int[] srccols;
    protected Object outpixbuf;

    public ReplicateScaleFilter(int n, int n2) {
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("Width (" + n + ") and height (" + n2 + ") must be non-zero");
        }
        this.destWidth = n;
        this.destHeight = n2;
    }

    public void setProperties(Hashtable hashtable) {
        hashtable = (Hashtable)hashtable.clone();
        String string = "rescale";
        String string2 = this.destWidth + "x" + this.destHeight;
        Object object = hashtable.get(string);
        if (object != null && object instanceof String) {
            string2 = (String)object + ", " + string2;
        }
        hashtable.put(string, string2);
        super.setProperties(hashtable);
    }

    public void setDimensions(int n, int n2) {
        this.srcWidth = n;
        this.srcHeight = n2;
        if (this.destWidth < 0) {
            if (this.destHeight < 0) {
                this.destWidth = this.srcWidth;
                this.destHeight = this.srcHeight;
            } else {
                this.destWidth = this.srcWidth * this.destHeight / this.srcHeight;
            }
        } else if (this.destHeight < 0) {
            this.destHeight = this.srcHeight * this.destWidth / this.srcWidth;
        }
        this.consumer.setDimensions(this.destWidth, this.destHeight);
    }

    private void calculateMaps() {
        this.srcrows = new int[this.destHeight + 1];
        int n = 0;
        while (n <= this.destHeight) {
            this.srcrows[n] = (2 * n * this.srcHeight + this.srcHeight) / (2 * this.destHeight);
            ++n;
        }
        this.srccols = new int[this.destWidth + 1];
        int n2 = 0;
        while (n2 <= this.destWidth) {
            this.srccols[n2] = (2 * n2 * this.srcWidth + this.srcWidth) / (2 * this.destWidth);
            ++n2;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7;
        byte[] byArray2;
        if (this.srcrows == null || this.srccols == null) {
            this.calculateMaps();
        }
        int n8 = (2 * n * this.destWidth + this.srcWidth - 1) / (2 * this.srcWidth);
        int n9 = (2 * n2 * this.destHeight + this.srcHeight - 1) / (2 * this.srcHeight);
        if (this.outpixbuf != null && this.outpixbuf instanceof byte[]) {
            byArray2 = (byte[])this.outpixbuf;
        } else {
            byArray2 = new byte[this.destWidth];
            this.outpixbuf = byArray2;
        }
        int n10 = n9;
        while ((n7 = this.srcrows[n10]) < n2 + n4) {
            int n11;
            int n12 = n5 + n6 * (n7 - n2);
            int n13 = n8;
            while ((n11 = this.srccols[n13]) < n + n3) {
                byArray2[n13] = byArray[n12 + n11 - n];
                ++n13;
            }
            if (n13 > n8) {
                this.consumer.setPixels(n8, n10, n13 - n8, 1, colorModel, byArray2, n8, this.destWidth);
            }
            ++n10;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7;
        int[] nArray2;
        if (this.srcrows == null || this.srccols == null) {
            this.calculateMaps();
        }
        int n8 = (2 * n * this.destWidth + this.srcWidth - 1) / (2 * this.srcWidth);
        int n9 = (2 * n2 * this.destHeight + this.srcHeight - 1) / (2 * this.srcHeight);
        if (this.outpixbuf != null && this.outpixbuf instanceof int[]) {
            nArray2 = (int[])this.outpixbuf;
        } else {
            nArray2 = new int[this.destWidth];
            this.outpixbuf = nArray2;
        }
        int n10 = n9;
        while ((n7 = this.srcrows[n10]) < n2 + n4) {
            int n11;
            int n12 = n5 + n6 * (n7 - n2);
            int n13 = n8;
            while ((n11 = this.srccols[n13]) < n + n3) {
                nArray2[n13] = nArray[n12 + n11 - n];
                ++n13;
            }
            if (n13 > n8) {
                this.consumer.setPixels(n8, n10, n13 - n8, 1, colorModel, nArray2, n8, this.destWidth);
            }
            ++n10;
        }
    }
}

