/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;

public class FileOutputStream
extends OutputStream {
    private FileDescriptor fd;

    public FileOutputStream(String string) throws FileNotFoundException {
        this(string, false);
    }

    public FileOutputStream(String string, boolean bl) throws FileNotFoundException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(string);
        }
        this.fd = new FileDescriptor();
        if (bl) {
            this.openAppend(string);
        } else {
            this.open(string);
        }
    }

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file.getPath());
    }

    public FileOutputStream(FileDescriptor fileDescriptor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        if (securityManager != null) {
            securityManager.checkWrite(fileDescriptor);
        }
        this.fd = fileDescriptor;
    }

    private native void open(String var1) throws FileNotFoundException;

    private native void openAppend(String var1) throws FileNotFoundException;

    public native void write(int var1) throws IOException;

    private native void writeBytes(byte[] var1, int var2, int var3, FileDescriptor var4) throws IOException;

    public void write(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length, this.fd);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeBytes(byArray, n, n2, this.fd);
    }

    public native void close() throws IOException;

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void finalize() throws IOException {
        if (this.fd == null) return;
        if (this.fd != FileDescriptor.out) {
            if (this.fd != FileDescriptor.err) {
                this.close();
                return;
            }
        }
        this.flush();
    }

    private static native void initIDs();

    static {
        FileOutputStream.initIDs();
    }
}

