/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;

public final class Class
implements Serializable {
    private static boolean have_extensions = true;
    private static RuntimePermission getPDperm;
    private static ProtectionDomain allPermDomain;
    private static final long serialVersionUID = 3206093459760846163L;
    private static final ObjectStreamField[] serialPersistentFields;

    private static native void registerNatives();

    private Class() {
        have_extensions = Class.haveExtensions();
    }

    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    private static native Class forName1(String var0) throws ClassNotFoundException;

    private static native boolean haveExtensions();

    public static Class forName(String string) throws ClassNotFoundException {
        if (have_extensions) {
            return Class.forName1(string);
        }
        return Class.forName0(string, true, ClassLoader.getCallerClassLoader());
    }

    public static Class forName(String string, boolean bl, ClassLoader classLoader) throws ClassNotFoundException {
        ClassLoader classLoader2;
        SecurityManager securityManager;
        if (classLoader == null && (securityManager = System.getSecurityManager()) != null && (classLoader2 = ClassLoader.getCallerClassLoader()) != null) {
            securityManager.checkPermission(ClassLoader.getGetClassLoaderPerm());
        }
        return Class.forName0(string, bl, classLoader);
    }

    private static native Class forName0(String var0, boolean var1, ClassLoader var2) throws ClassNotFoundException;

    public Object newInstance() throws InstantiationException, IllegalAccessException {
        if (System.getSecurityManager() != null) {
            this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        }
        return this.newInstance0();
    }

    private native Object newInstance0() throws InstantiationException, IllegalAccessException;

    private Object newInstance1(Class clazz, ClassLoader classLoader) throws InstantiationException, IllegalAccessException {
        if (System.getSecurityManager() != null) {
            this.checkMemberAccess(0, classLoader);
        }
        return this.newInstance2(clazz);
    }

    private native Object newInstance2(Class var1) throws InstantiationException, IllegalAccessException;

    public native boolean isInstance(Object var1);

    public native boolean isAssignableFrom(Class var1);

    public native boolean isInterface();

    public native boolean isArray();

    public native boolean isPrimitive();

    public native String getName();

    public ClassLoader getClassLoader() {
        ClassLoader classLoader;
        ClassLoader classLoader2 = this.getClassLoader0();
        if (classLoader2 == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && classLoader != classLoader2 && !classLoader2.isAncestor(classLoader)) {
            securityManager.checkPermission(ClassLoader.getGetClassLoaderPerm());
        }
        return classLoader2;
    }

    private native ClassLoader getClassLoader0();

    public native Class getSuperclass();

    public Package getPackage() {
        return Package.getPackage(this);
    }

    public native Class[] getInterfaces();

    public native Class getComponentType();

    public native int getModifiers();

    public native Object[] getSigners();

    native void setSigners(Object[] var1);

    public native Class getDeclaringClass();

    public Class[] getClasses() {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        Class[] classArray = (Class[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ArrayList arrayList = new ArrayList();
                Class clazz = Class.this;
                while (clazz != null) {
                    Class[] classArray = clazz.getDeclaredClasses();
                    int n = 0;
                    while (n < classArray.length) {
                        if (Modifier.isPublic(classArray[n].getModifiers())) {
                            arrayList.add(classArray[n]);
                        }
                        ++n;
                    }
                    clazz = clazz.getSuperclass();
                }
                return arrayList.toArray(new Class[0]);
            }
        });
        return classArray;
    }

    public Field[] getFields() throws SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        return this.getFields0(0);
    }

    public Method[] getMethods() throws SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        return this.getMethods0(0);
    }

    public Constructor[] getConstructors() throws SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        return this.getConstructors0(0);
    }

    public Field getField(String string) throws NoSuchFieldException, SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        return this.getField0(string, 0);
    }

    public Method getMethod(String string, Class[] classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        return this.getMethod0(string, classArray, 0);
    }

    public Constructor getConstructor(Class[] classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        return this.getConstructor0(classArray, 0);
    }

    public Class[] getDeclaredClasses() throws SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return this.getDeclaredClasses0();
    }

    public Field[] getDeclaredFields() throws SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return this.getFields0(1);
    }

    public Method[] getDeclaredMethods() throws SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return this.getMethods0(1);
    }

    public Constructor[] getDeclaredConstructors() throws SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return this.getConstructors0(1);
    }

    public Field getDeclaredField(String string) throws NoSuchFieldException, SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return this.getField0(string, 1);
    }

    public Method getDeclaredMethod(String string, Class[] classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return this.getMethod0(string, classArray, 1);
    }

    public Constructor getDeclaredConstructor(Class[] classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return this.getConstructor0(classArray, 1);
    }

    public InputStream getResourceAsStream(String string) {
        string = this.resolveName(string);
        ClassLoader classLoader = this.getClassLoader0();
        if (classLoader == null) {
            return ClassLoader.getSystemResourceAsStream(string);
        }
        return classLoader.getResourceAsStream(string);
    }

    public URL getResource(String string) {
        string = this.resolveName(string);
        ClassLoader classLoader = this.getClassLoader0();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string);
        }
        return classLoader.getResource(string);
    }

    public ProtectionDomain getProtectionDomain() {
        ProtectionDomain protectionDomain;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (getPDperm == null) {
                getPDperm = new RuntimePermission("getProtectionDomain");
            }
            securityManager.checkPermission(getPDperm);
        }
        if ((protectionDomain = this.getProtectionDomain0()) == null) {
            if (allPermDomain == null) {
                Permissions permissions = new Permissions();
                permissions.add(new AllPermission());
                allPermDomain = new ProtectionDomain(null, permissions);
            }
            protectionDomain = allPermDomain;
        }
        return protectionDomain;
    }

    private native ProtectionDomain getProtectionDomain0();

    native void setProtectionDomain0(ProtectionDomain var1);

    static native Class getPrimitiveClass(String var0);

    private void checkMemberAccess(int n, ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            String string;
            int n2;
            securityManager.checkMemberAccess(this, n);
            ClassLoader classLoader2 = this.getClassLoader0();
            if (!(classLoader == null || classLoader == classLoader2 || classLoader2 != null && classLoader2.isAncestor(classLoader) || (n2 = (string = this.getName()).lastIndexOf(46)) == -1)) {
                securityManager.checkPackageAccess(string.substring(0, n2));
            }
        }
    }

    private String resolveName(String string) {
        if (string == null) {
            return string;
        }
        if (!string.startsWith("/")) {
            Class clazz = this;
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            String string2 = clazz.getName();
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                string = string2.substring(0, n).replace('.', '/') + "/" + string;
            }
        } else {
            string = string.substring(1);
        }
        return string;
    }

    private native Field[] getFields0(int var1);

    private native Method[] getMethods0(int var1);

    private native Constructor[] getConstructors0(int var1);

    private native Field getField0(String var1, int var2);

    private native Method getMethod0(String var1, Class[] var2, int var3);

    private native Constructor getConstructor0(Class[] var1, int var2);

    private native Class[] getDeclaredClasses0();

    static {
        Class.registerNatives();
        serialPersistentFields = ObjectStreamClass.NO_FIELDS;
    }
}

