/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jvm.ExtendedSystem;
import com.ibm.jvm.io.FileInputStream;
import com.ibm.jvm.io.FileOutputStream;
import com.ibm.jvm.io.LocalizedInputStream;
import com.ibm.jvm.io.LocalizedPrintStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.PropertyPermission;
import sun.net.InetAddressCachePolicy;

public final class System {
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;
    private static SecurityManager security;
    private static Properties props;

    private static native void registerNatives();

    private System() {
    }

    public static void setIn(InputStream inputStream) {
        System.checkIO();
        System.setIn0(inputStream);
        ExtendedSystem.setJVMUnresettableConditionally(64);
    }

    public static void setOut(PrintStream printStream) {
        System.checkIO();
        System.setOut0(printStream);
        ExtendedSystem.setJVMUnresettableConditionally(64);
    }

    public static void setErr(PrintStream printStream) {
        System.checkIO();
        System.setErr0(printStream);
        ExtendedSystem.setJVMUnresettableConditionally(64);
    }

    private static void checkIO() {
        if (security != null) {
            security.checkPermission(new RuntimePermission("setIO"));
        }
    }

    private static native void setIn0(InputStream var0);

    private static native void setOut0(PrintStream var0);

    private static native void setErr0(PrintStream var0);

    public static void setSecurityManager(SecurityManager securityManager) {
        try {
            securityManager.checkPackageAccess("java.lang");
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setSecurityManager0(securityManager);
        ExtendedSystem.setJVMUnresettableConditionally(8);
    }

    private static synchronized void setSecurityManager0(final SecurityManager securityManager) {
        if (security != null) {
            security.checkPermission(new RuntimePermission("setSecurityManager"));
        }
        if (securityManager != null && securityManager.getClass().getClassLoader() != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    securityManager.getClass().getProtectionDomain().implies(new AllPermission());
                    return null;
                }
            });
        }
        security = securityManager;
        InetAddressCachePolicy.setIfNotSet(-1);
    }

    public static SecurityManager getSecurityManager() {
        return security;
    }

    public static native long currentTimeMillis();

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    public static native int identityHashCode(Object var0);

    private static native Properties initProperties(Properties var0);

    public static Properties getProperties() {
        if (security != null) {
            security.checkPropertiesAccess();
        }
        ExtendedSystem.setJVMUnresettableConditionally(32);
        return props;
    }

    public static void setProperties(Properties properties) {
        if (security != null) {
            security.checkPropertiesAccess();
        }
        if (properties == null) {
            properties = new Properties();
            System.initProperties(properties);
        }
        props = properties;
        ExtendedSystem.setJVMUnresettableConditionally(32);
    }

    public static String getProperty(String string) {
        if (string == null) {
            throw new NullPointerException("key can't be null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("key can't be empty");
        }
        if (security != null) {
            security.checkPropertyAccess(string);
        }
        return props.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("key can't be null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("key can't be empty");
        }
        if (security != null) {
            security.checkPropertyAccess(string);
        }
        return props.getProperty(string, string2);
    }

    public static String setProperty(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("key can't be null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("key can't be empty");
        }
        if (security != null) {
            security.checkPermission(new PropertyPermission(string, "write"));
        }
        ExtendedSystem.setJVMUnresettableConditionally(32);
        return (String)props.setProperty(string, string2);
    }

    public static String getenv(String string) {
        throw new Error("getenv no longer supported, use properties and -D instead: " + string);
    }

    public static void exit(int n) {
        Runtime.getRuntime().exit(n);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    public static void runFinalizersOnExit(boolean bl) {
        Runtime.getRuntime();
        Runtime.runFinalizersOnExit(bl);
    }

    public static void load(String string) {
        Runtime.getRuntime().load0(System.getCallerClass(), string);
    }

    public static void loadLibrary(String string) {
        Runtime.getRuntime().loadLibrary0(System.getCallerClass(), string);
    }

    public static native String mapLibraryName(String var0);

    private static InputStream nullInputStream() throws NullPointerException {
        if (System.currentTimeMillis() > 0L) {
            return null;
        }
        throw new NullPointerException();
    }

    private static PrintStream nullPrintStream() throws NullPointerException {
        if (System.currentTimeMillis() > 0L) {
            return null;
        }
        throw new NullPointerException();
    }

    private static void initializeSystemClass() {
        props = new Properties();
        System.initProperties(props);
        FileInputStream fileInputStream = new FileInputStream(FileDescriptor.in);
        FileOutputStream fileOutputStream = new FileOutputStream(FileDescriptor.out);
        FileOutputStream fileOutputStream2 = new FileOutputStream(FileDescriptor.err);
        System.setIn0(LocalizedInputStream.localize(new BufferedInputStream(fileInputStream)));
        System.setOut0(LocalizedPrintStream.localize(new BufferedOutputStream(fileOutputStream, 128), true));
        System.setErr0(LocalizedPrintStream.localize(new BufferedOutputStream(fileOutputStream2, 128), true));
    }

    static native Class getCallerClass();

    static {
        System.registerNatives();
        in = System.nullInputStream();
        out = System.nullPrintStream();
        err = System.nullPrintStream();
        security = null;
    }
}

