/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.util.Vector;
import sun.security.util.Debug;

public final class AccessControlContext {
    private ProtectionDomain[] context;
    private boolean isPrivileged;
    private AccessControlContext privilegedContext;
    private DomainCombiner combiner;
    private static boolean debugInit = false;
    private static Debug debug = null;

    static Debug getDebug() {
        if (debugInit) {
            return debug;
        }
        if (Policy.isSet()) {
            debug = Debug.getInstance("access");
            debugInit = true;
        }
        return debug;
    }

    public AccessControlContext(ProtectionDomain[] protectionDomainArray) {
        if (protectionDomainArray.length == 1) {
            this.context = (ProtectionDomain[])protectionDomainArray.clone();
        } else {
            Vector vector = new Vector(protectionDomainArray.length);
            int n = 0;
            while (n < protectionDomainArray.length) {
                if (protectionDomainArray[n] != null) {
                    vector.addElement(protectionDomainArray[n]);
                }
                ++n;
            }
            this.context = new ProtectionDomain[vector.size()];
            vector.copyInto(this.context);
        }
    }

    public AccessControlContext(AccessControlContext accessControlContext, DomainCombiner domainCombiner) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("createAccessControlContext"));
        }
        if (accessControlContext == null || domainCombiner == null) {
            throw new NullPointerException("null AccessControlContext or DomainCombiner was provided");
        }
        this.context = accessControlContext.context;
        this.combiner = domainCombiner;
    }

    private AccessControlContext(ProtectionDomain[] protectionDomainArray, DomainCombiner domainCombiner) {
        this.context = (ProtectionDomain[])protectionDomainArray.clone();
        this.combiner = domainCombiner;
    }

    AccessControlContext(ProtectionDomain[] protectionDomainArray, boolean bl) {
        this.context = protectionDomainArray;
        this.isPrivileged = bl;
    }

    boolean isPrivileged() {
        return this.isPrivileged;
    }

    public DomainCombiner getDomainCombiner() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("getDomainCombiner"));
        }
        return this.combiner;
    }

    public void checkPermission(Permission permission) throws AccessControlException {
        int n;
        if (permission == null) {
            throw new NullPointerException("permission can't be null");
        }
        if (AccessControlContext.getDebug() != null) {
            if (Debug.isOn("stack")) {
                Thread.currentThread();
                Thread.dumpStack();
            }
            if (Debug.isOn("domain")) {
                if (this.context == null) {
                    debug.println("domain (context is null)");
                } else {
                    n = 0;
                    while (n < this.context.length) {
                        debug.println("domain " + n + " " + this.context[n]);
                        ++n;
                    }
                }
            }
        }
        if (this.context == null) {
            return;
        }
        n = 0;
        while (n < this.context.length) {
            if (this.context[n] != null && !this.context[n].implies(permission)) {
                if (debug != null) {
                    debug.println("access denied " + permission);
                    if (Debug.isOn("failure")) {
                        Thread.currentThread();
                        Thread.dumpStack();
                        final ProtectionDomain protectionDomain = this.context[n];
                        final Debug debug = AccessControlContext.debug;
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                debug.println("domain that failed " + protectionDomain);
                                return null;
                            }
                        });
                    }
                }
                throw new AccessControlException("access denied " + permission, permission);
            }
            ++n;
        }
        if (debug != null) {
            debug.println("access allowed " + permission);
        }
    }

    AccessControlContext combineWithPrivilegedContext() {
        boolean bl;
        int n;
        int n2;
        int n3;
        boolean bl2;
        boolean bl3 = this.context == null;
        AccessControlContext accessControlContext = this.privilegedContext;
        boolean bl4 = bl2 = accessControlContext.context == null;
        if (bl2 && bl3 && accessControlContext.combiner == null) {
            return this;
        }
        if (accessControlContext.combiner != null) {
            return this.goCombiner(this.context, accessControlContext, true);
        }
        int n4 = n3 = bl3 ? 0 : this.context.length;
        if (bl2 && n3 <= 2) {
            return this;
        }
        int n5 = n2 = bl2 ? 0 : accessControlContext.context.length;
        if (bl3 && n2 <= 2) {
            return accessControlContext;
        }
        if (n3 == 1 && n2 == 1 && this.context[0] == accessControlContext.context[0]) {
            return this;
        }
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[n3 + n2];
        int n6 = 0;
        if (!bl3) {
            n = 0;
            while (n < this.context.length) {
                boolean bl5 = bl = this.context[n] != null;
                if (bl) {
                    protectionDomainArray[n6++] = this.context[n];
                }
                ++n;
            }
        }
        if (!bl2) {
            n = 0;
            while (n < accessControlContext.context.length) {
                boolean bl6 = bl = accessControlContext.context[n] != null;
                if (bl) {
                    protectionDomainArray[n6++] = accessControlContext.context[n];
                }
                ++n;
            }
        }
        if (n6 != protectionDomainArray.length) {
            if (n6 == 0) {
                protectionDomainArray = null;
            } else {
                ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[n6];
                System.arraycopy(protectionDomainArray, 0, protectionDomainArray2, 0, n6);
                protectionDomainArray = protectionDomainArray2;
            }
        }
        return new AccessControlContext(protectionDomainArray, true);
    }

    AccessControlContext optimize() {
        boolean bl;
        int n;
        int n2;
        int n3;
        AccessControlContext accessControlContext;
        boolean bl2;
        boolean bl3;
        boolean bl4 = bl3 = this.context == null;
        if (this.isPrivileged) {
            if (this.privilegedContext != null) {
                return this.combineWithPrivilegedContext();
            }
            bl2 = true;
            accessControlContext = null;
        } else {
            accessControlContext = AccessController.getInheritedAccessControlContext();
            boolean bl5 = bl2 = accessControlContext == null || accessControlContext.context == null && accessControlContext.combiner == null;
        }
        if (bl2 && bl3) {
            return this;
        }
        if (accessControlContext != null && accessControlContext.combiner != null) {
            return this.goCombiner(this.context, accessControlContext, false);
        }
        int n4 = n3 = bl3 ? 0 : this.context.length;
        if (bl2 && n3 <= 2) {
            return this;
        }
        int n5 = n2 = bl2 ? 0 : accessControlContext.context.length;
        if (bl3 && n2 <= 2) {
            return accessControlContext;
        }
        if (n3 == 1 && n2 == 1 && this.context[0] == accessControlContext.context[0]) {
            return this;
        }
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[n3 + n2];
        int n6 = 0;
        if (!bl3) {
            n = 0;
            while (n < this.context.length) {
                boolean bl6 = bl = this.context[n] != null;
                if (bl) {
                    protectionDomainArray[n6++] = this.context[n];
                }
                ++n;
            }
        }
        if (!bl2) {
            n = 0;
            while (n < accessControlContext.context.length) {
                boolean bl7 = bl = accessControlContext.context[n] != null;
                if (bl) {
                    protectionDomainArray[n6++] = accessControlContext.context[n];
                }
                ++n;
            }
        }
        if (n6 != protectionDomainArray.length) {
            if (n6 == 0) {
                protectionDomainArray = null;
            } else {
                ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[n6];
                System.arraycopy(protectionDomainArray, 0, protectionDomainArray2, 0, n6);
                protectionDomainArray = protectionDomainArray2;
            }
        }
        return new AccessControlContext(protectionDomainArray, this.isPrivileged);
    }

    private AccessControlContext goCombiner(ProtectionDomain[] protectionDomainArray, AccessControlContext accessControlContext, boolean bl) {
        if (AccessControlContext.getDebug() != null) {
            debug.println("AccessControlContext invoking the Combiner");
        }
        ProtectionDomain[] protectionDomainArray2 = accessControlContext.combiner.combine(protectionDomainArray == null ? null : (ProtectionDomain[])protectionDomainArray.clone(), accessControlContext.context == null ? null : (ProtectionDomain[])accessControlContext.context.clone());
        return new AccessControlContext(protectionDomainArray2, accessControlContext.combiner);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AccessControlContext)) {
            return false;
        }
        AccessControlContext accessControlContext = (AccessControlContext)object;
        if (this.context == null) {
            return accessControlContext.context == null;
        }
        if (accessControlContext.context == null) {
            return false;
        }
        if (!this.containsAllPDs(accessControlContext) || !accessControlContext.containsAllPDs(this)) {
            return false;
        }
        if (this.combiner == null) {
            return accessControlContext.combiner == null;
        }
        if (accessControlContext.combiner == null) {
            return false;
        }
        return this.combiner.equals(accessControlContext.combiner);
    }

    private boolean containsAllPDs(AccessControlContext accessControlContext) {
        boolean bl = false;
        int n = 0;
        while (n < this.context.length) {
            int n2;
            bl = false;
            if (this.context[n] == null) {
                n2 = 0;
                while (n2 < accessControlContext.context.length && !bl) {
                    bl = accessControlContext.context[n2] == null;
                    ++n2;
                }
            } else {
                n2 = 0;
                while (n2 < accessControlContext.context.length && !bl) {
                    if (accessControlContext.context[n2] != null) {
                        bl = this.context[n].getClass() == accessControlContext.context[n2].getClass() && this.context[n].equals(accessControlContext.context[n2]);
                    }
                    ++n2;
                }
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        if (this.context == null) {
            return n;
        }
        int n2 = 0;
        while (n2 < this.context.length) {
            if (this.context[n2] != null) {
                n ^= this.context[n2].hashCode();
            }
            ++n2;
        }
        return n;
    }
}

