/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;

final class BasicPermissionCollection
extends PermissionCollection
implements Serializable {
    private Hashtable permissions = new Hashtable(11);
    private boolean all_allowed = false;

    public void add(Permission permission) {
        if (!(permission instanceof BasicPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        BasicPermission basicPermission = (BasicPermission)permission;
        this.permissions.put(basicPermission.getName(), permission);
        if (!this.all_allowed && basicPermission.getName().equals("*")) {
            this.all_allowed = true;
        }
    }

    public boolean implies(Permission permission) {
        int n;
        if (!(permission instanceof BasicPermission)) {
            return false;
        }
        BasicPermission basicPermission = (BasicPermission)permission;
        if (this.all_allowed) {
            return true;
        }
        String string = basicPermission.getName();
        Permission permission2 = (Permission)this.permissions.get(string);
        if (permission2 != null) {
            return permission2.implies(permission);
        }
        int n2 = string.length() - 1;
        while ((n = string.lastIndexOf(".", n2)) != -1) {
            permission2 = (Permission)this.permissions.get(string = string.substring(0, n + 1) + "*");
            if (permission2 != null) {
                return permission2.implies(permission);
            }
            n2 = n - 1;
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

