/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.CompactByteArray;

public class BreakDictionary {
    private char[] reverseColumnMap = null;
    private CompactByteArray columnMap = null;
    private int numCols;
    private int numColGroups;
    private short[] table = null;
    private short[] rowIndex = null;
    private int[] rowIndexFlags = null;
    private short[] rowIndexFlagsIndex = null;
    private byte[] rowIndexShifts = null;

    public static void main(String[] stringArray) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        String string = stringArray[0];
        BreakDictionary breakDictionary = new BreakDictionary(new FileInputStream(string));
        String string2 = "";
        if (stringArray.length >= 2) {
            string2 = stringArray[1];
        }
        PrintWriter printWriter = null;
        if (string2.length() != 0) {
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "UnicodeLittle"));
        }
        breakDictionary.printWordList("", 0, printWriter);
    }

    public void printWordList(String string, int n, PrintWriter printWriter) throws IOException {
        if (n == -1) {
            System.out.println(string);
            if (printWriter != null) {
                printWriter.println(string);
            }
        } else {
            int n2 = 0;
            while (n2 < this.numCols) {
                if (this.at(n, n2) != 0) {
                    this.printWordList(string + this.reverseColumnMap[n2], this.at(n, n2), printWriter);
                }
                ++n2;
            }
        }
    }

    public BreakDictionary(InputStream inputStream) throws IOException {
        this.readDictionaryFile(new ObjectInputStream(inputStream));
    }

    public void readDictionaryFile(ObjectInputStream objectInputStream) throws IOException {
        int n = objectInputStream.readInt();
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < sArray.length) {
            sArray[n2] = objectInputStream.readShort();
            ++n2;
        }
        n = objectInputStream.readInt();
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray[n3] = objectInputStream.readByte();
            ++n3;
        }
        this.columnMap = new CompactByteArray(sArray, byArray);
        this.numCols = objectInputStream.readInt();
        this.numColGroups = objectInputStream.readInt();
        n = objectInputStream.readInt();
        this.rowIndex = new short[n];
        int n4 = 0;
        while (n4 < this.rowIndex.length) {
            this.rowIndex[n4] = objectInputStream.readShort();
            ++n4;
        }
        n = objectInputStream.readInt();
        this.rowIndexFlagsIndex = new short[n];
        int n5 = 0;
        while (n5 < this.rowIndexFlagsIndex.length) {
            this.rowIndexFlagsIndex[n5] = objectInputStream.readShort();
            ++n5;
        }
        n = objectInputStream.readInt();
        this.rowIndexFlags = new int[n];
        int n6 = 0;
        while (n6 < this.rowIndexFlags.length) {
            this.rowIndexFlags[n6] = objectInputStream.readInt();
            ++n6;
        }
        n = objectInputStream.readInt();
        this.rowIndexShifts = new byte[n];
        int n7 = 0;
        while (n7 < this.rowIndexShifts.length) {
            this.rowIndexShifts[n7] = objectInputStream.readByte();
            ++n7;
        }
        n = objectInputStream.readInt();
        this.table = new short[n];
        int n8 = 0;
        while (n8 < this.table.length) {
            this.table[n8] = objectInputStream.readShort();
            ++n8;
        }
        this.reverseColumnMap = new char[this.numCols];
        char c = '\u0000';
        while (c < '\uffff') {
            byte by = this.columnMap.elementAt(c);
            if (by != 0) {
                this.reverseColumnMap[by] = c;
            }
            c = (char)(c + '\u0001');
        }
        objectInputStream.close();
    }

    public final short at(int n, char c) {
        byte by = this.columnMap.elementAt(c);
        return this.at(n, by);
    }

    public final short at(int n, int n2) {
        if (this.cellIsPopulated(n, n2)) {
            return this.internalAt(this.rowIndex[n], n2 + this.rowIndexShifts[n]);
        }
        return 0;
    }

    private final boolean cellIsPopulated(int n, int n2) {
        if (this.rowIndexFlagsIndex[n] < 0) {
            return n2 == -this.rowIndexFlagsIndex[n];
        }
        int n3 = this.rowIndexFlags[this.rowIndexFlagsIndex[n] + (n2 >> 5)];
        return (n3 & 1 << (n2 & 0x1F)) != 0;
    }

    private final short internalAt(int n, int n2) {
        return this.table[n * this.numCols + n2];
    }
}

