/*
 * Decompiled with CFR 0.152.
 */
package java.text;

final class DigitList
implements Cloneable {
    public static final int MAX_COUNT = 19;
    public static final int DBL_DIG = 17;
    public int decimalAt = 0;
    public int count = 0;
    public byte[] digits = new byte[19];
    private static final boolean DEBUG = false;
    private static byte[] LONG_MIN_REP;
    private static final double LOG10;

    DigitList() {
    }

    boolean isZero() {
        int n = 0;
        while (n < this.count) {
            if (this.digits[n] != 48) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void clear() {
        this.decimalAt = 0;
        this.count = 0;
    }

    public void append(int n) {
        if (this.count < 19) {
            this.digits[this.count++] = (byte)n;
        }
    }

    public final double getDouble() {
        if (this.count == 0) {
            return 0.0;
        }
        StringBuffer stringBuffer = new StringBuffer(this.count);
        stringBuffer.append('.');
        int n = 0;
        while (n < this.count) {
            stringBuffer.append((char)this.digits[n]);
            ++n;
        }
        stringBuffer.append('E');
        stringBuffer.append(Integer.toString(this.decimalAt));
        return Double.valueOf(stringBuffer.toString());
    }

    public final long getLong() {
        if (this.count == 0) {
            return 0L;
        }
        if (this.isLongMIN_VALUE()) {
            return Long.MIN_VALUE;
        }
        StringBuffer stringBuffer = new StringBuffer(this.count);
        int n = 0;
        while (n < this.decimalAt) {
            stringBuffer.append(n < this.count ? (char)this.digits[n] : (char)'0');
            ++n;
        }
        return Long.parseLong(stringBuffer.toString());
    }

    boolean fitsIntoLong(boolean bl, boolean bl2) {
        while (this.count > 0 && this.digits[this.count - 1] == 48) {
            --this.count;
        }
        if (this.count == 0) {
            return bl || bl2;
        }
        if (this.decimalAt < this.count || this.decimalAt > 19) {
            return false;
        }
        if (this.decimalAt < 19) {
            return true;
        }
        int n = 0;
        while (n < this.count) {
            byte by = this.digits[n];
            byte by2 = LONG_MIN_REP[n];
            if (by > by2) {
                return false;
            }
            if (by < by2) {
                return true;
            }
            ++n;
        }
        if (this.count < this.decimalAt) {
            return true;
        }
        return !bl;
    }

    public final void set(double d, int n) {
        this.set(d, n, true);
    }

    /*
     * Unable to fully structure code
     */
    final void set(double var1_1, int var3_2, boolean var4_3) {
        if (var1_1 == 0.0) {
            var1_1 = 0.0;
        }
        var5_4 = Double.toString(var1_1);
        this.decimalAt = -1;
        this.count = 0;
        var6_5 = 0;
        var7_6 = 0;
        var8_7 = false;
        var9_8 = 0;
        while (var9_8 < var5_4.length()) {
            var10_9 = var5_4.charAt(var9_8);
            if (var10_9 == '.') {
                this.decimalAt = this.count;
            } else {
                if (var10_9 == 'e' || var10_9 == 'E') {
                    var6_5 = Integer.valueOf(var5_4.substring(var9_8 + 1));
                    break;
                }
                if (this.count < 19) {
                    if (!var8_7) {
                        v0 = var8_7 = var10_9 != '0';
                        if (!var8_7 && this.decimalAt != -1) {
                            ++var7_6;
                        }
                    }
                    if (var8_7) {
                        this.digits[this.count++] = (byte)var10_9;
                    }
                }
            }
            ++var9_8;
        }
        if (this.decimalAt == -1) {
            this.decimalAt = this.count;
        }
        if (var8_7) {
            this.decimalAt += var6_5 - var7_6;
        }
        if (!var4_3) ** GOTO lbl44
        if (-this.decimalAt > var3_2) {
            this.count = 0;
            return;
        }
        if (-this.decimalAt != var3_2) ** GOTO lbl44
        if (this.shouldRoundUp(0)) {
            this.count = 1;
            ++this.decimalAt;
            this.digits[0] = 49;
        } else {
            this.count = 0;
        }
        return;
lbl-1000:
        // 1 sources

        {
            --this.count;
lbl44:
            // 3 sources

            ** while (this.count > 1 && this.digits[this.count - 1] == 48)
        }
lbl45:
        // 1 sources

        this.round(var4_3 != false ? var3_2 + this.decimalAt : var3_2);
    }

    private final void round(int n) {
        if (n >= 0 && n < this.count) {
            if (this.shouldRoundUp(n)) {
                do {
                    if (--n < 0) {
                        this.digits[0] = 49;
                        ++this.decimalAt;
                        n = 0;
                        break;
                    }
                    int n2 = n;
                    this.digits[n2] = this.digits[n2] + 1;
                } while (this.digits[n] > 57);
                ++n;
            }
            this.count = n;
            while (this.count > 1 && this.digits[this.count - 1] == 48) {
                --this.count;
            }
        }
    }

    private boolean shouldRoundUp(int n) {
        boolean bl = false;
        if (n < this.count) {
            if (this.digits[n] > 53) {
                return true;
            }
            if (this.digits[n] == 53) {
                int n2 = n + 1;
                while (n2 < this.count) {
                    if (this.digits[n2] != 48) {
                        return true;
                    }
                    ++n2;
                }
                return n > 0 && this.digits[n - 1] % 2 != 0;
            }
        }
        return false;
    }

    public final void set(long l) {
        this.set(l, 0);
    }

    public final void set(long l, int n) {
        if (l <= 0L) {
            if (l == Long.MIN_VALUE) {
                this.count = 19;
                this.decimalAt = 19;
                System.arraycopy(LONG_MIN_REP, 0, this.digits, 0, this.count);
            } else {
                this.count = 0;
                this.decimalAt = 0;
            }
        } else {
            int n2 = 19;
            while (l > 0L) {
                this.digits[--n2] = (byte)(48L + l % 10L);
                l /= 10L;
            }
            this.decimalAt = 19 - n2;
            int n3 = 18;
            while (this.digits[n3] == 48) {
                --n3;
            }
            this.count = n3 - n2 + 1;
            System.arraycopy(this.digits, n2, this.digits, 0, this.count);
        }
        if (n > 0) {
            this.round(n);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DigitList)) {
            return false;
        }
        DigitList digitList = (DigitList)object;
        if (this.count != digitList.count || this.decimalAt != digitList.decimalAt) {
            return false;
        }
        int n = 0;
        while (n < this.count) {
            if (this.digits[n] != digitList.digits[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = this.decimalAt;
        int n2 = 0;
        while (n2 < this.count) {
            n = n * 37 + this.digits[n2];
            ++n2;
        }
        return n;
    }

    private boolean isLongMIN_VALUE() {
        if (this.decimalAt != this.count || this.count != 19) {
            return false;
        }
        int n = 0;
        while (n < this.count) {
            if (this.digits[n] != LONG_MIN_REP[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static final int log10(double d) {
        double d2 = Math.log(d) / LOG10;
        int n = (int)Math.floor(d2);
        if (d2 > 0.0 && d >= Math.pow(10.0, n + 1)) {
            ++n;
        } else if (d2 < 0.0 && d < Math.pow(10.0, n)) {
            --n;
        }
        return n;
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer("0.");
        int n = 0;
        while (n < this.count) {
            stringBuffer.append((char)this.digits[n]);
            ++n;
        }
        stringBuffer.append("x10^");
        stringBuffer.append(this.decimalAt);
        return stringBuffer.toString();
    }

    static {
        String string = Long.toString(Long.MIN_VALUE);
        LONG_MIN_REP = new byte[19];
        int n = 0;
        while (n < 19) {
            DigitList.LONG_MIN_REP[n] = (byte)string.charAt(n + 1);
            ++n;
        }
        LOG10 = Math.log(10.0);
    }
}

