/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.ibm.jvm.io.LocalizedInputStream;
import com.ibm.jvm.io.LocalizedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class Properties
extends Hashtable {
    private static final long serialVersionUID = 4112578634029874840L;
    protected Properties defaults;
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public Properties() {
        this(null);
    }

    public Properties(Properties properties) {
        this.defaults = properties;
    }

    public synchronized Object setProperty(String string, String string2) {
        return this.put(string, string2);
    }

    public synchronized void load(InputStream inputStream) throws IOException {
        inputStream = LocalizedInputStream.localize(inputStream);
        LocalizedInputStream.dontUnwrap(inputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "8859_1"));
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            int n2;
            char c;
            if (string.length() <= 0 || (c = string.charAt(0)) == '#' || c == '!') continue;
            while (this.continueLine(string)) {
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    string2 = new String("");
                }
                String string3 = string.substring(0, string.length() - 1);
                n2 = 0;
                n2 = 0;
                while (n2 < string2.length()) {
                    if (whiteSpaceChars.indexOf(string2.charAt(n2)) == -1) break;
                    ++n2;
                }
                string2 = string2.substring(n2, string2.length());
                string = new String(string3 + string2);
            }
            int n3 = string.length();
            int n4 = 0;
            while (n4 < n3) {
                if (whiteSpaceChars.indexOf(string.charAt(n4)) == -1) break;
                ++n4;
            }
            if (n4 == n3) continue;
            n2 = n4;
            while (n2 < n3) {
                n = string.charAt(n2);
                if (n == 92) {
                    ++n2;
                } else if (keyValueSeparators.indexOf(n) != -1) break;
                ++n2;
            }
            n = n2;
            while (n < n3) {
                if (whiteSpaceChars.indexOf(string.charAt(n)) == -1) break;
                ++n;
            }
            if (n < n3 && strictKeyValueSeparators.indexOf(string.charAt(n)) != -1) {
                ++n;
            }
            while (n < n3) {
                if (whiteSpaceChars.indexOf(string.charAt(n)) == -1) break;
                ++n;
            }
            String string4 = string.substring(n4, n2);
            String string5 = n2 < n3 ? string.substring(n, n3) : "";
            string4 = this.loadConvert(string4);
            string5 = this.loadConvert(string5);
            this.put(string4, string5);
        }
        return;
    }

    private boolean continueLine(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0 && string.charAt(n2--) == '\\') {
            ++n;
        }
        return n % 2 == 1;
    }

    private String loadConvert(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) == '\\') {
                if ((c = string.charAt(n2++)) == 'u') {
                    int n3 = 0;
                    int n4 = 0;
                    while (n4 < 4) {
                        c = string.charAt(n2++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                n3 = (n3 << 4) + c - 48;
                                break;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                n3 = (n3 << 4) + 10 + c - 97;
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                n3 = (n3 << 4) + 10 + c - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++n4;
                    }
                    stringBuffer.append((char)n3);
                    continue;
                }
                if (c == 't') {
                    stringBuffer.append('\t');
                    continue;
                }
                if (c == 'r') {
                    stringBuffer.append('\r');
                    continue;
                }
                if (c == 'n') {
                    stringBuffer.append('\n');
                    continue;
                }
                if (c == 'f') {
                    stringBuffer.append('\f');
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private String saveConvert(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case ' ': {
                    if (n2 == 0 || bl) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    break;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    break;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    break;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    break;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    break;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(Properties.toHex(c >> 12 & 0xF));
                        stringBuffer.append(Properties.toHex(c >> 8 & 0xF));
                        stringBuffer.append(Properties.toHex(c >> 4 & 0xF));
                        stringBuffer.append(Properties.toHex(c & 0xF));
                        break;
                    }
                    if (specialSaveChars.indexOf(c) != -1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public synchronized void save(OutputStream outputStream, String string) {
        try {
            this.store(outputStream, string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void store(OutputStream outputStream, String string) throws IOException {
        outputStream = LocalizedOutputStream.localize(outputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "8859_1"));
        if (string != null) {
            Properties.writeln(bufferedWriter, "#" + string);
        }
        Properties.writeln(bufferedWriter, "#" + new Date().toString());
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)this.get(string2);
            string2 = this.saveConvert(string2, true);
            string3 = this.saveConvert(string3, false);
            Properties.writeln(bufferedWriter, string2 + "=" + string3);
        }
        bufferedWriter.flush();
    }

    private static void writeln(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write(string);
        bufferedWriter.newLine();
    }

    public String getProperty(String string) {
        Object object = super.get(string);
        String string2 = object instanceof String ? (String)object : null;
        return string2 == null && this.defaults != null ? this.defaults.getProperty(string) : string2;
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        return string3 == null ? string2 : string3;
    }

    public Enumeration propertyNames() {
        Hashtable hashtable = new Hashtable();
        this.enumerate(hashtable);
        return hashtable.keys();
    }

    public void list(PrintStream printStream) {
        printStream.println("-- listing properties --");
        Hashtable hashtable = new Hashtable();
        this.enumerate(hashtable);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            if (string2.length() > 40) {
                string2 = string2.substring(0, 37) + "...";
            }
            printStream.println(string + "=" + string2);
        }
    }

    public void list(PrintWriter printWriter) {
        printWriter.println("-- listing properties --");
        Hashtable hashtable = new Hashtable();
        this.enumerate(hashtable);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            if (string2.length() > 40) {
                string2 = string2.substring(0, 37) + "...";
            }
            printWriter.println(string + "=" + string2);
        }
    }

    private synchronized void enumerate(Hashtable hashtable) {
        if (this.defaults != null) {
            this.defaults.enumerate(hashtable);
        }
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashtable.put(string, this.get(string));
        }
    }

    private static char toHex(int n) {
        return hexDigit[n & 0xF];
    }
}

