/*
 * Decompiled with CFR 0.152.
 */
package javax.rmi.CORBA;

import com.ibm.rmi.util.JDKBridge;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.rmi.CORBA.GetORBPropertiesFileAction;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.UtilDelegate;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class Util {
    private static UtilDelegate utilDelegate = null;
    private static final String UtilClassKey = "javax.rmi.CORBA.UtilClass";
    private static final String defaultUtilImplName = "com.ibm.rmi.javax.rmi.CORBA.Util";

    private Util() {
    }

    public static RemoteException mapSystemException(SystemException systemException) {
        if (utilDelegate != null) {
            return utilDelegate.mapSystemException(systemException);
        }
        return new RemoteException("CORBA", systemException);
    }

    public static void writeAny(OutputStream outputStream, Object object) {
        if (utilDelegate != null) {
            utilDelegate.writeAny(outputStream, object);
        }
    }

    public static Object readAny(InputStream inputStream) {
        if (utilDelegate != null) {
            return utilDelegate.readAny(inputStream);
        }
        return null;
    }

    public static void writeRemoteObject(OutputStream outputStream, Object object) {
        if (utilDelegate != null) {
            utilDelegate.writeRemoteObject(outputStream, object);
        }
    }

    public static void writeAbstractObject(OutputStream outputStream, Object object) {
        if (utilDelegate != null) {
            utilDelegate.writeAbstractObject(outputStream, object);
        }
    }

    public static void registerTarget(Tie tie, Remote remote) {
        if (utilDelegate != null) {
            utilDelegate.registerTarget(tie, remote);
        }
    }

    public static void unexportObject(Remote remote) {
        if (utilDelegate != null) {
            utilDelegate.unexportObject(remote);
        }
    }

    public static Tie getTie(Remote remote) {
        if (utilDelegate != null) {
            return utilDelegate.getTie(remote);
        }
        return null;
    }

    public static ValueHandler createValueHandler() {
        if (utilDelegate != null) {
            return utilDelegate.createValueHandler();
        }
        return null;
    }

    public static String getCodebase(Class clazz) {
        if (utilDelegate != null) {
            return utilDelegate.getCodebase(clazz);
        }
        return null;
    }

    public static Class loadClass(String string, String string2, ClassLoader classLoader) throws ClassNotFoundException {
        if (utilDelegate != null) {
            return utilDelegate.loadClass(string, string2, classLoader);
        }
        return null;
    }

    public static boolean isLocal(Stub stub) throws RemoteException {
        if (utilDelegate != null) {
            return utilDelegate.isLocal(stub);
        }
        return false;
    }

    public static RemoteException wrapException(Throwable throwable) {
        if (utilDelegate != null) {
            return utilDelegate.wrapException(throwable);
        }
        return new UnexpectedException(throwable.toString());
    }

    public static Object[] copyObjects(Object[] objectArray, ORB oRB) throws RemoteException {
        if (utilDelegate != null) {
            return utilDelegate.copyObjects(objectArray, oRB);
        }
        return null;
    }

    public static Object copyObject(Object object, ORB oRB) throws RemoteException {
        if (utilDelegate != null) {
            return utilDelegate.copyObject(object, oRB);
        }
        return null;
    }

    private static Object createDelegateIfSpecified(final String string) {
        Properties properties;
        String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
        if (string2 == null && (properties = Util.getORBPropertiesFile()) != null) {
            string2 = properties.getProperty(string);
        }
        if (string2 == null) {
            string2 = defaultUtilImplName;
        }
        if (string2 != null) {
            try {
                return JDKBridge.loadClass(string2, null, null).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new INITIALIZE("cannot instantiate " + string2);
            }
            catch (Exception exception) {
                throw new INITIALIZE("cannot instantiate " + string2);
            }
        }
        return null;
    }

    private static Properties getORBPropertiesFile() {
        return (Properties)AccessController.doPrivileged(new GetORBPropertiesFileAction());
    }

    static {
        utilDelegate = (UtilDelegate)Util.createDelegateIfSpecified(UtilClassKey);
    }
}

