/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractActionPropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class JCheckBox
extends JToggleButton
implements Accessible {
    public static final String BORDER_PAINTED_FLAT_CHANGED_PROPERTY = "borderPaintedFlat";
    private boolean flat = false;
    private static final String uiClassID = "CheckBoxUI";

    public JCheckBox() {
        this(null, null, false);
    }

    public JCheckBox(Icon icon) {
        this(null, icon, false);
    }

    public JCheckBox(Icon icon, boolean bl) {
        this(null, icon, bl);
    }

    public JCheckBox(String string) {
        this(string, null, false);
    }

    public JCheckBox(Action action) {
        this();
        this.setAction(action);
    }

    public JCheckBox(String string, boolean bl) {
        this(string, null, bl);
    }

    public JCheckBox(String string, Icon icon) {
        this(string, icon, false);
    }

    public JCheckBox(String string, Icon icon, boolean bl) {
        super(string, icon, bl);
        this.setBorderPainted(false);
        this.setHorizontalAlignment(2);
    }

    public void setBorderPaintedFlat(boolean bl) {
        boolean bl2 = this.flat = bl;
        this.flat = bl;
        this.firePropertyChange(BORDER_PAINTED_FLAT_CHANGED_PROPERTY, bl2, this.flat);
        if (bl != bl2) {
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isBorderPaintedFlat() {
        return this.flat;
    }

    public void updateUI() {
        this.setUI((ButtonUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected void configurePropertiesFromAction(Action action) {
        this.setText(action != null ? (String)action.getValue("Name") : null);
        this.setEnabled(action != null ? action.isEnabled() : true);
        this.setToolTipText(action != null ? (String)action.getValue("ShortDescription") : null);
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new AbstractActionPropertyChangeListener(this, action){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                AbstractButton abstractButton = (AbstractButton)this.getTarget();
                if (abstractButton == null) {
                    Action action = (Action)propertyChangeEvent.getSource();
                    action.removePropertyChangeListener(this);
                } else if (propertyChangeEvent.getPropertyName().equals("Name")) {
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    abstractButton.setText(string2);
                    abstractButton.repaint();
                } else if (propertyChangeEvent.getPropertyName().equals("ShortDescription")) {
                    String string3 = (String)propertyChangeEvent.getNewValue();
                    abstractButton.setToolTipText(string3);
                } else if (string.equals("enabled")) {
                    Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    abstractButton.setEnabled(bl);
                    abstractButton.repaint();
                }
            }
        };
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.getUIClassID().equals(uiClassID)) {
            this.updateUI();
        }
    }

    protected String paramString() {
        return super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJCheckBox();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJCheckBox
    extends JToggleButton.AccessibleJToggleButton {
        protected AccessibleJCheckBox() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CHECK_BOX;
        }
    }
}

