/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.UIResource;

public class JToolBar
extends JComponent
implements SwingConstants,
Accessible {
    private static final String uiClassID = "ToolBarUI";
    private boolean paintBorder = true;
    private Insets margin = null;
    private boolean floatable = true;
    private int orientation = 0;

    public JToolBar() {
        this(0);
    }

    public JToolBar(int n) {
        this(null, n);
    }

    public JToolBar(String string) {
        this(string, 0);
    }

    public JToolBar(String string, int n) {
        this.setName(string);
        this.checkOrientation(n);
        this.orientation = n;
        if (n == 1) {
            this.setLayout(new BoxLayout(this, 1));
        } else if (SwingUtilities.isLeftToRight(this)) {
            this.setLayout(new BoxLayout(this, 0));
        } else {
            this.setLayout(new RightToLeftToolBarLayout());
        }
        this.addPropertyChangeListener(new PropertyChangeHandler());
        this.updateUI();
    }

    public ToolBarUI getUI() {
        return (ToolBarUI)this.ui;
    }

    public void setUI(ToolBarUI toolBarUI) {
        super.setUI(toolBarUI);
    }

    public void updateUI() {
        this.setUI((ToolBarUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public int getComponentIndex(Component component) {
        int n = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        while (n2 < n) {
            Component component2 = componentArray[n2];
            if (component2 == component) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Component getComponentAtIndex(int n) {
        int n2 = this.getComponentCount();
        if (n >= 0 && n < n2) {
            Component[] componentArray = this.getComponents();
            return componentArray[n];
        }
        return null;
    }

    public void setMargin(Insets insets) {
        Insets insets2 = this.margin;
        this.margin = insets;
        this.firePropertyChange("margin", insets2, insets);
        this.revalidate();
        this.repaint();
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean bl) {
        if (this.paintBorder != bl) {
            boolean bl2 = this.paintBorder;
            this.paintBorder = bl;
            this.firePropertyChange("borderPainted", bl2, bl);
            this.revalidate();
            this.repaint();
        }
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    public boolean isFloatable() {
        return this.floatable;
    }

    public void setFloatable(boolean bl) {
        if (this.floatable != bl) {
            boolean bl2 = this.floatable;
            this.floatable = bl;
            this.firePropertyChange("floatable", bl2, bl);
            this.revalidate();
            this.repaint();
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.checkOrientation(n);
        if (this.orientation != n) {
            int n2 = this.orientation;
            this.orientation = n;
            if (n == 1) {
                this.setLayout(new BoxLayout(this, 1));
            } else if (SwingUtilities.isLeftToRight(this)) {
                this.setLayout(new BoxLayout(this, 0));
            } else {
                this.setLayout(new RightToLeftToolBarLayout());
            }
            this.firePropertyChange("orientation", n2, n);
            this.revalidate();
            this.repaint();
        }
    }

    private void checkOrientation(int n) {
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
        }
    }

    public void addSeparator() {
        Separator separator = new Separator();
        this.add(separator);
    }

    public void addSeparator(Dimension dimension) {
        Separator separator = new Separator(dimension);
        this.add(separator);
    }

    public JButton add(Action action) {
        JButton jButton = this.createActionComponent(action);
        jButton.setAction(action);
        this.add(jButton);
        return jButton;
    }

    protected JButton createActionComponent(Action action) {
        String string = (String)action.getValue("Name");
        Icon icon = (Icon)action.getValue("SmallIcon");
        JButton jButton = new JButton(string, icon){

            protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
                PropertyChangeListener propertyChangeListener = JToolBar.this.createActionChangeListener(this);
                if (propertyChangeListener == null) {
                    propertyChangeListener = super.createActionPropertyChangeListener(action);
                }
                return propertyChangeListener;
            }
        };
        if (icon != null) {
            jButton.putClientProperty("hideActionText", Boolean.TRUE);
        }
        jButton.setHorizontalTextPosition(0);
        jButton.setVerticalTextPosition(3);
        jButton.setEnabled(action.isEnabled());
        jButton.setToolTipText((String)action.getValue("ShortDescription"));
        return jButton;
    }

    protected PropertyChangeListener createActionChangeListener(JButton jButton) {
        return null;
    }

    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        if (component instanceof JButton) {
            ((JButton)component).setDefaultCapable(false);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    protected String paramString() {
        String string = this.paintBorder ? "true" : "false";
        String string2 = this.margin != null ? this.margin.toString() : "";
        String string3 = this.floatable ? "true" : "false";
        String string4 = this.orientation == 0 ? "HORIZONTAL" : "VERTICAL";
        return super.paramString() + ",floatable=" + string3 + ",margin=" + string2 + ",orientation=" + string4 + ",paintBorder=" + string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJToolBar();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJToolBar
    extends JComponent.AccessibleJComponent {
        protected AccessibleJToolBar() {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOOL_BAR;
        }
    }

    private static class RightToLeftToolBarLayout
    extends FlowLayout
    implements UIResource {
        private RightToLeftToolBarLayout() {
            super(3, 0, 0);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("componentOrientation")) {
                if (SwingUtilities.isLeftToRight(JToolBar.this)) {
                    JToolBar.this.setLayout(new BoxLayout(JToolBar.this, 0));
                } else {
                    JToolBar.this.setLayout(new RightToLeftToolBarLayout());
                }
            }
        }
    }

    public static class Separator
    extends JSeparator {
        private Dimension separatorSize;

        public Separator() {
            this(null);
        }

        public Separator(Dimension dimension) {
            super(0);
            this.setSeparatorSize(dimension);
        }

        public String getUIClassID() {
            return "ToolBarSeparatorUI";
        }

        public void setSeparatorSize(Dimension dimension) {
            if (dimension != null) {
                this.separatorSize = dimension;
            } else {
                super.updateUI();
            }
            this.invalidate();
        }

        public Dimension getSeparatorSize() {
            return this.separatorSize;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return this.separatorSize.getSize();
        }
    }
}

