/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultPopupFactory;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    Timer enterTimer;
    Timer exitTimer;
    Timer insideTimer;
    String toolTipText;
    Point preferredLocation;
    JComponent insideComponent;
    MouseEvent mouseEvent;
    boolean showImmediately;
    static final ToolTipManager sharedInstance = new ToolTipManager();
    Popup tipWindow;
    JToolTip tip;
    private PopupFactory popupFactory = new DefaultPopupFactory();
    private Rectangle popupRect = null;
    private Rectangle popupFrameRect = null;
    boolean enabled = true;
    boolean mouseAboveToolTip = false;
    private boolean tipShowing = false;
    private long timerEnter = 0L;
    private KeyStroke postTip;
    private KeyStroke hideTip;
    private Action postTipAction;
    private Action hideTipAction;
    private FocusListener focusChangeListener = null;
    protected boolean lightWeightPopupEnabled = true;
    protected boolean heavyWeightPopupEnabled = false;

    ToolTipManager() {
        this.enterTimer = new Timer(750, new insideTimerAction());
        this.enterTimer.setRepeats(false);
        this.exitTimer = new Timer(500, new outsideTimerAction());
        this.exitTimer.setRepeats(false);
        this.insideTimer = new Timer(4000, new stillInsideTimerAction());
        this.insideTimer.setRepeats(false);
        this.postTip = KeyStroke.getKeyStroke(112, 2);
        this.postTipAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ToolTipManager.this.tipWindow != null) {
                    ToolTipManager.this.hideTipWindow();
                } else {
                    ToolTipManager.this.hideTipWindow();
                    ToolTipManager.this.enterTimer.stop();
                    ToolTipManager.this.exitTimer.stop();
                    ToolTipManager.this.insideTimer.stop();
                    ToolTipManager.this.insideComponent = (JComponent)actionEvent.getSource();
                    if (ToolTipManager.this.insideComponent != null) {
                        ToolTipManager.this.toolTipText = ToolTipManager.this.insideComponent.getToolTipText();
                        ToolTipManager.this.preferredLocation = new Point(10, ToolTipManager.this.insideComponent.getHeight() + 10);
                        ToolTipManager.this.showTipWindow();
                        if (ToolTipManager.this.focusChangeListener == null) {
                            ToolTipManager.this.focusChangeListener = ToolTipManager.this.createFocusChangeListener();
                        }
                        ToolTipManager.this.insideComponent.addFocusListener(ToolTipManager.this.focusChangeListener);
                    }
                }
            }
        };
        this.hideTip = KeyStroke.getKeyStroke(27, 0);
        this.hideTipAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolTipManager.this.hideTipWindow();
                JComponent jComponent = (JComponent)actionEvent.getSource();
                jComponent.removeFocusListener(ToolTipManager.this.focusChangeListener);
                ToolTipManager.this.preferredLocation = null;
            }

            public boolean isEnabled() {
                return ToolTipManager.this.tipShowing;
            }
        };
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!bl) {
            this.hideTipWindow();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        this.popupFactory.setLightWeightPopupEnabled(bl);
    }

    public boolean isLightWeightPopupEnabled() {
        return this.popupFactory.isLightWeightPopupEnabled();
    }

    public void setInitialDelay(int n) {
        this.enterTimer.setInitialDelay(n);
    }

    public int getInitialDelay() {
        return this.enterTimer.getInitialDelay();
    }

    public void setDismissDelay(int n) {
        this.insideTimer.setInitialDelay(n);
    }

    public int getDismissDelay() {
        return this.insideTimer.getInitialDelay();
    }

    public void setReshowDelay(int n) {
        this.exitTimer.setInitialDelay(n);
    }

    public int getReshowDelay() {
        return this.exitTimer.getInitialDelay();
    }

    void showTipWindow() {
        if (this.tipShowing || this.insideComponent == null || !this.insideComponent.isShowing()) {
            return;
        }
        if (this.enabled) {
            Point point = this.insideComponent.getLocationOnScreen();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Point point2 = new Point();
            boolean bl = SwingUtilities.isLeftToRight(this.insideComponent);
            this.hideTipWindow();
            this.tip = this.insideComponent.createToolTip();
            this.tip.setTipText(this.toolTipText);
            Dimension dimension2 = this.tip.getPreferredSize();
            if (this.preferredLocation != null) {
                point2.x = point.x + this.preferredLocation.x;
                point2.y = point.y + this.preferredLocation.y;
                if (!bl) {
                    point2.x -= dimension2.width;
                }
            } else {
                point2.x = point.x + this.mouseEvent.getX();
                point2.y = point.y + this.mouseEvent.getY() + 20;
                if (!bl && point2.x - dimension2.width >= 0) {
                    point2.x -= dimension2.width;
                }
                if (point2.x + dimension2.width > dimension.width) {
                    point2.x -= dimension2.width;
                }
                if (point2.y + dimension2.height > dimension.height) {
                    point2.y -= dimension2.height + 20;
                }
            }
            if (!this.heavyWeightPopupEnabled) {
                if (this.popupRect == null) {
                    this.popupRect = new Rectangle();
                }
                this.popupRect.setBounds(point2.x, point2.y, dimension2.width, dimension2.height);
                int n = this.getPopupFitHeight(this.popupRect, this.insideComponent);
                int n2 = this.getPopupFitWidth(this.popupRect, this.insideComponent);
                if (n > 0) {
                    point2.y -= n;
                }
                if (n2 > 0) {
                    point2.x -= n2;
                }
            }
            this.tipWindow = this.popupFactory.getPopup(this.tip, this.insideComponent, point2.x, point2.y);
            if (this.tipWindow instanceof Window) {
                ((Window)((Object)this.tipWindow)).addMouseListener(this);
            }
            this.tipWindow.show(this.insideComponent);
            this.insideTimer.start();
            this.timerEnter = System.currentTimeMillis();
            this.tipShowing = true;
        }
    }

    void hideTipWindow() {
        if (this.tipWindow != null) {
            if (this.tipWindow instanceof Window) {
                ((Window)((Object)this.tipWindow)).removeMouseListener(this);
            }
            this.tipWindow.hide();
            this.tipWindow = null;
            this.tipShowing = false;
            this.timerEnter = 0L;
            this.tip.getUI().uninstallUI(this.tip);
            this.tip = null;
            this.insideTimer.stop();
        }
    }

    public static ToolTipManager sharedInstance() {
        return sharedInstance;
    }

    public void registerComponent(JComponent jComponent) {
        jComponent.removeMouseListener(this);
        jComponent.addMouseListener(this);
        if (this.shouldRegisterBindings(jComponent)) {
            InputMap inputMap = jComponent.getInputMap(0);
            ActionMap actionMap = jComponent.getActionMap();
            if (inputMap != null && actionMap != null) {
                inputMap.put(this.postTip, "postTip");
                inputMap.put(this.hideTip, "hideTip");
                actionMap.put("postTip", this.postTipAction);
                actionMap.put("hideTip", this.hideTipAction);
            }
        }
    }

    public void unregisterComponent(JComponent jComponent) {
        jComponent.removeMouseListener(this);
        if (this.shouldRegisterBindings(jComponent)) {
            InputMap inputMap = jComponent.getInputMap(0);
            ActionMap actionMap = jComponent.getActionMap();
            if (inputMap != null && actionMap != null) {
                inputMap.remove(this.postTip);
                inputMap.remove(this.hideTip);
                actionMap.remove("postTip");
                actionMap.remove("hideTip");
            }
        }
    }

    private boolean shouldRegisterBindings(JComponent jComponent) {
        InputMap inputMap = jComponent.getInputMap(0, false);
        while (inputMap != null && inputMap.size() == 0) {
            inputMap = inputMap.getParent();
        }
        return inputMap != null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.tipShowing && !this.lightWeightPopupEnabled && System.currentTimeMillis() - this.timerEnter < 200L) {
            return;
        }
        if (mouseEvent.getSource() == this.tipWindow) {
            return;
        }
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        this.toolTipText = jComponent.getToolTipText(mouseEvent);
        this.preferredLocation = jComponent.getToolTipLocation(mouseEvent);
        this.exitTimer.stop();
        Point point = mouseEvent.getPoint();
        if (point.x < 0 || point.x >= jComponent.getWidth() || point.y < 0 || point.y >= jComponent.getHeight()) {
            return;
        }
        if (this.insideComponent != null) {
            this.enterTimer.stop();
            this.insideComponent = null;
        }
        jComponent.addMouseMotionListener(this);
        this.insideComponent = jComponent;
        if (this.tipWindow != null) {
            if (this.heavyWeightPopupEnabled) {
                return;
            }
            this.mouseEvent = mouseEvent;
            if (this.showImmediately) {
                this.showTipWindow();
            } else {
                this.enterTimer.start();
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.tipShowing && !this.lightWeightPopupEnabled && System.currentTimeMillis() - this.timerEnter < 200L) {
            return;
        }
        boolean bl = true;
        if (this.insideComponent == null) {
            // empty if block
        }
        if (mouseEvent.getSource() == this.tipWindow) {
            Container container = this.insideComponent.getTopLevelAncestor();
            Rectangle rectangle = this.tipWindow.getBoundsOnScreen();
            Point point = mouseEvent.getPoint();
            point.x += rectangle.x;
            point.y += rectangle.y;
            rectangle = container.getBounds();
            point.x -= rectangle.x;
            point.y -= rectangle.y;
            point = SwingUtilities.convertPoint(null, point, this.insideComponent);
            bl = point.x < 0 || point.x >= this.insideComponent.getWidth() || point.y < 0 || point.y >= this.insideComponent.getHeight();
        } else if (mouseEvent.getSource() == this.insideComponent && this.tipWindow != null) {
            Point point = SwingUtilities.convertPoint(this.insideComponent, mouseEvent.getPoint(), null);
            Rectangle rectangle = this.insideComponent.getTopLevelAncestor().getBounds();
            point.x += rectangle.x;
            point.y += rectangle.y;
            rectangle = this.tipWindow.getBoundsOnScreen();
            bl = point.x < rectangle.x || point.x >= rectangle.x + rectangle.width || point.y < rectangle.y || point.y >= rectangle.y + rectangle.height;
        }
        if (bl) {
            this.enterTimer.stop();
            if (this.insideComponent != null) {
                this.insideComponent.removeMouseMotionListener(this);
            }
            this.insideComponent = null;
            this.toolTipText = null;
            this.mouseEvent = null;
            this.hideTipWindow();
            this.exitTimer.start();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.hideTipWindow();
        this.enterTimer.stop();
        this.showImmediately = false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        String string = jComponent.getToolTipText(mouseEvent);
        Point point = jComponent.getToolTipLocation(mouseEvent);
        if (string != null || point != null) {
            this.mouseEvent = mouseEvent;
            if ((string != null && string.equals(this.toolTipText) || string == null) && (point != null && point.equals(this.preferredLocation) || point == null)) {
                if (this.tipWindow != null) {
                    this.insideTimer.restart();
                } else {
                    this.enterTimer.restart();
                }
            } else {
                this.toolTipText = string;
                this.preferredLocation = point;
                if (this.showImmediately) {
                    this.hideTipWindow();
                    this.showTipWindow();
                } else {
                    this.enterTimer.restart();
                }
            }
        } else {
            this.toolTipText = null;
            this.preferredLocation = null;
            this.mouseEvent = null;
            this.hideTipWindow();
            this.enterTimer.stop();
            this.exitTimer.start();
        }
    }

    static Frame frameForComponent(Component component) {
        while (!(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    private FocusListener createFocusChangeListener() {
        return new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ToolTipManager.this.hideTipWindow();
                JComponent jComponent = (JComponent)focusEvent.getSource();
                jComponent.removeFocusListener(ToolTipManager.this.focusChangeListener);
            }
        };
    }

    private int getPopupFitWidth(Rectangle rectangle, Component component) {
        if (component != null) {
            Container container = component.getParent();
            while (container != null) {
                if (container instanceof JFrame || container instanceof JDialog || container instanceof JWindow) {
                    return this.getWidthAdjust(container.getBounds(), rectangle);
                }
                if (container instanceof JApplet || container instanceof JInternalFrame) {
                    if (this.popupFrameRect == null) {
                        this.popupFrameRect = new Rectangle();
                    }
                    Point point = container.getLocationOnScreen();
                    this.popupFrameRect.setBounds(point.x, point.y, container.getBounds().width, container.getBounds().height);
                    return this.getWidthAdjust(this.popupFrameRect, rectangle);
                }
                container = container.getParent();
            }
        }
        return 0;
    }

    private int getPopupFitHeight(Rectangle rectangle, Component component) {
        if (component != null) {
            Container container = component.getParent();
            while (container != null) {
                if (container instanceof JFrame || container instanceof JDialog || container instanceof JWindow) {
                    return this.getHeightAdjust(container.getBounds(), rectangle);
                }
                if (container instanceof JApplet || container instanceof JInternalFrame) {
                    if (this.popupFrameRect == null) {
                        this.popupFrameRect = new Rectangle();
                    }
                    Point point = container.getLocationOnScreen();
                    this.popupFrameRect.setBounds(point.x, point.y, container.getBounds().width, container.getBounds().height);
                    return this.getHeightAdjust(this.popupFrameRect, rectangle);
                }
                container = container.getParent();
            }
        }
        return 0;
    }

    private int getHeightAdjust(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height) {
            return 0;
        }
        return rectangle2.y + rectangle2.height - (rectangle.y + rectangle.height) + 5;
    }

    private int getWidthAdjust(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width) {
            return 0;
        }
        return rectangle2.x + rectangle2.width - (rectangle.x + rectangle.width) + 5;
    }

    protected class stillInsideTimerAction
    implements ActionListener {
        protected stillInsideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ToolTipManager.this.hideTipWindow();
            ToolTipManager.this.enterTimer.stop();
            ToolTipManager.this.showImmediately = false;
        }
    }

    protected class outsideTimerAction
    implements ActionListener {
        protected outsideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ToolTipManager.this.showImmediately = false;
        }
    }

    protected class insideTimerAction
    implements ActionListener {
        protected insideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ToolTipManager.this.insideComponent != null && ToolTipManager.this.insideComponent.isShowing()) {
                ToolTipManager.this.showImmediately = true;
                ToolTipManager.this.showTipWindow();
            }
        }
    }
}

