/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.ComboPopup;

public class BasicComboPopup
extends JPopupMenu
implements ComboPopup {
    static final ListModel EmptyListModel = new ListModel(){

        public int getSize() {
            return 0;
        }

        public Object getElementAt(int n) {
            return null;
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }
    };
    protected JComboBox comboBox;
    protected JList list;
    protected JScrollPane scroller;
    protected boolean valueIsAdjusting = false;
    protected MouseMotionListener mouseMotionListener;
    protected MouseListener mouseListener;
    protected KeyListener keyListener;
    protected ListSelectionListener listSelectionListener;
    protected ListDataListener listDataListener;
    protected MouseListener listMouseListener;
    protected MouseMotionListener listMouseMotionListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ItemListener itemListener;
    protected Timer autoscrollTimer;
    protected boolean hasEntered = false;
    protected boolean isAutoScrolling = false;
    protected int scrollDirection = 0;
    protected static final int SCROLL_UP = 0;
    protected static final int SCROLL_DOWN = 1;
    private boolean lightNav = false;
    private static final String LIGHTWEIGHT_KEYBOARD_NAVIGATION = "JComboBox.lightweightKeyboardNavigation";
    private static final String LIGHTWEIGHT_KEYBOARD_NAVIGATION_ON = "Lightweight";
    private static final String LIGHTWEIGHT_KEYBOARD_NAVIGATION_OFF = "Heavyweight";

    public void show() {
        Dimension dimension = this.comboBox.getSize();
        dimension.setSize(dimension.width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
        Rectangle rectangle = this.computePopupBounds(0, this.comboBox.getBounds().height, dimension.width, dimension.height);
        this.scroller.setMaximumSize(rectangle.getSize());
        this.scroller.setPreferredSize(rectangle.getSize());
        this.scroller.setMinimumSize(rectangle.getSize());
        this.list.invalidate();
        this.syncListSelectionWithComboBoxSelection();
        this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
        this.show(this.comboBox, rectangle.x, rectangle.y);
    }

    public void hide() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        int n = 0;
        while (n < menuElementArray.length) {
            if (menuElementArray[n] == this) {
                menuSelectionManager.clearSelectedPath();
                break;
            }
            ++n;
        }
        this.comboBox.repaint();
    }

    public JList getList() {
        return this.list;
    }

    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    public MouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    public void uninstallingUI() {
        this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        this.comboBox.removeItemListener(this.itemListener);
        this.uninstallComboBoxModelListeners(this.comboBox.getModel());
        this.uninstallKeyboardActions();
        this.uninstallListListeners();
        this.list.setModel(EmptyListModel);
    }

    protected void uninstallComboBoxModelListeners(ComboBoxModel comboBoxModel) {
        if (comboBoxModel != null) {
            comboBoxModel.removeListDataListener(this.listDataListener);
        }
    }

    protected void uninstallKeyboardActions() {
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
    }

    public BasicComboPopup(JComboBox jComboBox) {
        this.comboBox = jComboBox;
        Object object = jComboBox.getClientProperty(LIGHTWEIGHT_KEYBOARD_NAVIGATION);
        if (object != null) {
            if (object.equals(LIGHTWEIGHT_KEYBOARD_NAVIGATION_ON)) {
                this.lightNav = true;
            } else if (object.equals(LIGHTWEIGHT_KEYBOARD_NAVIGATION_OFF)) {
                this.lightNav = false;
            }
        }
        this.mouseListener = this.createMouseListener();
        this.mouseMotionListener = this.createMouseMotionListener();
        this.keyListener = this.createKeyListener();
        this.listSelectionListener = this.createListSelectionListener();
        this.listDataListener = this.createListDataListener();
        this.listMouseListener = this.createListMouseListener();
        this.listMouseMotionListener = this.createListMouseMotionListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.itemListener = this.createItemListener();
        this.list = this.createList();
        this.configureList();
        this.scroller = this.createScroller();
        this.configureScroller();
        this.configurePopup();
        this.installComboBoxListeners();
        this.installKeyboardActions();
    }

    protected MouseListener createMouseListener() {
        return new InvocationMouseHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new InvocationMouseMotionHandler();
    }

    protected KeyListener createKeyListener() {
        return new InvocationKeyHandler();
    }

    protected ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler();
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler();
    }

    protected MouseListener createListMouseListener() {
        return new ListMouseHandler();
    }

    protected MouseMotionListener createListMouseMotionListener() {
        return new ListMouseMotionHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected ItemListener createItemListener() {
        return new ItemHandler();
    }

    protected JList createList() {
        return new JList(this.comboBox.getModel());
    }

    protected void configureList() {
        this.list.setFont(this.comboBox.getFont());
        this.list.setForeground(this.comboBox.getForeground());
        this.list.setBackground(this.comboBox.getBackground());
        this.list.setSelectionForeground(UIManager.getColor("ComboBox.selectionForeground"));
        this.list.setSelectionBackground(UIManager.getColor("ComboBox.selectionBackground"));
        this.list.setBorder(null);
        this.list.setCellRenderer(this.comboBox.getRenderer());
        this.list.setRequestFocusEnabled(false);
        this.syncListSelectionWithComboBoxSelection();
        this.list.setSelectionMode(0);
        this.installListListeners();
    }

    protected void installListListeners() {
        this.list.addListSelectionListener(this.listSelectionListener);
        this.list.addMouseMotionListener(this.listMouseMotionListener);
        this.list.addMouseListener(this.listMouseListener);
    }

    void uninstallListListeners() {
        this.list.removeListSelectionListener(this.listSelectionListener);
        this.list.removeMouseMotionListener(this.listMouseMotionListener);
        this.list.removeMouseListener(this.listMouseListener);
    }

    protected JScrollPane createScroller() {
        return new JScrollPane(this.list, 20, 31);
    }

    protected void configureScroller() {
        this.scroller.setRequestFocusEnabled(false);
        this.scroller.getVerticalScrollBar().setRequestFocusEnabled(false);
        this.scroller.setBorder(null);
    }

    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setOpaque(false);
        this.add(this.scroller);
        this.setDoubleBuffered(true);
        this.setRequestFocusEnabled(false);
    }

    protected void installComboBoxListeners() {
        this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        this.comboBox.addItemListener(this.itemListener);
        this.installComboBoxModelListeners(this.comboBox.getModel());
    }

    protected void installComboBoxModelListeners(ComboBoxModel comboBoxModel) {
        if (comboBoxModel != null) {
            comboBoxModel.addListDataListener(this.listDataListener);
        }
    }

    protected void installKeyboardActions() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.comboBox.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(10, 0), 1);
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        ComponentOrientation componentOrientation2;
        JList jList = this.getList();
        if (jList != null && jList.getComponentOrientation() != componentOrientation) {
            jList.setComponentOrientation(componentOrientation);
        }
        if (this.scroller != null && this.scroller.getComponentOrientation() != componentOrientation) {
            BasicGraphicsUtils.applyOrientation(this.scroller, componentOrientation);
        }
        if (componentOrientation != (componentOrientation2 = this.getComponentOrientation())) {
            super.setComponentOrientation(componentOrientation);
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected void startAutoScrolling(int n) {
        if (this.isAutoScrolling) {
            this.autoscrollTimer.stop();
        }
        this.isAutoScrolling = true;
        if (n == 0) {
            this.scrollDirection = 0;
            Point point = SwingUtilities.convertPoint(this.scroller, new Point(1, 1), this.list);
            int n2 = this.list.locationToIndex(point);
            this.valueIsAdjusting = true;
            this.list.setSelectedIndex(n2);
            this.valueIsAdjusting = false;
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BasicComboPopup.this.autoScrollUp();
                }
            };
            this.autoscrollTimer = new Timer(100, actionListener);
        } else if (n == 1) {
            this.scrollDirection = 1;
            Dimension dimension = this.scroller.getSize();
            Point point = SwingUtilities.convertPoint(this.scroller, new Point(1, dimension.height - 1 - 2), this.list);
            int n3 = this.list.locationToIndex(point);
            this.valueIsAdjusting = true;
            this.list.setSelectedIndex(n3);
            this.valueIsAdjusting = false;
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BasicComboPopup.this.autoScrollDown();
                }
            };
            this.autoscrollTimer = new Timer(100, actionListener);
        }
        this.autoscrollTimer.start();
    }

    protected void stopAutoScrolling() {
        this.isAutoScrolling = false;
        if (this.autoscrollTimer != null) {
            this.autoscrollTimer.stop();
            this.autoscrollTimer = null;
        }
    }

    protected void autoScrollUp() {
        int n = this.list.getSelectedIndex();
        if (n > 0) {
            this.valueIsAdjusting = true;
            this.list.setSelectedIndex(n - 1);
            this.valueIsAdjusting = false;
            this.list.ensureIndexIsVisible(n - 1);
        }
    }

    protected void autoScrollDown() {
        int n;
        int n2 = this.list.getSelectedIndex();
        if (n2 < (n = this.list.getModel().getSize() - 1)) {
            this.valueIsAdjusting = true;
            this.list.setSelectedIndex(n2 + 1);
            this.valueIsAdjusting = false;
            this.list.ensureIndexIsVisible(n2 + 1);
        }
    }

    protected void delegateFocus(MouseEvent mouseEvent) {
        if (this.comboBox.isEditable()) {
            this.comboBox.getEditor().getEditorComponent().requestFocus();
        } else {
            this.comboBox.requestFocus();
        }
    }

    protected void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    void syncListSelectionWithComboBoxSelection() {
        int n = this.comboBox.getSelectedIndex();
        if (n == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(n);
        }
    }

    protected MouseEvent convertMouseEvent(MouseEvent mouseEvent) {
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this.list);
        MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getModifiers(), mouseEvent.isPopupTrigger());
        return mouseEvent2;
    }

    protected int getPopupHeightForRowCount(int n) {
        int n2 = this.comboBox.getModel().getSize();
        int n3 = Math.min(n, n2);
        int n4 = 0;
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        Object object = null;
        int n5 = 0;
        while (n5 < n3) {
            object = this.list.getModel().getElementAt(n5);
            Component component = listCellRenderer.getListCellRendererComponent(this.list, object, n5, false, false);
            n4 += component.getPreferredSize().height;
            ++n5;
        }
        return n4 == 0 ? 100 : n4;
    }

    protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        Point point = new Point(0, 0);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        SwingUtilities.convertPointFromScreen(point, this.comboBox);
        rectangle.x = point.x;
        rectangle.y = point.y;
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        if (SwingUtilities.isRectangleContainingRectangle(rectangle, rectangle2)) {
            return rectangle2;
        }
        return new Rectangle(0, -rectangle2.height, rectangle2.width, rectangle2.height);
    }

    protected void updateListBoxSelectionForEvent(MouseEvent mouseEvent, boolean bl) {
        Point point = mouseEvent.getPoint();
        if (this.list == null) {
            return;
        }
        int n = this.list.locationToIndex(point);
        if (n == -1) {
            n = point.y < 0 ? 0 : this.comboBox.getModel().getSize() - 1;
        }
        if (this.list.getSelectedIndex() != n) {
            this.list.setSelectedIndex(n);
            if (bl) {
                this.list.ensureIndexIsVisible(n);
            }
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                BasicComboPopup.this.uninstallComboBoxModelListeners((ComboBoxModel)propertyChangeEvent.getOldValue());
                BasicComboPopup.this.list.setModel((ComboBoxModel)propertyChangeEvent.getNewValue());
                BasicComboPopup.this.installComboBoxModelListeners((ComboBoxModel)propertyChangeEvent.getNewValue());
                if (BasicComboPopup.this.comboBox.getItemCount() > 0) {
                    BasicComboPopup.this.comboBox.setSelectedIndex(0);
                }
                if (BasicComboPopup.this.isVisible()) {
                    BasicComboPopup.this.hide();
                }
            } else if (string.equals("renderer")) {
                BasicComboPopup.this.list.setCellRenderer(BasicComboPopup.this.comboBox.getRenderer());
                if (BasicComboPopup.this.isVisible()) {
                    BasicComboPopup.this.hide();
                }
            } else if (string.equals(BasicComboPopup.LIGHTWEIGHT_KEYBOARD_NAVIGATION)) {
                Object object = propertyChangeEvent.getNewValue();
                if (object.equals(BasicComboPopup.LIGHTWEIGHT_KEYBOARD_NAVIGATION_ON)) {
                    BasicComboPopup.this.lightNav = true;
                } else if (object.equals(BasicComboPopup.LIGHTWEIGHT_KEYBOARD_NAVIGATION_OFF)) {
                    BasicComboPopup.this.lightNav = false;
                }
            } else if (string.equals("componentOrientation")) {
                ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                JList jList = BasicComboPopup.this.getList();
                if (jList != null && jList.getComponentOrientation() != componentOrientation) {
                    jList.setComponentOrientation(componentOrientation);
                }
                if (BasicComboPopup.this.scroller != null && BasicComboPopup.this.scroller.getComponentOrientation() != componentOrientation) {
                    BasicComboPopup.this.scroller.setComponentOrientation(componentOrientation);
                }
                if (componentOrientation != BasicComboPopup.this.getComponentOrientation()) {
                    BasicComboPopup.this.setComponentOrientation(componentOrientation);
                }
            }
        }
    }

    protected class ItemHandler
    implements ItemListener {
        protected ItemHandler() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1 && !BasicComboPopup.this.valueIsAdjusting) {
                BasicComboPopup.this.valueIsAdjusting = true;
                BasicComboPopup.this.syncListSelectionWithComboBoxSelection();
                BasicComboPopup.this.valueIsAdjusting = false;
                BasicComboPopup.this.list.ensureIndexIsVisible(BasicComboPopup.this.comboBox.getSelectedIndex());
            }
        }
    }

    protected class ListMouseMotionHandler
    extends MouseMotionAdapter {
        protected ListMouseMotionHandler() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            Rectangle rectangle = new Rectangle();
            BasicComboPopup.this.list.computeVisibleRect(rectangle);
            if (rectangle.contains(point)) {
                BasicComboPopup.this.valueIsAdjusting = true;
                BasicComboPopup.this.updateListBoxSelectionForEvent(mouseEvent, false);
                BasicComboPopup.this.valueIsAdjusting = false;
            }
        }
    }

    protected class ListMouseHandler
    extends MouseAdapter {
        protected ListMouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BasicComboPopup.this.comboBox.setSelectedIndex(BasicComboPopup.this.list.getSelectedIndex());
            BasicComboPopup.this.hide();
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        public void contentsChanged(ListDataEvent listDataEvent) {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            BasicComboPopup.this.valueIsAdjusting = true;
            BasicComboPopup.this.syncListSelectionWithComboBoxSelection();
            BasicComboPopup.this.valueIsAdjusting = false;
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }
    }

    protected class ListSelectionHandler
    implements ListSelectionListener {
        protected ListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!(BasicComboPopup.this.lightNav || BasicComboPopup.this.valueIsAdjusting || listSelectionEvent.getValueIsAdjusting() || BasicComboPopup.this.list.getSelectedIndex() == BasicComboPopup.this.comboBox.getSelectedIndex() || BasicComboPopup.this.list.getSelectedIndex() >= BasicComboPopup.this.comboBox.getItemCount() || BasicComboPopup.this.list.getSelectedIndex() < -1)) {
                BasicComboPopup.this.valueIsAdjusting = true;
                BasicComboPopup.this.comboBox.setSelectedIndex(BasicComboPopup.this.list.getSelectedIndex());
                BasicComboPopup.this.list.ensureIndexIsVisible(BasicComboPopup.this.list.getSelectedIndex());
                BasicComboPopup.this.valueIsAdjusting = false;
            }
        }
    }

    public class InvocationKeyHandler
    extends KeyAdapter {
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 10) {
                if (BasicComboPopup.this.isVisible()) {
                    if (BasicComboPopup.this.lightNav) {
                        BasicComboPopup.this.comboBox.setSelectedIndex(BasicComboPopup.this.list.getSelectedIndex());
                    } else {
                        BasicComboPopup.this.togglePopup();
                    }
                } else if (keyEvent.getKeyCode() == 32) {
                    BasicComboPopup.this.togglePopup();
                }
            }
        }
    }

    protected class InvocationMouseMotionHandler
    extends MouseMotionAdapter {
        protected InvocationMouseMotionHandler() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (BasicComboPopup.this.isVisible()) {
                MouseEvent mouseEvent2 = BasicComboPopup.this.convertMouseEvent(mouseEvent);
                Rectangle rectangle = new Rectangle();
                BasicComboPopup.this.list.computeVisibleRect(rectangle);
                if (mouseEvent2.getPoint().y >= rectangle.y && mouseEvent2.getPoint().y <= rectangle.y + rectangle.height - 1) {
                    Point point;
                    BasicComboPopup.this.hasEntered = true;
                    if (BasicComboPopup.this.isAutoScrolling) {
                        BasicComboPopup.this.stopAutoScrolling();
                    }
                    if (rectangle.contains(point = mouseEvent2.getPoint())) {
                        BasicComboPopup.this.valueIsAdjusting = true;
                        BasicComboPopup.this.updateListBoxSelectionForEvent(mouseEvent2, false);
                        BasicComboPopup.this.valueIsAdjusting = false;
                    }
                } else if (BasicComboPopup.this.hasEntered) {
                    int n;
                    int n2 = n = mouseEvent2.getPoint().y < rectangle.y ? 0 : 1;
                    if (BasicComboPopup.this.isAutoScrolling && BasicComboPopup.this.scrollDirection != n) {
                        BasicComboPopup.this.stopAutoScrolling();
                        BasicComboPopup.this.startAutoScrolling(n);
                    } else if (!BasicComboPopup.this.isAutoScrolling) {
                        BasicComboPopup.this.startAutoScrolling(n);
                    }
                } else if (mouseEvent.getPoint().y < 0) {
                    BasicComboPopup.this.hasEntered = true;
                    BasicComboPopup.this.startAutoScrolling(0);
                }
            }
        }
    }

    protected class InvocationMouseHandler
    extends MouseAdapter {
        protected InvocationMouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!BasicComboPopup.this.comboBox.isEnabled()) {
                return;
            }
            BasicComboPopup.this.delegateFocus(mouseEvent);
            BasicComboPopup.this.togglePopup();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            Dimension dimension = component.getSize();
            Rectangle rectangle = new Rectangle(0, 0, dimension.width - 1, dimension.height - 1);
            if (!rectangle.contains(mouseEvent.getPoint())) {
                MouseEvent mouseEvent2 = BasicComboPopup.this.convertMouseEvent(mouseEvent);
                Point point = mouseEvent2.getPoint();
                Rectangle rectangle2 = new Rectangle();
                BasicComboPopup.this.list.computeVisibleRect(rectangle2);
                if (rectangle2.contains(point)) {
                    BasicComboPopup.this.updateListBoxSelectionForEvent(mouseEvent2, false);
                    BasicComboPopup.this.comboBox.setSelectedIndex(BasicComboPopup.this.list.getSelectedIndex());
                }
                BasicComboPopup.this.hide();
            }
            BasicComboPopup.this.hasEntered = false;
            BasicComboPopup.this.stopAutoScrolling();
        }
    }
}

